/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ZeroRatingInOutService {
    private static final String IN_INCOME_REG = "tccit_in_income_reg";
    private static final String PAY_REGISTER = "tccit_pay_register";
    private static final String FINANCIAL_REGISTER = "tccit_financial_register";
    private static final String BALANCE_REGISTER = "tccit_balance_register";
    private static final String INCOME_REG_AMOUNT = "income_reg_amount";
    private static final String PAY_REG_AMOUNT = "pay_reg_amount";
    private static final String FINANCIAL_REG_AMOUNT = "financial_reg_amount";
    private static final String BALANCE_REG_AMOUNT = "balance_reg_amount";
    private static final String INCOME_REG_DATE = "income_reg_date";
    private static final String PAY_REG_DATE = "pay_reg_date";
    private static final String FINANCIAL_REG_DATE = "financial_reg_date";
    private static final String BALANCE_REG_DATE = "balance_reg_date";

    public void saveZeroRatingMiddle(List<Integer> years, Function<Integer, DynamicObject> function, Function<String, DynamicObjectCollection> entryFun) {
        BigDecimal sumIncomeAmount = BigDecimal.ZERO;
        BigDecimal sumPayAmount = BigDecimal.ZERO;
        BigDecimal sumFinancialAmount = BigDecimal.ZERO;
        BigDecimal sumIncludedAmount = BigDecimal.ZERO;
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (Integer year : years) {
            DynamicObject middle = function.apply(year);
            BigDecimal sumEntryIncomeAmount = this.sumEntryAmount(entryFun.apply(IN_INCOME_REG), this.getYearPredicate(year, INCOME_REG_DATE), INCOME_REG_AMOUNT);
            middle.set("incomeamount", (Object)sumEntryIncomeAmount);
            sumIncomeAmount = sumIncomeAmount.add(sumEntryIncomeAmount);
            middle.set("sumincomeamount", (Object)sumIncomeAmount);
            BigDecimal sumEntryPayAmount = this.sumEntryAmount(entryFun.apply(PAY_REGISTER), this.getYearPredicate(year, PAY_REG_DATE), PAY_REG_AMOUNT);
            middle.set("payamount", (Object)sumEntryPayAmount);
            sumPayAmount = sumPayAmount.add(sumEntryPayAmount);
            BigDecimal expensingamount = this.sumEntryAmount(entryFun.apply(PAY_REGISTER), this.getYearAndTypePredicate(year, PAY_REG_DATE), PAY_REG_AMOUNT);
            middle.set("expensingamount", (Object)expensingamount);
            middle.set("sumpayamount", (Object)sumPayAmount);
            BigDecimal sumEntryFinancialAmount = this.sumEntryAmount(entryFun.apply(FINANCIAL_REGISTER), this.getYearPredicate(year, FINANCIAL_REG_DATE), FINANCIAL_REG_AMOUNT);
            middle.set("financialamount", (Object)sumEntryFinancialAmount);
            sumFinancialAmount = sumFinancialAmount.add(sumEntryFinancialAmount);
            middle.set("sumfinancialamount", (Object)sumFinancialAmount);
            BigDecimal sumEntryIncludedAmount = this.sumEntryAmount(entryFun.apply(BALANCE_REGISTER), this.getYearPredicate(year, BALANCE_REG_DATE), BALANCE_REG_AMOUNT);
            middle.set("includedtaxamount", (Object)sumEntryIncludedAmount);
            sumIncludedAmount = sumIncludedAmount.add(sumEntryIncludedAmount);
            middle.set("sumincludedtaxamount", (Object)sumIncludedAmount);
            middle.set("balanceamount", (Object)middle.getBigDecimal("zeroratingamount").subtract(sumPayAmount).subtract(sumFinancialAmount).subtract(sumIncludedAmount));
            sum.add((Object)middle);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal sumEntryAmount(DynamicObjectCollection objects, Predicate<DynamicObject> predicate, String amountField) {
        return objects.stream().filter(s -> predicate.test((DynamicObject)s)).map(s -> s.getBigDecimal(amountField)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Predicate<DynamicObject> getYearPredicate(Integer year, String dateField) {
        return s -> DateUtils.getYearOfDate((Date)s.getDate(dateField)) == year;
    }

    private Predicate<DynamicObject> getYearAndTypePredicate(Integer year, String dateField) {
        return s -> DateUtils.getYearOfDate((Date)s.getDate(dateField)) == year && "2".equals(s.getString("paytype"));
    }
}

