/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.assetloss;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class AssetLossService {
    public static final String ASSET_LOSS_PRE_TAX = "tccit_asset_loss_pre_tax";
    public static final Long ZCSSLX_701030401 = 1063514984778160128L;
    public static final Long ZCSSLX_701030402 = 1063515017871215616L;

    public DynamicObject translate(String number, Map<String, DynamicObject> accDiffMap, List<DynamicObject> clearBills, long taxOrgId, Long depreuse, long defaultDepreuseId) {
        Map<Long, DynamicObject> clearBillMap = clearBills.stream().collect(Collectors.toMap(d -> d.getLong("depreuse"), d -> d));
        DynamicObject zmzj = clearBillMap.get(defaultDepreuseId);
        DynamicObject select = clearBillMap.get(depreuse);
        Long accountOrg = zmzj.getLong("org");
        String assetno = zmzj.getString("assetno");
        DynamicObject accDiff = accDiffMap.get(accountOrg + "_" + assetno);
        if (accDiff != null) {
            DynamicObject account = BusinessDataServiceHelper.newDynamicObject((String)ASSET_LOSS_PRE_TAX);
            account.set("org", (Object)taxOrgId);
            account.set("billno", (Object)number);
            account.set("org", (Object)taxOrgId);
            account.set("accountorg", (Object)accountOrg);
            account.set("assetno", (Object)accDiff.getLong("assetdata.id"));
            account.set("name", (Object)accDiff.getString("assetdata.assetname"));
            BigDecimal netamount = zmzj.getBigDecimal("netamount");
            BigDecimal preresidualval = zmzj.getBigDecimal("preresidualval");
            if (netamount.compareTo(preresidualval) == 0) {
                account.set("assetlosstype", (Object)ZCSSLX_701030401);
            } else {
                account.set("assetlosstype", (Object)ZCSSLX_701030402);
            }
            BigDecimal clearincome = zmzj.getBigDecimal("clearincome");
            BigDecimal clearfare = zmzj.getBigDecimal("clearfare");
            account.set("zcsyzzje", (Object)BigDecimalUtil.addObjects((Object[])new Object[]{clearincome, netamount.negate(), clearfare.negate()}));
            account.set("zcsszbjhx", zmzj.get("decval"));
            account.set("cleanupdate", zmzj.get("cleardate"));
            account.set("assetquantiy", zmzj.get("assetqty"));
            account.set("cleanupquantity", zmzj.get("clearqty"));
            account.set("unit", zmzj.get("measureunit"));
            account.set("zctype", (Object)accDiff.getString("zctype"));
            account.set("jszjqc", (Object)accDiff.getString("acceleratedepretype"));
            if (select != null) {
                account.set("assetorigin", select.get("assetvalue"));
                account.set("cleanupincome", select.get("clearincome"));
                account.set("cleanupfee", select.get("clearfare"));
                account.set("ljjszjtxe", select.get("addupdepre"));
            }
            BigDecimal cleanupincome = account.getBigDecimal("cleanupincome");
            BigDecimal cleanupfee = account.getBigDecimal("cleanupfee");
            BigDecimal compensateincome = account.getBigDecimal("compensateincome");
            BigDecimal assetorigin = account.getBigDecimal("assetorigin");
            BigDecimal ljjszjtxe = account.getBigDecimal("ljjszjtxe");
            BigDecimal fzcssjxzc = account.getBigDecimal("fzcssjxzc");
            account.set("zcsyssje", (Object)BigDecimalUtil.addObjects((Object[])new Object[]{cleanupincome, cleanupfee.negate(), compensateincome, assetorigin.negate(), ljjszjtxe, fzcssjxzc.negate()}));
            account.set("upstreambillno", zmzj.get("billno"));
            account.set("depreuse", (Object)depreuse);
            account.set("billstatus", (Object)"1");
            account.set("source", (Object)"system");
            return account;
        }
        return null;
    }

    public List<DynamicObject> queryExistsAccounts(long taxOrgId, Date period) {
        QFilter q1 = new QFilter("org", "=", (Object)taxOrgId);
        Date start = DateUtils.getFirstDateOfMonth((Date)period);
        Date end = DateUtils.getLastDateOfMonth((Date)period);
        QFilter q2 = new QFilter("cleanupdate", ">=", (Object)start).and("cleanupdate", "<=", (Object)end);
        QFilter q3 = new QFilter("upstreambillno", "is not null", null);
        return QueryServiceHelper.query((String)ASSET_LOSS_PRE_TAX, (String)"upstreambillno,assetno.assetcode as assetno", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public Map<String, DynamicObject> queryAccDiff(List<Long> accountOrgs, Date period) {
        QFilter q1 = new QFilter("org", "in", accountOrgs);
        Date start = DateUtils.getFirstDateOfMonth((Date)period);
        Date end = DateUtils.getLastDateOfMonth((Date)period);
        QFilter q2 = new QFilter("accountingperiod", ">=", (Object)start).and("accountingperiod", "<=", (Object)end);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tccit_tax_acce_diff", (String)"org,assetdata.id,assetdata.assetcode,assetdata.assetname,zctype,acceleratedepretype", (QFilter[])new QFilter[]{q1, q2});
        return objects.stream().collect(Collectors.toMap(d -> d.getString("org") + "_" + d.getString("assetdata.assetcode"), d -> d));
    }
}

