/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.assetloss;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.assetloss.AssetLossService;
import kd.taxc.tccit.business.taxbook.assetloss.ClearBillService;

public class AssetLossTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AssetLossTask.class);
    public static final String PARAM_JOB_NAME = "jobname";
    public static final String PARAM_ORG_ID = "orgId";
    public static final String PARAM_ORG_NAME = "orgName";
    public static final String PARAM_PERIOD = "period";
    public static final String PARAM_DEPREUSE_ID = "depreuseid";
    public static final String PARAM_DEPREUSE_NUMBER = "depreusenumber";
    public static final String PARAM_DEPREUSE_NAME = "depreusename";
    private static final int batchsize = 200;
    private ClearBillService clearBillService = new ClearBillService();
    private AssetLossService assetLossService = new AssetLossService();

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"AssetLossTask_0", (String)"taxc-tccit", (Object[])new Object[0]), null);
        long taxOrgId = Long.parseLong(String.valueOf(params.get(PARAM_ORG_ID)));
        Date period = DateUtils.stringToDate2((String)String.valueOf(params.get(PARAM_PERIOD)));
        Long depreuse = Long.parseLong(String.valueOf(params.get(PARAM_DEPREUSE_ID)));
        try {
            List accountOrgs = (List)OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)taxOrgId).getData();
            Map<String, DynamicObject> accDiffMap = this.assetLossService.queryAccDiff(accountOrgs, period);
            DynamicObject defaultDepreuse = this.clearBillService.queryDefaultDepreuse();
            if (defaultDepreuse == null) {
                this.feedbackCustomdata(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u9ed8\u8ba4\u6298\u65e7\u7528\u9014\u5361\u7247\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e00\u5f20\u9ed8\u8ba4\u6298\u65e7\u7528\u9014\u5361\u7247\uff08\u56fa\u5b9a\u8d44\u4ea7->\u57fa\u7840\u8bbe\u7f6e->\u6298\u65e7\u7528\u9014\uff09", (String)"AssetLossTask_4", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            long defaultDepreuseId = defaultDepreuse.getLong("id");
            Map<String, List<DynamicObject>> clearBillMap = this.clearBillService.queryUnSyncedData(accDiffMap, taxOrgId, accountOrgs, period, depreuse, defaultDepreuseId);
            if (EmptyCheckUtils.isEmpty(clearBillMap)) {
                this.feedbackCustomdata(ResManager.loadKDString((String)"\u5c1a\u672a\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u6e05\u7406\u5355\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"AssetLossTask_1", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            DynamicObject assetLoss = BusinessDataServiceHelper.newDynamicObject((String)"tccit_asset_loss_pre_tax");
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"tccit_asset_loss_pre_tax", (DynamicObject)assetLoss, (String)String.valueOf(taxOrgId), (int)clearBillMap.size());
            int total = clearBillMap.size();
            int progress = 0;
            ArrayList<DynamicObject> accounts = new ArrayList<DynamicObject>();
            for (Map.Entry<String, List<DynamicObject>> entry : clearBillMap.entrySet()) {
                DynamicObject account;
                List<DynamicObject> clearbills = entry.getValue();
                if (this.isStop()) {
                    this.stop();
                }
                if ((account = this.assetLossService.translate(numbers[progress], accDiffMap, clearbills, taxOrgId, depreuse, defaultDepreuseId)) != null) {
                    accounts.add(account);
                }
                if (++progress % 200 == 0) {
                    SaveServiceHelper.save((DynamicObject[])accounts.toArray(new DynamicObject[0]));
                    accounts.clear();
                }
                this.feedbackProgress(progress * 100 / total, String.valueOf(params.get(PARAM_JOB_NAME)), null);
            }
            SaveServiceHelper.save((DynamicObject[])accounts.toArray(new DynamicObject[0]));
            String orgname = String.valueOf(params.get(PARAM_ORG_NAME));
            String yearmonth = DateUtils.formatMonth((Date)period);
            String successMsg = String.format(ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7\u7a0e\u524d\u6263\u9664\u53f0\u8d26\u751f\u6210\u4efb\u52a1\u201c%1$S\u201d\u5728\u201c%2$S\u201d\u671f\u95f4\u5df2\u5b8c\u6210", (String)"AssetLossTask_2", (String)"taxc-tccit", (Object[])new Object[0]), orgname, yearmonth);
            this.feedbackCustomdata(successMsg);
            log.info(String.format("\u56fa\u5b9a\u8d44\u4ea7\u7a0e\u524d\u6263\u9664\u53f0\u8d26\u201c%1$S\u201d\u5728\u201c%2$S\u201d\u671f\u95f4\u5df2\u540c\u6b65%3$s\u6761\u6570\u636e", orgname, yearmonth, progress));
        }
        catch (Exception e) {
            String orgname = String.valueOf(params.get(PARAM_ORG_NAME));
            String yearmonth = DateUtils.formatMonth((Date)period);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7\u7a0e\u524d\u6263\u9664\u53f0\u8d26\u751f\u6210\u4efb\u52a1\u201c%1$S\u201d\u5728\u201c%2$S\u201d\u671f\u95f4\u5931\u8d25", (String)"AssetLossTask_3", (String)"taxc-tccit", (Object[])new Object[0]), orgname, yearmonth);
            log.error(errorMsg, (Throwable)e);
            this.feedbackCustomdata(errorMsg);
        }
    }

    private void feedbackCustomdata(String message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("message", message);
        this.feedbackCustomdata(result);
    }
}

