/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.assetloss;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class AssetLossTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo.isTaskEnd()) {
            e.setClearTask(true);
            String data = taskInfo.getData();
            if (EmptyCheckUtils.isNotEmpty((Object)data)) {
                Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String message = (String)customs.get("message");
                this.getMainView().showMessage(message);
            }
        } else {
            this.showProgressForm();
        }
    }

    private void showProgressForm() {
        if (!this.isExistProgressForm()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isNotBlank((CharSequence)this.getJobFormInfo().getCaption())) {
                showParameter.setCaption(this.getJobFormInfo().getCaption());
            }
            showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
            String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
            showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
            this.getMainView().showForm(showParameter);
            this.setProgressPageId(showParameter.getPageId());
        }
    }

    public boolean release() {
        TaskInfo taskInfo = this.queryTask();
        return taskInfo.isTaskEnd();
    }
}

