/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.assetloss;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AssetLossTaskService {
    public void checkOnlyOneTaskRun(Long orgId, Date period) {
        TaskInfo taskInfo;
        String taskId = this.queryTaskId(orgId, period);
        if (EmptyCheckUtils.isNotEmpty((Object)taskId) && (taskInfo = ScheduleServiceHelper.queryTask((String)taskId)) != null && !TaskStatusConstant.isEnd((String)taskInfo.getStatus())) {
            String jobId = taskInfo.getJobId();
            DbJobDao jobDao = new DbJobDao();
            JobInfo jobInfo = jobDao.get(jobId);
            long userId = jobInfo.getRunByUserId();
            List userInfos = UserServiceHelper.get(Collections.singletonList(userId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7528\u6237%s\u6b63\u5728\u540c\u6b65\u6b64\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AssetLossTaskService_0", (String)"taxc-tccit", (Object[])new Object[0]), ((Map)userInfos.get(0)).get("name")));
        }
    }

    private String queryTaskId(long orgId, Date period) {
        String jobName = this.getJobName(orgId, period);
        QFilter q1 = new QFilter("job.name", "=", (Object)jobName);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])new QFilter[]{q1}, (String)"dispatchtime desc");
        if (EmptyCheckUtils.isNotEmpty((Object)tasks)) {
            return ((DynamicObject)tasks.get(0)).getString("id");
        }
        return null;
    }

    public String getJobName(long orgId, Date period) {
        return String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u635f\u5931\u7a0e\u524d\u6263\u9664\u53f0\u8d26\u751f\u6210\u4efb\u52a1\uff1a\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u671f\u95f4", (String)"AssetLossTaskService_1", (String)"taxc-tccit", (Object[])new Object[0]), orgId, DateUtils.formatMonth((Date)period));
    }
}

