/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.assetloss;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.assetloss.AssetLossService;

public class ClearBillService {
    public static final String ENTITY = "fa_clearbill";
    private static final String FIELDS = "billno,org,cleardate,detail_entry.depreuse as depreuse,detail_entry.realcard.number as assetno,detail_entry.netamount as netamount,detail_entry.preresidualval as preresidualval,detail_entry.clearincome as clearincome,detail_entry.clearfare as clearfare,detail_entry.decval as decval,detail_entry.assetqty as assetqty,detail_entry.clearqty as clearqty,detail_entry.measureunit as measureunit,detail_entry.assetvalue as assetvalue,detail_entry.addupdepre as addupdepre";
    private AssetLossService assetLossService = new AssetLossService();

    public Map<String, List<DynamicObject>> queryUnSyncedData(Map<String, DynamicObject> accDiffMap, long taxOrgId, List<Long> accountOrgs, Date period, Long depreuse, long defaultDepreuseId) {
        List<DynamicObject> clearBills = this.queryClearBills(accountOrgs, period, depreuse, defaultDepreuseId);
        List<DynamicObject> accounts = this.assetLossService.queryExistsAccounts(taxOrgId, period);
        Map<String, DynamicObject> accountMap = accounts.stream().collect(Collectors.toMap(d -> this.formatKey(d.getString("upstreambillno"), d.getString("assetno")), d -> d));
        clearBills.removeIf(d -> {
            String billno = d.getString("billno");
            String assetno = d.getString("assetno");
            String org = d.getString("org");
            return accountMap.get(this.formatKey(billno, assetno)) != null || accDiffMap.get(this.formatKey(org, assetno)) == null;
        });
        return clearBills.stream().collect(Collectors.groupingBy(d -> this.formatKey(d.getString("billno"), d.getString("assetno"))));
    }

    private List<DynamicObject> queryClearBills(List<Long> accountOrgs, Date period, Long depreuse, long defaultDepreuseId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", accountOrgs));
        Date start = DateUtils.getFirstDateOfMonth((Date)period);
        Date end = DateUtils.getLastDateOfMonth((Date)period);
        qFilters.add(new QFilter("cleardate", ">=", (Object)start).and("cleardate", "<=", (Object)end));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!depreuse.equals(defaultDepreuseId)) {
            qFilters.add(new QFilter("detail_entry.depreuse", "in", Arrays.asList(defaultDepreuseId, depreuse)));
        } else {
            qFilters.add(new QFilter("detail_entry.depreuse", "=", (Object)depreuse));
        }
        return QueryServiceHelper.query((String)ENTITY, (String)FIELDS, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public String formatKey(String billno, String assetno) {
        return billno + "_" + assetno;
    }

    public DynamicObject queryDefaultDepreuse() {
        return QueryServiceHelper.queryOne((String)"fa_depreuse", (String)"id", (QFilter[])new QFilter[]{new QFilter("default", "=", (Object)"1")});
    }
}

