/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orggroup.TaxcOrgGroupDataServiceHelper;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;

public class BranchShareEventHandle
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(BranchShareEventHandle.class);
    private static final String PERIOD = "period";
    private static final String QYSDS = "qysds";
    private static final String TAXTYPE = "taxtype";
    private static final String BOS_ORG = "bos_org";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TCTB_ORG_GROUP_LATEST = "tctb_org_group_latest";
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";
    private static final String ENTRY_DISABLE = "entry_disable";
    private static final String ENTRY_ENABLE = "entry_enable";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";

    public Object handleEvent(KDBizEvent evt) {
        try {
            if (evt instanceof EntityEvent) {
                JSONArray jsonArray;
                JSONObject sourceObject;
                String taxtype;
                EntityEvent entityEvent = (EntityEvent)evt;
                String businesskey = (String)entityEvent.getBusinesskeys().get(0);
                String entityNumber = entityEvent.getEntityNumber();
                String operation = entityEvent.getOperation();
                String source = entityEvent.getSource();
                LOGGER.info(String.format("BranchShareEventHandle \u4e8b\u4ef6\u89e6\u53d1\u5355\u636e\u4f53\uff1a%1$s, \u64cd\u4f5c\u4ee3\u7801\uff1a%2$s \uff0c\u4f20\u5165\u53c2\u6570 %3$s", entityNumber, operation, source));
                if (TCTB_ORG_GROUP_LATEST.equals(entityNumber) && QYSDS.equals(taxtype = (sourceObject = (jsonArray = JSONObject.parseArray((String)source)).getJSONObject(0)).getString(TAXTYPE))) {
                    BranchTaxbookBusinessService.orgGroupLatestHandle(businesskey, operation, entityNumber);
                }
                if (TCTB_TAX_MAIN.equals(entityNumber)) {
                    this.taxMainHandle(operation, source);
                }
                if (BASTAX_TAXORG.equals(entityNumber)) {
                    this.bastaxTaxorgHandle(businesskey, operation);
                }
                if (BOS_ORG.equals(entityNumber)) {
                    this.bosOrgHandle(businesskey, operation);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("BranchShareEventHandle error: " + e.getMessage(), (Throwable)e);
        }
        return evt.getEventId();
    }

    private void bosOrgHandle(String orgid, String operation) {
        TaxResult taxResult = TaxcOrgGroupDataServiceHelper.queryOrgGroupByDeclaration((Long)Long.parseLong(orgid), (String)"3", (String)QYSDS, (String)"2");
        if (taxResult.isSuccess() && ((DynamicObjectCollection)taxResult.getData()).size() > 0) {
            BranchTaxbookBusinessService.orgGroupLatestHandle(((DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0)).getString("id"), operation, TCTB_ORG_GROUP_LATEST);
        }
    }

    private void taxMainHandle(String operation, String source) {
        JSONArray objects = JSONObject.parseArray((String)source);
        JSONObject jsonObject = objects.getJSONObject(0);
        JSONObject taxorg = jsonObject.getJSONObject("taxorg");
        Long orgid = taxorg.getLong("id");
        TaxResult taxResult = TaxcOrgGroupDataServiceHelper.queryOrgGroupByDeclaration((Long)orgid, (String)"3", (String)QYSDS, (String)"2");
        if (taxResult.isSuccess() && ((DynamicObjectCollection)taxResult.getData()).size() > 0) {
            BranchTaxbookBusinessService.orgGroupLatestHandle(((DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0)).getString("id"), operation, TCTB_ORG_GROUP_LATEST);
        }
    }

    private void bastaxTaxorgHandle(String orgid, String operation) {
        TaxResult taxResult = TaxcOrgGroupDataServiceHelper.queryOrgGroupByDeclaration((Long)Long.parseLong(orgid), (String)"3", (String)QYSDS, (String)"2");
        if (taxResult.isSuccess() && ((DynamicObjectCollection)taxResult.getData()).size() > 0) {
            BranchTaxbookBusinessService.orgGroupLatestHandle(((DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0)).getString("id"), operation, TCTB_ORG_GROUP_LATEST);
        }
    }
}

