/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class AppParamsUpgradeService
implements IUpgradeService {
    public static final String FETCH_TAX_SQL = "select forgid from t_tctb_tax_main where fbillstatus ='C' and fid in (select fid from t_tctb_categoryinfo where ftaxtype ='qysds' and fenable ='1');";
    public static final String FETCH_SYS_SQL = "select forgid from t_bastax_taxorg where fid in (select fid from t_bastax_taxorg_entity where fistaxpayer ='1' and fstatus ='1');";
    public static final String YJPROFITSLOGIC = "yjprofitslogic";
    public static final String BQFSE = "bqfse";
    public StringBuilder message = new StringBuilder("AppParamsUpgradeService update start");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    public String update() {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put(YJPROFITSLOGIC, BQFSE);
            List<Long> orgIds = this.getAllOrgIdOfTax();
            orgIds.stream().forEach(orgId -> AppParamsUpgradeService.saveAppParameter("tccit", orgId, paramMap));
            String string = this.message.append("add App params yj yjprofitslogic success!").toString();
            return string;
        }
        catch (Exception e) {
            h.markRollback();
            String string = e.toString();
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private List<Long> getAllOrgIdOfTax() {
        DataSet taxOrgIdDataSet = DB.queryDataSet((String)"AppParamsUpgradeService_sql1", (DBRoute)DBRoute.of((String)"taxc"), (String)FETCH_TAX_SQL);
        ArrayList<Long> taxOrgIds = new ArrayList<Long>(taxOrgIdDataSet.copy().count("FORGID", false));
        while (taxOrgIdDataSet.hasNext()) {
            Row row = taxOrgIdDataSet.next();
            taxOrgIds.add(row.getLong("FORGID"));
        }
        this.message.append("fetch tax org count:").append(taxOrgIds.size()).append("\n");
        DataSet orgIdDataSet = DB.queryDataSet((String)"AppParamsUpgradeService_sql2", (DBRoute)DBRoute.of((String)"sys"), (String)FETCH_SYS_SQL);
        ArrayList<Long> orgIds = new ArrayList<Long>(orgIdDataSet.copy().count("FORGID", false));
        while (orgIdDataSet.hasNext()) {
            Row row = orgIdDataSet.next();
            orgIds.add(row.getLong("FORGID"));
        }
        this.message.append("fetch sys org count:").append(orgIds.size()).append("\n");
        taxOrgIds.retainAll(orgIds);
        this.message.append("retainAll org count:").append(taxOrgIds.size()).append("\n");
        orgIdDataSet.close();
        taxOrgIdDataSet.close();
        return taxOrgIds;
    }

    public static void saveAppParameter(String appNumber, Long orgId, Map<String, Object> paramMap) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(orgId);
        apm.setCloudId(appInfo.getCloudId());
        apm.setViewType("15");
        SystemParamServiceHelper.saveAppParameter((AppParam)apm, paramMap);
    }
}

