/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class BranchShareBillPeriodUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(BranchShareBillPeriodUpgradeService.class);
    private static final String ENTITY_NAME = "tccit_branch_share_bill";
    private static final String PERIOD = "period";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = SUCCESS_INFO;
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        if (!this.metaIsExist(ENTITY_NAME).booleanValue()) {
            this.addLog(ERROR, String.format("meta %s is not exist!", ENTITY_NAME));
            return;
        }
        QFilter periodFilter = QFilter.isNotNull((String)PERIOD);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{periodFilter});
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,period", (QFilter[])new QFilter[]{new QFilter("id", "in", ids.stream().map(i -> i.getLong("id")).collect(Collectors.toList()))});
        if (objs.length == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            obj.set(PERIOD, (Object)DateUtils.getFirstDateOfYear((Date)obj.getDate(PERIOD)));
        }
        SaveServiceHelper.update((DynamicObject[])objs);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

