/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.formplugin.seasonal.SeasonalCalcPagePlugin;

public class DraftSeasonUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(DraftSeasonUpgradeService.class);
    private static final String TCCIT_SEASONAL_DG_BILL = "tccit_seasonal_dg_bill";
    private static final String TEMPLATE_TYPE = "draft_qysdsjb";

    public void upgrade(DynamicObject[] dynamicObjects) {
        ThreadPoolsService.getInstance().submit((Task)new SyncTask(Arrays.asList(dynamicObjects)));
    }

    public DynamicObject[] loadDatas() {
        QFilter q1 = new QFilter("type", "=", (Object)"qysdsjb");
        QFilter q2 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q3 = new QFilter("declarestatus", "=", (Object)"declared");
        QFilter q4 = new QFilter("datatype", "=", (Object)"1");
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        if (CollectionUtils.isEmpty((Collection)ids)) {
            LOGGER.info("\u67e5\u8be2\u5230\u5df2\u7533\u62a5\uff0c\u5df2\u5ba1\u6838\u7684\u7cfb\u7edf\u751f\u6210\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u5b63\u62a5\u7533\u62a5\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u51fa\u6570\u636e\u5347\u7ea7");
            return null;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.stream().map(d -> d.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
        LOGGER.info("\u67e5\u8be2\u5230\u5df2\u7533\u62a5\uff0c\u5df2\u5ba1\u6838\u7684\u7cfb\u7edf\u751f\u6210\u7684\u4f01\u4e1a\u6240\u5f97\u7a0e\u5b63\u62a5\u7533\u62a5\u6570\u636e\uff1a{}", (Object)ids.size());
        return dynamicObjects;
    }

    public void runUpgradeData(DynamicObject dynamicObject) {
        Date skssqz;
        Date skssqq;
        long org = dynamicObject.getDynamicObject("org").getLong("id");
        DynamicObjectCollection dynamicObjects = this.findDgBill(org, skssqq = dynamicObject.getDate("skssqq"), skssqz = dynamicObject.getDate("skssqz"));
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DraftSeasonUpgradeService.insertDgBill(dynamicObject);
            SeasonalCalcPagePlugin seasonalCalcPagePlugin = new SeasonalCalcPagePlugin();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("orgid", String.valueOf(org));
            customParams.put("skssqq", DateUtils.format((Date)skssqq));
            customParams.put("skssqz", DateUtils.format((Date)skssqz));
            seasonalCalcPagePlugin.calcSummery(customParams);
        }
    }

    private static void insertDgBill(DynamicObject dynamicObject) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tctb_draft_main");
        long orgid = dynamicObject.getDynamicObject("org").getLong("id");
        String billType = DeclareCompanyTypeService.getDgType(String.valueOf(orgid), DateUtils.format((Date)dynamicObject.getDate("skssqz")), "seasonal");
        object.set("org", (Object)orgid);
        object.set("billno", (Object)DraftSeasonUpgradeService.getBillNo(String.valueOf(orgid), billType));
        object.set("billstatus", (Object)"C");
        object.set("status", (Object)"3");
        object.set("startdate", (Object)dynamicObject.getDate("skssqq"));
        object.set("enddate", (Object)dynamicObject.getDate("skssqz"));
        object.set("type", (Object)billType);
        object.set("templatetype", (Object)TEMPLATE_TYPE);
        object.set("modifytime", (Object)dynamicObject.getDate("modifytime"));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private DynamicObjectCollection findDgBill(long org, Date skssqq, Date skssqz) {
        QFilter q1 = new QFilter("org", "=", (Object)org);
        QFilter q2 = new QFilter("startdate", "=", (Object)skssqq);
        QFilter q3 = new QFilter("enddate", "=", (Object)skssqz);
        QFilter q4 = new QFilter("templatetype", "=", (Object)TEMPLATE_TYPE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SEASONAL_DG_BILL, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return query;
    }

    private static String getBillNo(String orgId, String billType) {
        String draftBillName = "tctb_draft_main";
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftBillName);
        String readNumber = CodeRuleServiceHelper.getNumber((String)draftBillName, (DynamicObject)dynamicObject, (String)orgId);
        String draftNumberPrefix = "CIT-" + billType;
        readNumber = readNumber.replaceAll("X", draftNumberPrefix);
        return readNumber;
    }

    class SyncTask
    extends Task<List<DynamicObject>> {
        private List<DynamicObject> list;

        public SyncTask(List<DynamicObject> list) {
            this.list = list;
        }

        public List<List<DynamicObject>> getValue() {
            return Lists.partition(this.list, (int)10);
        }

        public List<DynamicObject> executor(List<DynamicObject> ex) {
            for (DynamicObject dynamicObject : ex) {
                DraftSeasonUpgradeService.this.runUpgradeData(dynamicObject);
            }
            return null;
        }
    }
}

