/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class SalaryAccountUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    public DynamicObject[] getCollection(Long num) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tccit_salary_account", (String)"id,org,projectorpart,accountyear,actualpay,lastyearpay,givemoney,actualpaynotax,remarks,migration", (QFilter[])new QFilter[]{new QFilter("migration", "!=", (Object)"1").and("id", ">=", (Object)num)}, (String)"id", (int)0, (int)300);
        return load;
    }

    public String getNumber(DynamicObject bill) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber("tccit_salary_intededuct", bill, null);
    }

    public String update() {
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] load = this.getCollection(0L);
            while (load.length > 0) {
                ArrayList<DynamicObject> oldList = new ArrayList<DynamicObject>(300);
                ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(1200);
                DynamicObject end = null;
                for (DynamicObject dynamicObject : load) {
                    DynamicObject newDynamicObject;
                    DynamicObject newDynamicObject0 = this.createNewDynamicObject(dynamicObject);
                    newDynamicObject0.set("money", dynamicObject.get("actualpay"));
                    newDynamicObject0.set("accounttype", (Object)"sjzf");
                    newDynamicObject0.set("salarypaytype", (Object)"1");
                    newDynamicObject0.set("pretaxdeductdate", (Object)dynamicObject.getDate("accountyear"));
                    dynamicObject.set("migration", (Object)"1");
                    oldList.add(dynamicObject);
                    newList.add(newDynamicObject0);
                    if (dynamicObject.getBigDecimal("lastyearpay").compareTo(BigDecimal.ZERO) != 0) {
                        newDynamicObject = this.createNewDynamicObject(dynamicObject);
                        newDynamicObject.set("money", dynamicObject.get("lastyearpay"));
                        newDynamicObject.set("accounttype", (Object)"sjzf");
                        newDynamicObject.set("salarypaytype", (Object)"2");
                        newDynamicObject.set("pretaxdeductdate", (Object)dynamicObject.getDate("accountyear"));
                        newList.add(newDynamicObject);
                    }
                    if (dynamicObject.getBigDecimal("givemoney").compareTo(BigDecimal.ZERO) != 0) {
                        newDynamicObject = this.createNewDynamicObject(dynamicObject);
                        newDynamicObject.set("money", dynamicObject.get("givemoney"));
                        newDynamicObject.set("accounttype", (Object)"sjzf");
                        newDynamicObject.set("salarypaytype", (Object)"3");
                        newDynamicObject.set("pretaxdeductdate", (Object)dynamicObject.getDate("accountyear"));
                        newList.add(newDynamicObject);
                    }
                    if (dynamicObject.getBigDecimal("actualpaynotax").compareTo(BigDecimal.ZERO) != 0) {
                        newDynamicObject = this.createNewDynamicObject(dynamicObject);
                        newDynamicObject.set("money", dynamicObject.get("actualpaynotax"));
                        newDynamicObject.set("accounttype", (Object)"bksqkc");
                        newList.add(newDynamicObject);
                    }
                    end = dynamicObject;
                }
                if (!oldList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])oldList.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[0]));
                    h.commit();
                }
                if (null == end) {
                    load = new DynamicObject[]{};
                    continue;
                }
                load = this.getCollection(end.getLong("id"));
            }
            DynamicObject result = QueryServiceHelper.queryOne((String)"tccit_salary_account", (String)"id", (QFilter[])new QFilter[]{new QFilter("migration", "!=", (Object)"1")});
            if (null == result) {
                String string = ResManager.loadKDString((String)"\u5de5\u8d44\u85aa\u91d1\u53f0\u8d26\u6570\u636e\u8fc1\u79fb\u6210\u529f", (String)"SalaryAccountUpgradeService_0", (String)"taxc-tccit", (Object[])new Object[0]);
                return string;
            }
            try {
                throw new Exception(ResManager.loadKDString((String)"\u5de5\u8d44\u85aa\u91d1\u53f0\u8d26\u90e8\u5206\u6570\u636e\u8fc1\u79fb\u5931\u8d25", (String)"SalaryAccountUpgradeService_1", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            catch (Exception e) {
                h.markRollback();
                String string = e.toString();
                return string;
            }
        }
    }

    public DynamicObject createNewDynamicObject(DynamicObject dynamicObject) {
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_salary_intededuct");
        long id = DBUtils.getLongId((String)"tccit_salary_intededuct");
        newDynamicObject.set("id", (Object)id);
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tccit_salary_intededuct"));
        newDynamicObject.set("billno", (Object)this.getNumber(bill));
        newDynamicObject.set("billstatus", (Object)"A");
        newDynamicObject.set("org", (Object)dynamicObject.getLong("org.id"));
        newDynamicObject.set("projectname", (Object)ResManager.loadKDString((String)"\u5de5\u8d44\u85aa\u91d1", (String)"SalaryAccountUpgradeService_2", (String)"taxc-tccit", (Object[])new Object[0]));
        newDynamicObject.set("costtype", (Object)"gzxj");
        newDynamicObject.set("costcenter", dynamicObject.get("projectorpart"));
        newDynamicObject.set("accountdate", (Object)dynamicObject.getDate("accountyear"));
        newDynamicObject.set("remarks", dynamicObject.get("remarks"));
        return newDynamicObject;
    }
}

