/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;

public class TaxBookAttachmentFileUpDataUpgradeService
implements IUpgradeService {
    private static final String LOGO_INFO = "SUCCESS!";
    public static final String BOS_IMPORTTEMPLATE = "bos_importtemplate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        StringBuilder log = new StringBuilder(LOGO_INFO);
        String info = LOGO_INFO;
        try {
            DynamicObject[] objects;
            ArrayList ImportTemplateAttachs = Lists.newArrayList((Object[])new String[]{"tccit_high_tech_account_IMPT_S", "tccit_develop_jjkc_IMPT_S"});
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)BOS_IMPORTTEMPLATE, (String)"id,attachmentfield", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)ImportTemplateAttachs)})) {
                long pkId = object.getLong("id");
                MulBasedataDynamicObjectCollection attachments = (MulBasedataDynamicObjectCollection)object.get("attachmentfield");
                InputStream in = null;
                for (DynamicObject attach : attachments) {
                    DynamicObject attachment = attach.getDynamicObject("fbasedataid");
                    String url = attachment.getString("url");
                    String fileName = attachment.getString("name");
                    try {
                        in = this.getClass().getResourceAsStream("/account/" + fileName);
                        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        String tempUrl = cache.saveAsUrl(fileName, in, 600);
                        tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
                        String persistenceUrl = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"bos", (String)BOS_IMPORTTEMPLATE, (Object)pkId, (String)fileName, (boolean)false, (boolean)false);
                        attachment.set("url", (Object)persistenceUrl);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
                        log.append("persistenceUrl =").append(persistenceUrl).append(";");
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
        }
        catch (Exception e) {
            success = false;
            log = new StringBuilder(e.getMessage() != null ? e.getMessage() : "");
            info = log.toString();
        }
        result.setLog(log.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }
}

