/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TccitRuleConfigSynUpgradeService
implements IUpgradeService {
    public static final String T_TCCIT_ALL_RULE_CONFIG = "t_tccit_all_rule_config";
    private Log LOGGER = LogFactory.getLog(TccitRuleConfigSynUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("TccitRuleConfigSynUpgradeService update start");
        long l = System.currentTimeMillis();
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)T_TCCIT_ALL_RULE_CONFIG)) {
            String query = "select fid from t_tccit_all_rule_config;";
            DataSet data = DB.queryDataSet((String)"RuleConfigSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (data.copy().count("FID", false) > 0) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            String clearTable = "delete from t_tccit_all_rule_config;";
            String clearTable_l = "delete from t_tccit_all_rule_config_l;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            try {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_profits_items")) {
                    this.synProfitsRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_preferential_item")) {
                    this.synPreferentialRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_depreciate_rule")) {
                    this.synDepreciationRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_other_rule")) {
                    this.synOtherRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_year_rule")) {
                    this.synYearRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_standbook_items")) {
                    this.synStandbookRuleToSbxConfig(message);
                }
            }
            catch (Exception e) {
                result.setLog("rule update fail");
                this.LOGGER.error("TccitRuleConfigSynUpgradeService FAILURE", (Throwable)e);
            }
        }
        message.append("\nTccitRuleConfigSynUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        result.setLog(message.toString());
        return result;
    }

    private void synProfitsRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tccit_all_rule_config(fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,1928968801094093824,fitemid,'tpo_yearitems_tree',' ' from t_tccit_profits_items;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_profits_items_l;";
        DBUtils.execute((String)updateName);
        message.append("synProfitsRuleToSbxConfig update sucess");
    }

    private void synPreferentialRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tccit_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,1928969244809516032,fitemid,'tpo_discount_tree',' ' from t_tccit_preferential_item;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_preferential_item_l;";
        DBUtils.execute((String)updateName);
        DBUtils.execute((String)"update t_tccit_all_rule_config c set fname = (select fname from t_tccit_preferential_item_l where fid=c.fid and flocaleid='zh_CN') where c.fgroupid in(1928969244809516032);");
        message.append("synPreferentialRuleToSbxConfig update sucess");
    }

    private void synDepreciationRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tccit_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,1928969677351308288,fdepreciatetypeid,'tpo_yearitems_tree',' ' from t_tccit_depreciate_rule;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_depreciate_rule_l;";
        DBUtils.execute((String)updateName);
        DBUtils.execute((String)"update t_tccit_all_rule_config c set fname = (select fname from t_tccit_depreciate_rule_l where fid=c.fid and flocaleid='zh_CN') where c.fgroupid in(1928969677351308288);");
        message.append("synDepreciationRuleToSbxConfig update sucess");
    }

    private void synOtherRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tccit_all_rule_config(fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,1928970280542557184,fitemid ,'tpo_yearitems_tree',' ' from t_tccit_other_rule;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_other_rule_l;";
        DBUtils.execute((String)updateName);
        message.append("synOtherRuleToSbxConfig update sucess");
    }

    private void synYearRuleToSbxConfig(StringBuilder message) {
        String ruleSql = "insert into t_tccit_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,' ',fruletype,forgid,%1$s,fitemid ,fitemtype ,fspap from t_tccit_year_rule where ftype = '%2$s';";
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("1928961577395311616", "income");
        map.put("1928962011790986240", "period");
        map.put("1928965294681115648", "ajust");
        map.put("1928965632825906176", "dsale");
        map.put("1928965938892657664", "zcajust");
        map.put("1928966301834171392", "srajust");
        map.put("1928966623143023616", "tssx");
        map.put("1928966964920079360", "other");
        map.put("1928967322140562432", "ssyh");
        String ids = map.keySet().stream().collect(Collectors.joining(","));
        map.forEach((k, v) -> DBUtils.execute((String)String.format(ruleSql, k, v)));
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_year_rule_l;";
        DBUtils.execute((String)updateName);
        DBUtils.execute((String)("update t_tccit_all_rule_config c set fname = (select fname from t_tccit_year_rule_l where fid=c.fid and flocaleid='zh_CN') where c.fgroupid in(" + ids + ")"));
        message.append("synYearRuleToSbxConfig update sucess");
    }

    private void synStandbookRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tccit_all_rule_config(fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fgroupid,fitemid,fitemtype,fspap) select fid,fnumber,fname ,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,' ',fruletype,forgid,1928972325081205760,fstandingbooks ,'tpo_standingbook_tree',' ' from t_tccit_standbook_items;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tccit_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tccit_standbook_items_l;";
        DBUtils.execute((String)updateName);
        message.append("synOtherRuleToSbxConfig update sucess");
    }
}

