/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TccitSharePlanSynUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("TccitSharePlanSynUpgradeService update start");
        long l = System.currentTimeMillis();
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tccit_sbx_shareplan")) {
            String query = "select fid from t_tccit_sbx_shareplan;";
            DataSet data = DB.queryDataSet((String)"TccitSharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (!data.isEmpty()) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            data.close();
            String clearTable = "delete from t_tccit_sbx_shareplan;";
            String clearTable_l = "delete from t_tccit_sbx_shareplan_l;";
            String clearTable_rule = "delete from t_tccit_shareplan_rule;";
            String clearTable_org = "delete from t_tccit_shareplan_org;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            DBUtils.execute((String)clearTable_rule);
            DBUtils.execute((String)clearTable_org);
            this.synPlanToSbxConfig(message);
        }
        message.append("\nSharePlanSynUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        result.setLog(message.toString());
        return result;
    }

    private void synPlanToSbxConfig(StringBuilder message) {
        String updatePlan = "insert into t_tccit_sbx_shareplan (fid,fname,fstatus,fenable,fcreateorgid,fautoshar,fcreatetime,fcoderuletype) select s.fentryid,e.fplanname,'C','1',e.forgid,s.fautoshar,s.fcreatetime, case e.fsharetype when 'yj' then 'GXYJ' when 'hj' then 'GXNB' else 'GXTZ' end   from t_tccit_sharing_edit e inner join t_tccit_sharing s on e.fid = s.fid;";
        DBUtils.execute((String)updatePlan);
        String updateName = "insert into t_tccit_sbx_shareplan_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fentryid, flocaleid, fname FROM t_tccit_sharing_l;";
        DBUtils.execute((String)updateName);
        String updatePlanOrg = "insert into t_tccit_shareplan_org (fid,forg,fentryid,fseq) select fentryid,forgid,fdetailid,fseq from t_tccit_sharing_orgs;";
        DBUtils.execute((String)updatePlanOrg);
        String updatePlanRule = "insert into t_tccit_shareplan_rule (fid,frule,fentryid,fseq,ftype) select fentryid,fruleid,fdetailid,fseq,case ftype when 'remincome'then 'income' when 'remperiod'then 'period' when 'remajust'then 'ajust' else ftype end from t_tccit_sharing_rules;";
        DBUtils.execute((String)updatePlanRule);
        String sql = "select fid,fcoderuletype from t_tccit_sbx_shareplan";
        DataSet data = DB.queryDataSet((String)"TccitSharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        int index = 1;
        while (data.hasNext()) {
            Row row = data.next();
            String number = String.format("CIT-OLD-%s-%06d", row.getString("FCODERULETYPE"), index);
            DBUtils.execute((String)("update t_tccit_sbx_shareplan set  fnumber = '" + number + "' where fid =" + row.getLong("FID") + ";"));
            ++index;
        }
        data.close();
        message.append("sbx  TccitSharePlanSynUpgradeService update success");
    }
}

