/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TccitShareRateUpgradeService
implements IUpgradeService {
    private static final String QUERY_UPDATE_DATA = "select fid from t_tccit_branch_share where fsharerate like '%\\%%';";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.update(), (String)"TccitShareRateUpgradeService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        return result;
    }

    public String update() {
        try {
            DynamicObject[] shareList;
            List updatePayList = DBUtils.query((String)QUERY_UPDATE_DATA);
            if (CollectionUtils.isEmpty((Collection)updatePayList)) {
                return "no data";
            }
            List shareids = updatePayList.stream().filter(s -> Objects.nonNull(s.get("Fid"))).map(u -> Long.parseLong(u.get("FID").toString())).collect(Collectors.toList());
            for (DynamicObject dynamicObject : shareList = BusinessDataServiceHelper.load((Object[])shareids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tccit_branch_share_bill"))) {
                String sharerate1 = Optional.ofNullable(dynamicObject.getString("sharerate")).map(s -> s.replaceAll("%", "")).filter(s -> StringUtil.isNotEmpty((CharSequence)s)).orElse("0");
                BigDecimal sharerate = new BigDecimal(sharerate1);
                if (sharerate.compareTo(BigDecimal.ZERO) <= 0) continue;
                dynamicObject.set("sharerate", (Object)sharerate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP));
            }
            SaveServiceHelper.save((DynamicObject[])shareList);
            return ResManager.loadKDString((String)"\u66f4\u65b0\u5206\u644a\u6bd4\u4f8b\u6210\u529f", (String)"TccitShareRateUpgradeService_1", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }
}

