/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class YearReportRuleUpgradeService
implements IUpgradeService {
    private static final String YEAR_RULE = "tccit_year_rule";
    private static final String ZJTX_RULE = "tccit_tax_acce_diff";
    private static final String TREEENTITY = "tpo_yearitems_tree";
    private static String[] ZCZJTYPE = new String[]{"7010201", "7010202", "7010203", "7010204", "7010205", "7010206"};
    private Log log = LogFactory.getLog(YearReportRuleUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.upData(), (String)"YearReportRuleUpgradeService_15", (String)"YearReportRuleUpgradeService_0", (Object[])new Object[0]));
        return result;
    }

    public String upData() {
        try {
            List<DynamicObject> rules = this.getRule();
            this.log.info("\u5168\u90e8\u89c4\u5219\u6570\u91cf\uff1a{}", (Object)rules.size());
            ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>();
            for (DynamicObject rule : rules) {
                DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
                List collect = entryentity.stream().filter(entiry -> StringUtil.isNotBlank((CharSequence)entiry.getString("conditionjson"))).collect(Collectors.toList());
                boolean change = false;
                for (DynamicObject dynamicObject : collect) {
                    String conditionJson = dynamicObject.getString("conditionjson");
                    Map<String, String> resultMap = this.changedFilter(conditionJson);
                    if (resultMap == null) continue;
                    dynamicObject.set("conditionjson", (Object)resultMap.get("json"));
                    dynamicObject.set("filtercondition", (Object)resultMap.get("name"));
                    change = true;
                }
                rule.set("entryentity", (Object)entryentity);
                if (!change) continue;
                newList.add(rule);
            }
            SaveServiceHelper.update((DynamicObject[])newList.toArray(new DynamicObject[0]));
            return ResManager.loadKDString((String)"\u6c47\u7f34\u6298\u65e7\u644a\u9500\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"YearReportRuleUpgradeService_1", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    private List<DynamicObject> getRule() {
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)TREEENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)ZCZJTYPE)});
        List typeId = typeList.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection typeList1 = QueryServiceHelper.query((String)TREEENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "in", typeId)});
        List typeId1 = typeList1.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection allLRuleList = QueryServiceHelper.query((String)YEAR_RULE, (String)"id", (QFilter[])new QFilter[]{new QFilter("item", "in", typeId1)});
        Object[] load = BusinessDataServiceHelper.load((Object[])allLRuleList.stream().map(r -> r.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YEAR_RULE));
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        CollectionUtils.addAll(rules, (Object[])load);
        return rules;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, String> changedFilter(String conditionjson) {
        HashMap<String, String> result = new HashMap<String, String>();
        JSONObject conditionjJson = JSONObject.parseObject((String)conditionjson);
        JSONArray newArr = new JSONArray();
        JSONArray filterRowArr = conditionjJson.getJSONArray("FilterRow");
        boolean changed = false;
        int arrSize = filterRowArr.size();
        block22: for (int i = 0; i < arrSize; ++i) {
            String fieldName;
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            switch (fieldName = jsonObject.getString("FieldName")) {
                case "cleandate": {
                    continue block22;
                }
                case "taxassetstype.number": {
                    continue block22;
                }
                case "enable": {
                    continue block22;
                }
                case "glqtnstzsx": {
                    jsonObject.put("FieldName", (Object)"assetdata.nodepreciation");
                    changed = true;
                    break;
                }
                case "yfxcdwxzc": {
                    jsonObject.put("FieldName", (Object)"assetdata.rdaddition");
                    changed = true;
                    break;
                }
                case "zcstatus": {
                    jsonObject.put("FieldName", (Object)"assetdata.assetstatus");
                    changed = true;
                    break;
                }
                case "jszjqc": {
                    jsonObject.put("FieldName", (Object)"acceleratedepretype");
                    changed = true;
                    break;
                }
                case "remarks": {
                    jsonObject.put("FieldName", (Object)"acceleratedepretype");
                    changed = true;
                    break;
                }
                case "taxassetstype.name": {
                    jsonObject.put("FieldName", (Object)"swzclb");
                    changed = true;
                }
            }
            newArr.add((Object)jsonObject);
        }
        String filtercondition = this.buildFilterCondition(newArr);
        if (newArr.size() == 0 && StringUtil.isBlank((CharSequence)filtercondition)) {
            result.put("json", "");
            result.put("name", filtercondition);
            return result;
        }
        if (newArr.size() == arrSize && !changed) {
            return null;
        }
        conditionjJson.put("FilterRow", (Object)newArr);
        result.put("json", conditionjJson.toJSONString());
        result.put("name", filtercondition);
        return result;
    }

    private String buildFilterCondition(JSONArray filterRowArr) {
        int size = filterRowArr.size();
        if (size == 0) {
            return "";
        }
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            String logicCode = jsonObject.getString("Logic");
            String rightBracket = jsonObject.getString("RightBracket");
            String leftBracket = jsonObject.getString("LeftBracket");
            String compareType = jsonObject.getString("CompareType");
            JSONArray value = jsonObject.getJSONArray("Value");
            ArrayList<FilterValue> filterList = new ArrayList<FilterValue>();
            for (Object val : value) {
                FilterValue filterValue = new FilterValue();
                filterValue.setId(((JSONObject)val).getString("Id"));
                filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                filterList.add(filterValue);
            }
            SimpleFilterRow row = new SimpleFilterRow(leftBracket, compareType, fieldName, rightBracket, logicCode, filterList);
            filterRow.add(row);
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(filterRow);
        filterCondition.createMetaData();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ZJTX_RULE);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }
}

