/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import kd.taxc.tccit.business.calc.CalAmount;
import kd.taxc.tccit.formplugin.account.AssetAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.DomesticAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.IncomeAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.MsjjHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.QttzHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.SejsSetzSummaryPlugin;
import kd.taxc.tccit.formplugin.account.TssxHzdgSummaryPlugin;

public enum DraftSummaryEnum {
    TSSXTZ("A105000-10", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}), "tccit_hzdg_tssxtz_sum", new TssxHzdgSummaryPlugin()),
    QTTZ("A105000-1-1", Lists.newArrayList((Object[])new String[]{"1", "2", "3"}), "tccit_hzdg_qttz_sum", new QttzHzdgSummaryPlugin()),
    DOMESTICADJUST("A100000-2", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}), "tccit_domestic_adjust", new DomesticAdjustFormPlugin()),
    INCOMEADJUST("A105000-9", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"}), "tccit_dg_income_adjust", new IncomeAdjustFormPlugin()),
    DEDUCTADJUST("A105000-2", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}), "tccit_dg_deduct_adjust", new DeductAdjustFormPlugin()),
    ASSETADJUST("A105000-4", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"}), "tccit_dg_asset_adjust", new AssetAdjustFormPlugin()),
    MSJJJJ("A105000-11", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"}), "tccit_hzdg_msjj_sum", new MsjjHzdgSummaryPlugin()),
    SEJS("A100000-3", Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"}), "tccit_setz_sejs_sum", new SejsSetzSummaryPlugin());

    private String number;
    private ArrayList<String> itemTypes;
    private String bill;
    private CalAmount calAmount;

    private DraftSummaryEnum(String number, ArrayList<String> itemTypes, String bill, CalAmount calAmount) {
        this.number = number;
        this.itemTypes = itemTypes;
        this.bill = bill;
        this.calAmount = calAmount;
    }

    public static DraftSummaryEnum getEnumByNumber(String number) {
        Optional<DraftSummaryEnum> first = Arrays.stream(DraftSummaryEnum.values()).filter(a -> a.getNumber().equals(number)).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    public String getNumber() {
        return this.number;
    }

    public ArrayList<String> getItemTypes() {
        return this.itemTypes;
    }

    public String getBill() {
        return this.bill;
    }

    public CalAmount getCalAmount() {
        return this.calAmount;
    }
}

