/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.enums;

import java.util.Arrays;

public enum RuleTypeNodeEnum {
    SRCB("srcb", "income", "tccit_year_rule", 1928961577395311616L),
    PERIODFEE("periodfee", "period", "tccit_year_rule", 1928962011790986240L),
    DEDUCTADJUST("deductadjust", "ajust", "tccit_year_rule", 1928965294681115648L),
    SAMESOLD("samesold", "dsale", "tccit_year_rule", 1928965632825906176L),
    ZCAJUST("zcajust", "zcajust", "tccit_year_rule", 1928965938892657664L),
    INCOMEADJUST("incomeadjust", "srajust", "tccit_year_rule", 1928966301834171392L),
    TSSX("tssx", "tssx", "tccit_year_rule", 1928966623143023616L),
    HJOTHER("hjother", "other", "tccit_year_rule", 1928966964920079360L),
    SSYH("ssyh", "ssyh", "tccit_year_rule", 1928967322140562432L),
    PROFITS("profits", "profits", "tccit_profits_rule", 1928968801094093824L),
    PREFERENTIAL("preferential", "income", "tccit_preferential_item", 1928969244809516032L),
    DEPRECIATION("depreciation", "depreciate", "tccit_depreciate_rule", 1928969677351308288L),
    YJOTHER("yjother", "yjother", "tccit_other_rule", 1928970280542557184L),
    STANDINGBOOK("standingbook", "standbook", "tccit_standbook_rule_item", 1928972325081205760L),
    DEFAULT("default", "", "", 0L);

    private String ruleType;
    private String type;
    private String formId;
    private Long groupId;

    private RuleTypeNodeEnum(String ruleType, String type, String formId, Long groupId) {
        this.ruleType = ruleType;
        this.type = type;
        this.formId = formId;
        this.groupId = groupId;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public String getFormId() {
        return this.formId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return this.type;
    }

    public static RuleTypeNodeEnum getStrategyByGroupId(String groupId) {
        for (RuleTypeNodeEnum value : RuleTypeNodeEnum.values()) {
            if (!value.groupId.toString().equals(groupId)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static Long getGroupId(String formId, String type) {
        return Arrays.stream(RuleTypeNodeEnum.values()).filter(s -> s.getFormId().equals(formId)).filter(s -> s.getType().equals(type)).map(s -> s.getGroupId()).findFirst().orElseGet(() -> 0L);
    }

    public static Long getGroupId(String formId) {
        return Arrays.stream(RuleTypeNodeEnum.values()).filter(s -> s.getFormId().equals(formId)).map(s -> s.getGroupId()).findFirst().orElseGet(() -> 0L);
    }
}

