/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

public enum TccitRuleQueryEnum {
    PROFITS("yj", "profitsentry", "profitscard", "profits", RuleTypeEnum.PROFITS),
    INCOME("yj", "incomeentry", "flexpanelap211", "income", RuleTypeEnum.INCOME),
    DEPRECIATE("yj", "depreciateentry", "flexpanelap2111", "depreciate", RuleTypeEnum.DEPRECIATE),
    YJ_OTHER("yj", "yjotherentry", "yjothercard", "yjother", RuleTypeEnum.YJ_OTHER),
    REMINCOME("hj", "remincomeentry", "remincomecard", "remincome", RuleTypeEnum.REMINCOME),
    REMPERIOD("hj", "remperiodentry", "flexpanelap611", "remperiod", RuleTypeEnum.REMPERIOD),
    REMAJUST("hj", "remajustentry", "flexpanelap6111", "remajust", RuleTypeEnum.REMAJUST),
    DSALE("hj", "dsaleentry", "dsalecard", "dsale", RuleTypeEnum.THINKSELL),
    ZCAJUST("hj", "zcajustentry", "zcajustcard", "zcajust", RuleTypeEnum.ASSETS),
    SRAJUST("hj", "srajustentry", "srajustcard", "srajust", RuleTypeEnum.INCOME_ADJUST),
    TSSX("hj", "tssxentry", "tssxcard", "tssx", RuleTypeEnum.TSSX),
    OTHER("hj", "otherentry", "othercard", "other", RuleTypeEnum.OTHER),
    SSYH("hj", "ssyhentry", "ssyhcard", "ssyh", RuleTypeEnum.SSYH),
    STANDBOOK("tz", "standbookentry", "standbookcard", "standbook", RuleTypeEnum.STANDBOOK);

    private String code;
    private String entity;
    private String card;
    private String name;
    private RuleTypeEnum enums;

    private TccitRuleQueryEnum(String code, String entity, String card, String name, RuleTypeEnum enums) {
        this.code = code;
        this.entity = entity;
        this.card = card;
        this.name = name;
        this.enums = enums;
    }

    public String getCode() {
        return this.code;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getCard() {
        return this.card;
    }

    public String getName() {
        return this.name;
    }

    public RuleTypeEnum getEnums() {
        return this.enums;
    }

    public static List<TccitRuleQueryEnum> getByCode(String code) {
        return Arrays.stream(TccitRuleQueryEnum.values()).filter(s -> s.getCode().equals(code)).collect(Collectors.toList());
    }
}

