/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.pojo.DateRangeVo;

public class DateRangeUtils {
    public static final String QUARTER_1 = "quarter1";
    public static final String QUARTER_2 = "quarter2";
    public static final String QUARTER_3 = "quarter3";
    public static final String QUARTER_4 = "quarter4";
    private static Map<String, List<String>> filterMap = new HashMap(){
        {
            this.put(DateRangeUtils.QUARTER_1, Lists.newArrayList((Object[])new String[]{"1", "2"}));
            this.put(DateRangeUtils.QUARTER_2, Lists.newArrayList((Object[])new String[]{"3", "4"}));
            this.put(DateRangeUtils.QUARTER_3, Lists.newArrayList((Object[])new String[]{"5", "6"}));
            this.put(DateRangeUtils.QUARTER_4, Lists.newArrayList((Object[])new String[]{"7", "8"}));
        }
    };

    public static QFilter getDateQFilter(String quarter, String year) {
        Date firstDateOfSeason = null;
        Date lastDateOfSeason = null;
        Date monthStart = null;
        Date monthend = null;
        if (QUARTER_2.equals(quarter)) {
            firstDateOfSeason = DateUtils.stringToDate((String)(year + "-01-01"));
            lastDateOfSeason = DateUtils.stringToDate((String)(year + "-03-31"));
            monthStart = DateUtils.stringToDate((String)(year + "-03-01"));
            monthend = DateUtils.stringToDate((String)(year + "-03-31"));
        } else if (QUARTER_3.equals(quarter)) {
            firstDateOfSeason = DateUtils.stringToDate((String)(year + "-04-01"));
            lastDateOfSeason = DateUtils.stringToDate((String)(year + "-06-30"));
            monthStart = DateUtils.stringToDate((String)(year + "-06-01"));
            monthend = DateUtils.stringToDate((String)(year + "-06-30"));
        } else if (QUARTER_4.equals(quarter)) {
            firstDateOfSeason = DateUtils.stringToDate((String)(year + "-07-01"));
            lastDateOfSeason = DateUtils.stringToDate((String)(year + "-09-30"));
            monthStart = DateUtils.stringToDate((String)(year + "-09-01"));
            monthend = DateUtils.stringToDate((String)(year + "-09-30"));
        }
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)firstDateOfSeason).and(new QFilter("skssqz", "=", (Object)lastDateOfSeason));
        QFilter monthFilter = new QFilter("skssqq", "=", monthStart).and(new QFilter("skssqz", "=", monthend));
        return skssqqFilter.or(monthFilter);
    }

    public static List<String> getEwblxh(String quarter) {
        ArrayList<String> result = new ArrayList<String>();
        if (quarter.equals(QUARTER_2)) {
            result.addAll((Collection)filterMap.get(QUARTER_1));
        }
        if (quarter.equals(QUARTER_3)) {
            result.addAll((Collection)filterMap.get(QUARTER_1));
            result.addAll((Collection<String>)filterMap.get(QUARTER_2));
        }
        if (quarter.equals(QUARTER_4)) {
            result.addAll((Collection<String>)filterMap.get(QUARTER_1));
            result.addAll((Collection<String>)filterMap.get(QUARTER_2));
            result.addAll((Collection<String>)filterMap.get(QUARTER_3));
        }
        return result;
    }

    public static List<String> getEwblxh(String quarter, String busRegistrationQuarter) {
        ArrayList<String> result = new ArrayList<String>();
        if (quarter.equals(QUARTER_3) && busRegistrationQuarter.equals(QUARTER_2)) {
            result.addAll((Collection)filterMap.get(QUARTER_2));
        }
        if (quarter.equals(QUARTER_4) && busRegistrationQuarter.equals(QUARTER_3)) {
            result.addAll((Collection<String>)filterMap.get(QUARTER_2));
        }
        if (quarter.equals(QUARTER_4) && busRegistrationQuarter.equals(QUARTER_2)) {
            result.addAll((Collection<String>)filterMap.get(QUARTER_2));
            result.addAll((Collection<String>)filterMap.get(QUARTER_3));
        }
        return result;
    }

    public static String getQuarter(String skssqq, String skssqz) {
        int startMonthInt = DateUtils.getMonthOfDate((Date)DateUtils.stringToDate((String)skssqq));
        int endMonthInt = DateUtils.getMonthOfDate((Date)DateUtils.stringToDate((String)skssqz));
        if (startMonthInt < 4 && startMonthInt > 0 && endMonthInt < 4 && endMonthInt > 0) {
            return QUARTER_1;
        }
        if (startMonthInt < 7 && startMonthInt > 3 && endMonthInt < 7 && endMonthInt > 3) {
            return QUARTER_2;
        }
        if (startMonthInt < 10 && startMonthInt > 6 && endMonthInt < 10 && endMonthInt > 6) {
            return QUARTER_3;
        }
        if (startMonthInt < 13 && startMonthInt > 9 && endMonthInt < 13 && endMonthInt > 9) {
            return QUARTER_4;
        }
        return "";
    }

    public static DateRangeVo initStartAndEndDate(String taxLimit, Date executeTime) {
        Date lastEndDate;
        Date lastStartDate;
        Date endDate;
        Date startDate;
        Object vo = null;
        switch (taxLimit) {
            case "year": {
                startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)executeTime, (int)-1));
                endDate = DateUtils.trunc((Date)DateUtils.getLastDateOfYear((Date)startDate));
                lastStartDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addMonth((Date)startDate, (int)-6));
                lastEndDate = DateUtils.trunc((Date)DateUtils.getLastDateOfYear((Date)lastStartDate));
                break;
            }
            case "halfyear": {
                startDate = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)executeTime, (int)-6));
                endDate = DateUtils.trunc((Date)DateUtils.getLastDateOfHalfYear((Date)startDate));
                lastStartDate = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)startDate, (int)-6));
                lastEndDate = DateUtils.trunc((Date)DateUtils.getLastDateOfHalfYear((Date)lastStartDate));
                break;
            }
            case "season": {
                startDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)executeTime, (int)-3));
                endDate = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)startDate));
                lastStartDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)startDate, (int)-3));
                lastEndDate = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)lastStartDate));
                break;
            }
            default: {
                startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)executeTime, (int)-1));
                endDate = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)startDate));
                lastStartDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)startDate, (int)-1));
                lastEndDate = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)lastStartDate));
            }
        }
        return new DateRangeVo(startDate, endDate, lastStartDate, lastEndDate);
    }

    public static Map<String, Date> getDateRange(String limit, Date now) {
        HashMap<String, Date> result = new HashMap<String, Date>(16);
        if ("month".equals(limit)) {
            result.put("startdate", DateUtils.getFirstDateOfMonth((Date)now));
            result.put("enddate", DateUtils.getLastDateOfMonth1((Date)now));
        } else if ("season".equals(limit)) {
            result.put("startdate", DateUtils.getFirstDateOfSeason((Date)now));
            result.put("enddate", DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)now)));
        } else if ("year".equals(limit)) {
            result.put("startdate", DateUtils.getFirstDateOfYear((Date)now));
            result.put("enddate", DateUtils.getLastDateOfYear((Date)now));
        }
        return result;
    }
}

