/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.common.enums.DynamicYearRuleEnum;

public class DynamicRuleTypeConstantUtils {
    private static final Map<String, List<DynamicYearRuleEnum>> nstzMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> stxsMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> zctzMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> srtzMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> tssxMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> otherMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> periodMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> incomeMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, List<DynamicYearRuleEnum>> ssyhMap = new LinkedHashMap<String, List<DynamicYearRuleEnum>>();
    private static final Map<String, Map<String, List<DynamicYearRuleEnum>>> typeMap = new LinkedHashMap<String, Map<String, List<DynamicYearRuleEnum>>>();
    private static final String[] DYNAMIC_ENTRY_PANEL = new String[]{"advconap1", "advconap2", "advconap3", "advconap4", "advconap5", "advconap6", "advconap7", "advconap8", "advconap9"};

    public static List<DynamicYearRuleEnum> getRuleTypes(String type, String itemNumber) {
        if (StringUtil.isEmpty((CharSequence)itemNumber)) {
            return null;
        }
        Map<String, List<DynamicYearRuleEnum>> stringMap = typeMap.get(type);
        if (stringMap != null) {
            List<DynamicYearRuleEnum> dynamicYearRuleEnums = DynamicRuleTypeConstantUtils.getItemList(stringMap, itemNumber);
            return dynamicYearRuleEnums;
        }
        return null;
    }

    private static List<DynamicYearRuleEnum> getItemList(Map<String, List<DynamicYearRuleEnum>> stringMap, String itemNumber) {
        List<DynamicYearRuleEnum> dynamicYearRuleEnums = stringMap.get(itemNumber);
        int length = itemNumber.length();
        for (int splitLength = 2; CollectionUtils.isEmpty(dynamicYearRuleEnums) && length > splitLength; splitLength += 2) {
            String substring = itemNumber.substring(0, length - splitLength) + "*";
            dynamicYearRuleEnums = stringMap.get(substring);
        }
        return dynamicYearRuleEnums;
    }

    public static String[] getDynamicEntryPanel() {
        return DYNAMIC_ENTRY_PANEL;
    }

    static {
        List<DynamicYearRuleEnum> list = Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SJJERULE);
        nstzMap.put("3010104", list);
        nstzMap.put("3010105", list);
        nstzMap.put("3010108", list);
        nstzMap.put("3010109", list);
        nstzMap.put("30108", list);
        List<DynamicYearRuleEnum> edu = Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SJFSJERULE);
        nstzMap.put("3010106", edu);
        nstzMap.put("3010107", edu);
        List<DynamicYearRuleEnum> qtSalary = Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SJFSJERULE, DynamicYearRuleEnum.SSJERULE3);
        nstzMap.put("3010111", qtSalary);
        List<DynamicYearRuleEnum> interest = Arrays.asList(DynamicYearRuleEnum.ZMJTFJRJKRULE, DynamicYearRuleEnum.SJZFFJRJKRULE, DynamicYearRuleEnum.CGJRQYDKRULE, DynamicYearRuleEnum.TZWDWRULE, DynamicYearRuleEnum.ZBRHBKKCRULE, DynamicYearRuleEnum.QTBKKCRULE);
        nstzMap.put("30105", interest);
        List<DynamicYearRuleEnum> value = Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SJJERULE, DynamicYearRuleEnum.BKSQLZJERULE);
        nstzMap.put("3010101", value);
        nstzMap.put("3010102", value);
        nstzMap.put("3010103", value);
        nstzMap.put("3010110", value);
        nstzMap.put("3010901", list);
        nstzMap.put("3010902", list);
        nstzMap.put("30102", Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SWKJJERULE));
        nstzMap.put("30103", Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SWKJJERULE, DynamicYearRuleEnum.BYXGXFRULE, DynamicYearRuleEnum.GJQTGXFRULE, DynamicYearRuleEnum.QTGLGXFRULE));
        nstzMap.put("3010601", Arrays.asList(DynamicYearRuleEnum.ZZJEQSRULE, DynamicYearRuleEnum.BYXKCJERULE, DynamicYearRuleEnum.BFSRJERULE, DynamicYearRuleEnum.TBJERULE));
        nstzMap.put("3010602", Arrays.asList(DynamicYearRuleEnum.ZZJEQSRULE, DynamicYearRuleEnum.SSJEQSRULE));
        nstzMap.put("3010603", Arrays.asList(DynamicYearRuleEnum.ZZJEQSRULE, DynamicYearRuleEnum.SSJEQSRULE));
        nstzMap.put("30110", Arrays.asList(DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SSJERULE));
        List<DynamicYearRuleEnum> dsale = Arrays.asList(DynamicYearRuleEnum.STXSSRRULE, DynamicYearRuleEnum.STXSCBRULE);
        stxsMap.put("501", dsale);
        stxsMap.put("501*", dsale);
        stxsMap.put("dsale_default", dsale);
        zctzMap.put("70101", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE}));
        zctzMap.put("70104", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SSJERULE}));
        zctzMap.put("70105*", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SSJERULE}));
        ArrayList zjtx = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZCZZYZKRULE, DynamicYearRuleEnum.BNZJTXZZJERULE, DynamicYearRuleEnum.LJZJTXZZJERULE, DynamicYearRuleEnum.ZCJSJCRULE, DynamicYearRuleEnum.BNSSZJTXZERULE, DynamicYearRuleEnum.LJSSZJTXJERULE});
        zctzMap.put("7010201*", zjtx);
        zctzMap.put("7010202*", zjtx);
        zctzMap.put("7010203*", zjtx);
        zctzMap.put("7010204*", zjtx);
        zctzMap.put("7010205*", zjtx);
        ArrayList zjjstx = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZCZZYZKRULE, DynamicYearRuleEnum.BNZJTXZZJERULE, DynamicYearRuleEnum.LJZJTXZZJERULE, DynamicYearRuleEnum.ZCJSJCRULE, DynamicYearRuleEnum.BNJSZJTXJERULE, DynamicYearRuleEnum.BNXSJSZCRULE, DynamicYearRuleEnum.LJJSZJTXJERULE});
        zctzMap.put("7010206*", zjjstx);
        ArrayList one = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSSUMDEPRECIATERULE, DynamicYearRuleEnum.ASSETSABNORMALINCOMERULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE, DynamicYearRuleEnum.ASSETSRESERVEVERIFYRULE});
        zctzMap.put("7010304*", one);
        zctzMap.put("7010305*", one);
        zctzMap.put("7010307*", one);
        zctzMap.put("7010311", one);
        zctzMap.put("7010312", one);
        ArrayList two = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE});
        zctzMap.put("7010301", two);
        ArrayList two2 = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE, DynamicYearRuleEnum.ASSETSRESERVEVERIFYRULE});
        zctzMap.put("7010309*", two2);
        zctzMap.put("7010310", two2);
        ArrayList three = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSABNORMALINCOMERULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE, DynamicYearRuleEnum.ASSETSRESERVEVERIFYRULE});
        zctzMap.put("7010303*", three);
        ArrayList three2 = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSABNORMALINCOMERULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE});
        zctzMap.put("7010306*", three2);
        ArrayList four = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSLOSSRULE, DynamicYearRuleEnum.ASSETSRESERVEVERIFYRULE, DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSDISPOSALINCOMERULE, DynamicYearRuleEnum.ASSETSDAMAGESINCOMERULE});
        zctzMap.put("7010308*", four);
        zctzMap.put("7010302*", four);
        ArrayList value1 = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.BNSSJERULE, DynamicYearRuleEnum.LJSSJERULE, DynamicYearRuleEnum.BNZZJERULE, DynamicYearRuleEnum.LJZZJERULE});
        ArrayList sstzzc = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SSJERULE});
        srtzMap.put("60102*", value1);
        srtzMap.put("60103", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SWKJJERULE}));
        srtzMap.put("60101*", value1);
        srtzMap.put("60104*", sstzzc);
        ArrayList tssxList = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SSJERULE});
        srtzMap.put("60105", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.CQGQTZRULE, DynamicYearRuleEnum.JRZCCSTZRULE}));
        srtzMap.put("60106", Collections.singletonList(DynamicYearRuleEnum.ZZJERULE));
        srtzMap.put("60107", tssxList);
        ArrayList tzzcczsytz = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.CJQRCZ, DynamicYearRuleEnum.SWQRCZ, DynamicYearRuleEnum.TZZCZMJZ, DynamicYearRuleEnum.TZZCJSJC});
        srtzMap.put("60108*", tzzcczsytz);
        List<DynamicYearRuleEnum> nstzRuleEnums = Collections.singletonList(DynamicYearRuleEnum.NSTZJERULE);
        tssxMap.put("80101", tssxList);
        tssxMap.put("80104", nstzRuleEnums);
        tssxMap.put("8010501", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.XSWSGCPSR, DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR, DynamicYearRuleEnum.XSWWGCPYJMLE, DynamicYearRuleEnum.ZHDXSWWGCPYJMLE}));
        tssxMap.put("8010502", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.SJFSDYYSJJFJTDZZS, DynamicYearRuleEnum.ZHSJFSDYYSJJFJTDZZS}));
        ArrayList tssx_jry = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.SNM_DKSSZBJYE, DynamicYearRuleEnum.BNM_DKSSZBJYE});
        ArrayList tssx_zxqy = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.SNM_DKZCYE, DynamicYearRuleEnum.BNM_DKZCYE, DynamicYearRuleEnum.SNM_ZYTQDKSSZBJDDKZCYE, DynamicYearRuleEnum.BNM_ZYTQDKSSZBJDDKZCYE});
        ArrayList tssx_xedk = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.SNM_DKZCYE, DynamicYearRuleEnum.BNM_DKZCYE, DynamicYearRuleEnum.SNM_DKSSZBJYE, DynamicYearRuleEnum.BNM_DKSSZBJYE, DynamicYearRuleEnum.SNM_ZYTQDKSSZBJDDKZCYE, DynamicYearRuleEnum.BNM_ZYTQDKSSZBJDDKZCYE});
        tssxMap.put("801020101", tssx_jry);
        tssxMap.put("80102010101", tssx_zxqy);
        tssxMap.put("80102010102*", tssx_zxqy);
        tssxMap.put("801020102", tssx_xedk);
        tssxMap.put("801020103", tssx_xedk);
        otherMap.put("90101", nstzRuleEnums);
        otherMap.put("90102", nstzRuleEnums);
        ArrayList qyczjdynstz = Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.YBSWCLZZJERULE, DynamicYearRuleEnum.YBSWCLSSJERULE, DynamicYearRuleEnum.TSSWCLZZJERULE, DynamicYearRuleEnum.TSSWCLSSJERULE});
        tssxMap.put("80103*", qyczjdynstz);
        tssxMap.put("8010301*", qyczjdynstz);
        tssxMap.put("8010302*", qyczjdynstz);
        tssxMap.put("8010303*", qyczjdynstz);
        tssxMap.put("8010304*", qyczjdynstz);
        List<DynamicYearRuleEnum> periodAndIncomeRules = Collections.singletonList(DynamicYearRuleEnum.PROFITRULE);
        periodMap.put("201*", periodAndIncomeRules);
        incomeMap.put("101*", periodAndIncomeRules);
        nstzMap.put("3010401", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE, DynamicYearRuleEnum.SJZCJE, DynamicYearRuleEnum.WQDHGPJ}));
        nstzMap.put("3010402*", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE}));
        nstzMap.put("3010403", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ZZJERULE}));
        ssyhMap.put("5*", Collections.singletonList(DynamicYearRuleEnum.ZZJERULE));
        ssyhMap.put("6*", Collections.singletonList(DynamicYearRuleEnum.ZZJERULE));
        ssyhMap.put("801*", Collections.singletonList(DynamicYearRuleEnum.BNXZDKDKTZE));
        ssyhMap.put("802*", Lists.newArrayList((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.BNCYXHHCTQY, DynamicYearRuleEnum.BNXZDKDKTZE}));
        ssyhMap.put("9*", Collections.singletonList(DynamicYearRuleEnum.BNYXDMDTZE));
        ssyhMap.put("7030101", Arrays.asList(DynamicYearRuleEnum.ZJCSYFHDRYGZXJ, DynamicYearRuleEnum.ZJCSYFHDRYWXYJ, DynamicYearRuleEnum.WPYFRYDLWFY, DynamicYearRuleEnum.RYRGFY));
        ssyhMap.put("7030102", Arrays.asList(DynamicYearRuleEnum.YFHDZJXHCLFY, DynamicYearRuleEnum.YFHDZJXHRLFY, DynamicYearRuleEnum.YFHDZJXHDLFY, DynamicYearRuleEnum.YYZJSYHCPSZDMJ_GYZBKFJZZF, DynamicYearRuleEnum.YYBGCGDZCDYP_YJJYBCSSDGZF, DynamicYearRuleEnum.YYSZCPDJYF, DynamicYearRuleEnum.YYYFHDDYQ_SBDYXWH_TZ_JY_WXDFY, DynamicYearRuleEnum.TGJYZLFSZRDYYYFHDDYQ_SBZLF, DynamicYearRuleEnum.ZJTRFY));
        ssyhMap.put("7030103", Arrays.asList(DynamicYearRuleEnum.YYYFHDDYQDZJF, DynamicYearRuleEnum.YYYFHDDSBDZJF, DynamicYearRuleEnum.ZJFY));
        ssyhMap.put("7030104", Arrays.asList(DynamicYearRuleEnum.YYYFHDDRJDTXFY, DynamicYearRuleEnum.YYYFHDDZLQDTXFY, DynamicYearRuleEnum.YYYFHDDFZLJSDTXFY, DynamicYearRuleEnum.WXZCTX));
        ssyhMap.put("7030105", Arrays.asList(DynamicYearRuleEnum.XCPSJF, DynamicYearRuleEnum.XGYGCZDF, DynamicYearRuleEnum.XYYZDLCSYF, DynamicYearRuleEnum.KTKFJSDXCSYF, DynamicYearRuleEnum.XCPSJFHJ));
        ssyhMap.put("7030106", Arrays.asList(DynamicYearRuleEnum.JSTSZLF_ZLFYF_ZJZXF_GXKJYFBXF, DynamicYearRuleEnum.YFCGDJS_FX_PY_LZ_JD_PS_PG_YSFY, DynamicYearRuleEnum.ZSCQDSQF_ZCF_DLF, DynamicYearRuleEnum.ZGFLF_BCYLBXF_BCYLBXF, DynamicYearRuleEnum.CLF_HYF, DynamicYearRuleEnum.QTXGFYHE));
        ssyhMap.put("7030107", Collections.singletonList(DynamicYearRuleEnum.XETZHQTFY));
        ssyhMap.put("70302", Arrays.asList(DynamicYearRuleEnum.WTJNJGHGRJXYFHDSFSDFY, DynamicYearRuleEnum.WTJWJGYFFSDFY, DynamicYearRuleEnum.YXJJKCDJWJGYFFY, DynamicYearRuleEnum.WTJWGRYFFSDFY));
        ssyhMap.put("70303", Arrays.asList(DynamicYearRuleEnum.BNFYHJE, DynamicYearRuleEnum.BNZBHJE, DynamicYearRuleEnum.BNXCWXZCTXE, DynamicYearRuleEnum.YQNDXCWXZCBNTXE, DynamicYearRuleEnum.XKCDTSSR, DynamicYearRuleEnum.DNXSYFHDZJXCCPDYDCLBF));
        typeMap.put("ajust", nstzMap);
        typeMap.put("dsale", stxsMap);
        typeMap.put("zcajust", zctzMap);
        typeMap.put("srajust", srtzMap);
        typeMap.put("tssx", tssxMap);
        typeMap.put("other", otherMap);
        typeMap.put("period", periodMap);
        typeMap.put("income", incomeMap);
        typeMap.put("ssyh", ssyhMap);
    }
}

