/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class LocalDateUtils {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd hh:mm:ss";
    private static final DateTimeFormatter FORMAT_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDate2Date(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        LocalDate localDate = LocalDateUtils.date2LocalDate(date);
        return localDate.format(FORMAT_DATE);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateUtils.date2LocalDateTime(date);
        return localDateTime.format(formatter);
    }

    public static void main(String[] args) {
        System.out.println(LocalDateUtils.date2LocalDateTime(new Date()));
        System.out.println(LocalDateUtils.date2LocalDate(new Date()));
        System.out.println(LocalDateUtils.localDate2Date(LocalDate.now()));
        System.out.println(LocalDateUtils.formatDate(new Date()));
        System.out.println(LocalDateUtils.format(new Date(), YYYY_MM_DD_HH_MM_SS));
    }
}

