/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.enums.DataDirection;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;

public class ValidateUtils {
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE = "rule";
    public static final String KEY_MSG = "msg";
    private static String[] FIELDS_SETTING = new String[]{"bizname", "table", "amountfield", "datadirection", "filtercondition", "projecttype"};
    private static String[] FIELDS_NONULL = new String[]{"bizname", "table", "amountfield", "datadirection", "absolute", "datatype"};

    private static String getErrorFormatAccounting() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08%1$s\uff09\u4e1a\u52a1\u540d\u79f0\u201c%2$s\u201d\u5361\u7247\u5b58\u5728\u95ee\u9898\uff0c\u7b2c%3$d\u884c\uff1a%4$s  %5$s  %6$s %7$s \u5df2\u5728\u201c%8$s\u201d%9$s\u5361\u7247\u4e2d\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"ValidateUtils_0", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    public static List<Map<String, Object>> checkInOneRule(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            for (int j = i + 1; j < entryentity.size(); ++j) {
                DynamicObject a1 = (DynamicObject)entryentity.get(i);
                DynamicObject a2 = (DynamicObject)entryentity.get(j);
                ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1);
            }
        }
        return msgList;
    }

    public static List<Map<String, Object>> validate(List<DynamicObject> currentRuleList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < currentRuleList.size(); ++i) {
            DynamicObject currentRule = currentRuleList.get(i);
            if (!currentRule.getBoolean("enable")) continue;
            result.addAll(ValidateUtils.checkVatrate(currentRule));
            result.addAll(ValidateUtils.checkInOneRule(currentRule));
        }
        return result;
    }

    private static void compareAccounting(DynamicObject rule1, DynamicObject rule2, List<Map<String, Object>> msgList, DynamicObject a1, DynamicObject a2, int seq) {
        for (String s : FIELDS_NONULL) {
            if (a2.get(s) != null) continue;
            return;
        }
        boolean equals = true;
        for (String field : FIELDS_SETTING) {
            if (null == a1.get(field) || a1.get(field).equals(a2.get(field))) continue;
            equals = false;
            break;
        }
        if (equals) {
            String msg = String.format(ValidateUtils.getErrorFormatAccounting(), rule2.getDynamicObject("org").getString("name"), rule2.getString("name"), seq, a2.getString("bizname"), a2.getDynamicObject("table").getString("bizname"), a2.getDynamicObject("amountfield").getString("bizsubname"), DataDirection.getDescription((String)a2.getString("datadirection")), rule1.getString("name"), rule1.getString("ruletype").equals("public") ? ResManager.loadKDString((String)"\u516c\u6709", (String)"ValidateUtils_1", (String)"taxc-tccit", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u79c1\u6709", (String)"ValidateUtils_2", (String)"taxc-tccit", (Object[])new Object[0]));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, ValidateUtils.getErrorType(rule1, rule2));
            map.put(KEY_RULE, (String)rule2);
            map.put(KEY_MSG, msg);
            msgList.add(map);
        }
    }

    private static String getErrorType(DynamicObject rule1, DynamicObject rule2) {
        String longnumber2;
        String ruletype1 = rule1.getString("ruletype");
        String ruletype2 = rule2.getString("ruletype");
        Long ruleId1 = rule1.getDynamicObject("org").getLong("id");
        Long ruleId2 = rule2.getDynamicObject("org").getLong("id");
        DynamicObjectCollection collection = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", Arrays.asList(ruleId1, ruleId2)));
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject object : collection) {
            map.put(object.getPkValue(), object);
        }
        String longnumber1 = ((DynamicObject)map.get(ruleId1)).getString("longnumber");
        if (longnumber1.startsWith(longnumber2 = ((DynamicObject)map.get(ruleId1)).getString("longnumber")) && !longnumber1.equals(longnumber2) || !ruletype1.equals(ruletype2)) {
            return "warning";
        }
        return "error";
    }

    public static List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject a1 = (DynamicObject)entryentity.get(i);
            String dataType = a1.getString("datatype");
            if (!dataType.equals(DataType.JSFLQS.getCode()) && !dataType.equals(DataType.CYSLDSQS.getCode()) || BigDecimal.ZERO.compareTo(a1.getBigDecimal("vatrate")) != 0) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, "error");
            map.put(KEY_RULE, (String)rule);
            map.put(KEY_MSG, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\uff01", (String)"ValidateUtils_3", (String)"taxc-tccit", (Object[])new Object[0]), i + 1));
            msgList.add(map);
        }
        return msgList;
    }
}

