/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.engine.refactoring.RecoupDeficitEngine;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;

public class AbstractAccountPlugin
extends AbstractFormPlugin
implements IDraftTypeObserver {
    private String entryName = "entryentity";
    private static final String[] ENTRYTYPES = new String[]{"depreciate", "origin", "normal", "quick"};
    private final List<String> ENTRYTYPE = new ArrayList<String>(Arrays.asList(ENTRYTYPES));
    private final List<String> YJ_YHXM = Lists.newArrayList((Object[])new String[]{"nontaxincome", "treducedincome", "incredincome", "incredpresent", "adddeduction"});

    public void afterBindData(EventObject e) {
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(this.getView().getFormShowParameter().getCustomParams());
        this.markEditCells(this.getEntryName(), draftTypeObjectVo.getAdjustRecord().getNumber());
    }

    protected void markEditCells(String entryName, String adjustRecordNumber) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryName);
        for (int rowIndex = 0; rowIndex < entryentity.size(); ++rowIndex) {
            DynamicObjectCollection editRowList = QueryServiceHelper.query((String)adjustRecordNumber, (String)"entrytype", (QFilter[])this.createFilter(this.createParams((DynamicObject)entryentity.get(rowIndex))));
            if (CollectionUtils.isEmpty((Collection)editRowList)) continue;
            Set<String> rowSet = editRowList.stream().map(d -> d.getString("entrytype")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(rowSet = this.adaptDraftCellName(rowSet))) continue;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
            int finalRowIndex = rowIndex;
            rowSet.forEach(r -> {
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(finalRowIndex);
                cellStyle.setFieldKey(r);
                cellStyle.setBackColor("#DCFAE4");
                entryGrid.setCellStyle(Collections.singletonList(cellStyle));
            });
        }
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return Collections.emptySet();
    }

    public Map<String, Object> createParams(DynamicObject dynamicObject) {
        return null;
    }

    private QFilter[] createFilter(Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new QFilter[0];
        }
        QFilter[] filters = null;
        Object orgid = params.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)params.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)params.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        String itemnumber = (String)params.get("itemnumber");
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        String entrytype = (String)params.get("entrytype");
        List<String> zczjEntryTypes = Arrays.asList(entrytype.split(","));
        QFilter entrytypeFilter = new QFilter("entrytype", "in", zczjEntryTypes);
        if ("0".equals(params.get("hbfnszt"))) {
            QFilter taxorgFilter = new QFilter("taxorg", "!=", (Object)Long.parseLong((String)orgid));
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if ("2".equals(params.get("declaration"))) {
            QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong((String)orgid));
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if (this.ENTRYTYPE.containsAll(zczjEntryTypes) || this.YJ_YHXM.containsAll(zczjEntryTypes) || "yjother".equals(params.get("entrytype")) && "true".equals(params.get("isByRule"))) {
            String ruleid = (String)params.get("ruleid");
            QFilter ruleidFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
            Object taxorg = params.get("taxorg");
            QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong((String)taxorg));
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, ruleidFilter, taxorgFilter};
        } else {
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        }
        return filters;
    }

    public void recalcRecoupDeficit(DraftTypeObjectVo draftTypeObjectVo, String summaryKey, List<DynamicObject> objects, Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        EngineModel model = new EngineModel(orgid, skssqq, skssqz);
        Map custom = model.getCustom();
        custom.putAll(customParams);
        DraftEngineContext draftEngineContext = new DraftEngineContext();
        draftEngineContext.getSummaryDataMap().put(summaryKey, objects);
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getRecoupDeficit().getNumber(), (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
        List<DynamicObject> dynamicObjects = new RecoupDeficitEngine(draftEngineContext).calDraftData(model);
        if (!this.checkAmountValue(dynamicObjects, "amount")) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u5f25\u8865\u4ee5\u524d\u5e74\u5ea6\u4e8f\u635f\u5e95\u7a3f\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d", (String)"AbstractAccountPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        BigDecimal newAmount = dynamicObjects.stream().filter(s -> "item9".equals(s.getString("item"))).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
        this.updateSumData(orgFilter, skssqqFilter, skssqzFilter, newAmount, draftTypeObjectVo);
    }

    public void updateSumData(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, BigDecimal newAmount, DraftTypeObjectVo draftTypeObjectVo) {
        DynamicObject object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)"8"), "1", draftTypeObjectVo);
        if (object == null) {
            return;
        }
        object.set("sumamount", (Object)newAmount);
        if (this.checkAmountValue(Collections.singletonList(object), "sumamount")) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        } else {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d", (String)"AbstractAccountPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    public DynamicObject getSeasonalCalcDet(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, QFilter typeFilter, String type, DraftTypeObjectVo draftTypeObjectVo) {
        QFilter filter = new QFilter("type", "=", (Object)type);
        return BusinessDataServiceHelper.loadSingle((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (String)"id,itemno,itemtype,sumamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, typeFilter, filter});
    }

    public boolean checkAmountValue(List<DynamicObject> sum, String field) {
        for (DynamicObject object : sum) {
            BigDecimal bigDecimal = object.getBigDecimal(field);
            String amountStr = String.valueOf(bigDecimal);
            String[] split = (amountStr = amountStr.replace("-", "")).split("\\.");
            if (split[0].length() <= 13) continue;
            return false;
        }
        return true;
    }
}

