/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.common.dto.DraftAmountDto;
import kd.taxc.tccit.common.enums.NssbDraftTypeEnum;

public abstract class AbstractEngine
extends AbstractFormPlugin
implements IEngine {
    public static final String YEAR_ADJUST_CALL_BACK = "yearAdjustCallBack";
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String[] ENTRYTYPES = new String[]{"depreciate", "origin", "normal", "quick"};
    private final List<String> ENTRYTYPE = new ArrayList<String>(Arrays.asList(ENTRYTYPES));
    private final List<String> YJ_YHXM = Lists.newArrayList((Object[])new String[]{"nontaxincome", "treducedincome", "incredincome", "incredpresent"});
    private String entryName = "entryentity";

    public void runEngine(EngineModel model) {
    }

    public Boolean canReCalc(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID);
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        String templatetype = (String)customParams.get("templatetype");
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        boolean isConfirmSave = "true".equals(customParams.get("isConfirmSave"));
        Boolean sbbDeclareStatus = "sjjt".equals(draftpurpose) ? Boolean.TRUE : this.sbbDeclareStatusEnable(orgid, skssqq, skssqz, templatetype);
        Boolean billStatus = this.draftStatusEnable(orgid, skssqq, skssqz, draftpurpose, templatetype);
        return sbbDeclareStatus != false && billStatus != false && !isConfirmSave;
    }

    public void afterBindData(EventObject e) {
        String adjustRecordNumber = NssbDraftTypeEnum.ADJUST_RECORD.getNumber();
        for (String entryName : this.getEntryName().split(",")) {
            this.markEditCells(entryName, adjustRecordNumber);
        }
    }

    public String getEntryName() {
        return this.entryName;
    }

    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet();
    }

    private QFilter[] createFilter(Map<String, Object> customParams) {
        if (customParams == null || customParams.isEmpty()) {
            return new QFilter[0];
        }
        QFilter[] filters = null;
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String itemnumber = (String)customParams.get("itemnumber");
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        String entrytype = (String)customParams.get("entrytype");
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        if ("0".equals(customParams.get("hbfnszt"))) {
            List independOrgList = (List)customParams.get("orgList");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)independOrgList);
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if ("2".equals(customParams.get("declaration"))) {
            List zjgFtzzList = (List)customParams.get("orgList");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)zjgFtzzList);
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if (this.ENTRYTYPE.contains(customParams.get("entrytype")) || this.YJ_YHXM.contains(customParams.get("entrytype")) || "yjother".equals(customParams.get("entrytype")) && "true".equals(customParams.get("isByRule"))) {
            String ruleid = (String)customParams.get("ruleid");
            QFilter ruleidFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
            Object taxorg = customParams.get("taxorg");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)new long[]{Long.parseLong(taxorg.toString()), 0L});
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, ruleidFilter, taxorgFilter};
        } else if (Lists.newArrayList((Object[])new String[]{"xswsgcpsr", "xswsgcpzwgcpqrxssr", "xswwgcpyjmle", "zhdxswwgcpyjmle", "xswsgcpsr_mll", "xswsgcpzwgcpqrxssr_mll"}).contains(customParams.get("entrytype"))) {
            String ruleid = (String)customParams.get("ruleid");
            QFilter ruleidFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, ruleidFilter};
        } else {
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        }
        return filters;
    }

    public Map<String, Object> createParams(DynamicObject row, String column) {
        return null;
    }

    protected void markEditCells(String entryName, String adjustRecordNumber) {
        if (StringUtil.isBlank((CharSequence)entryName) || StringUtil.isBlank((CharSequence)adjustRecordNumber)) {
            return;
        }
        Set<String> columns = this.linkAmountCellNames(entryName);
        if (columns.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryName);
        for (int rowIndex = 0; rowIndex < entryentity.size(); ++rowIndex) {
            DynamicObject row = (DynamicObject)entryentity.get(rowIndex);
            if (row == null) {
                return;
            }
            for (String column : columns) {
                DynamicObjectCollection editRowList;
                Map<String, Object> params = null;
                Object cell = row.get(column);
                if (cell == null || cell.toString().startsWith("<nolink>") || (params = this.createParams(row, column)) == null || CollectionUtils.isEmpty((Collection)(editRowList = QueryServiceHelper.query((String)adjustRecordNumber, (String)"entrytype", (QFilter[])this.createFilter(params))))) continue;
                this.setBackColorForCell(entryName, rowIndex, column);
            }
        }
    }

    private void setBackColorForCell(String entryName, int rowIndex, String column) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(column);
        cellStyle.setBackColor("#DCFAE4");
        entryGrid.setCellStyle(Collections.singletonList(cellStyle));
    }

    private Boolean sbbDeclareStatusEnable(String orgid, String startDate, String endDate, String templatetype) {
        String type = "qysdsnb_dg".equals(templatetype) ? "qysdsnb" : "qysdsjb";
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)type, (String)startDate, (String)endDate, null);
        if (dyo != null) {
            return "A".equals(dyo.getString("billstatus"));
        }
        return Boolean.TRUE;
    }

    private Boolean draftStatusEnable(String orgId, String startdate, String enddate, String draftpurpose, String templatetype) {
        String type = "qysdsnb_dg".equals(templatetype) ? "draft_qysdsnb" : "draft_qysdsjb";
        DynamicObject object = StatusUtils.queryOne((String)type, (String)orgId, (String)startdate, (String)enddate, (String)draftpurpose);
        if (object != null) {
            return "A".equals(object.getString("billstatus"));
        }
        return Boolean.TRUE;
    }

    protected BigDecimal getCellAmount(Map<String, Object> customParams, String columnType, String entrytype, String rowType, String itemnumber, Long ruleId, String detailEntity) {
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter});
        Optional.ofNullable(ruleId).ifPresent(r -> filters.add(new QFilter("ruleid", "=", r)));
        Optional.ofNullable(itemnumber).ifPresent(r -> filters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")))));
        DynamicObjectCollection deductTzDetails = QueryServiceHelper.query((String)detailEntity, (String)"amount,fetchamount", (QFilter[])filters.toArray(new QFilter[0]));
        BigDecimal amount = deductTzDetails.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObjectCollection adjustDetails = QueryServiceHelper.query((String)"tccit_adjust_detail", (String)"ruleid,entrytype,adjustamount,totalamount", (QFilter[])filters.toArray(new QFilter[0]));
        BigDecimal adjustamount = adjustDetails.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return amount.add(adjustamount).setScale(2, 4);
    }

    protected List<DraftAmountDto> getCellAmountList(Map<String, Object> customParams, List<String> entrytype, List<String> itemnumber, List<Long> ruleId, String detailEntity) {
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "in", entrytype);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter});
        if (CollectionUtils.isNotEmpty(ruleId)) {
            filters.add(new QFilter("ruleid", "in", ruleId));
        }
        if (CollectionUtils.isNotEmpty(itemnumber)) {
            filters.add(new QFilter("itemnumber", "in", itemnumber));
        }
        DynamicObjectCollection deductTzDetails = QueryServiceHelper.query((String)detailEntity, (String)"ruleid,entrytype,itemnumber,amount,fetchamount", (QFilter[])filters.toArray(new QFilter[0]));
        DynamicObjectCollection adjustDetails = QueryServiceHelper.query((String)"tccit_adjust_detail", (String)"ruleid,entrytype,itemnumber,adjustamount,totalamount", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<DraftAmountDto> amountList = new ArrayList<DraftAmountDto>(16);
        this.setAmount(deductTzDetails, "amount", amountList);
        this.setAmount(adjustDetails, "adjustamount", amountList);
        amountList.forEach(e -> e.setAmount(e.getAmount().setScale(2, 4)));
        return amountList;
    }

    private void setAmount(DynamicObjectCollection objectCollection, String amountKey, List<DraftAmountDto> amountList) {
        if (StringUtil.isBlank((CharSequence)amountKey)) {
            amountKey = "amount";
        }
        for (DynamicObject object : objectCollection) {
            BigDecimal amount = object.getBigDecimal(amountKey);
            String entrytype = object.getString("entrytype");
            String ruleid = object.getString("ruleid");
            String itemnumber = object.getString("itemnumber");
            DraftAmountDto draftAmountDto = amountList.stream().filter(e -> !(!e.getEntrytype().equals(entrytype) || !StringUtil.isBlank((CharSequence)ruleid) && !"0".equals(ruleid) && !e.getRuleId().equals(ruleid) || !StringUtil.isBlank((CharSequence)itemnumber) && !itemnumber.equals(e.getItemnumber()) && !e.getItemnumber().equals(itemnumber + "_"))).findFirst().orElse(null);
            if (draftAmountDto == null) {
                draftAmountDto = new DraftAmountDto();
                draftAmountDto.setAmount(amount);
                draftAmountDto.setEntrytype(entrytype);
                draftAmountDto.setRuleId(ruleid);
                draftAmountDto.setItemnumber(itemnumber);
                amountList.add(draftAmountDto);
                continue;
            }
            BigDecimal newAmount = amount.add(draftAmountDto.getAmount());
            draftAmountDto.setAmount(newAmount);
        }
    }

    protected BigDecimal getCellAmountOnlyDetail(Map<String, Object> customParams, String columnType, String entrytype, String rowType, String itemnumber, Long ruleId, String detailEntity) {
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate2((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter});
        Optional.ofNullable(ruleId).ifPresent(r -> filters.add(new QFilter("ruleid", "=", r)));
        Optional.ofNullable(itemnumber).ifPresent(r -> filters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")))));
        DynamicObject[] deductTzDetails = BusinessDataServiceHelper.load((String)detailEntity, (String)"amount,fetchamount", (QFilter[])filters.toArray(new QFilter[0]));
        BigDecimal amount = Arrays.stream(deductTzDetails).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return amount;
    }

    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(16){};
    }
}

