/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.AddDeductionService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.enums.AddDeductionScene;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;
import org.apache.commons.lang3.StringUtils;

public class AddDeductionFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean readonly;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        IDataModel model = this.getModel();
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams, draftTypeObjectVo);
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjAddDuduction().getNumber(), (String)"serialno,taxorg,org,skssqq,skssqz,rule,discounttype,itemname,income,jjkcpercent,bnyffyjjkcze", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        if (adjustAmount.length > 0) {
            genericObjects = this.mergeSaveData(genericObjects, adjustAmount);
        }
        this.getModel().deleteEntryData("entryentity");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("taxorg", dynamicObject.get("taxorg"), rowIndex);
                model.setValue("itemname", dynamicObject.get("rule"), rowIndex);
                model.setValue("discounttype", dynamicObject.get("discounttype"), rowIndex);
                model.setValue("income", dynamicObject.get("income"), rowIndex);
                model.setValue("jjkcpercent", dynamicObject.get("jjkcpercent"), rowIndex);
                model.setValue("bnyffyjjkcze", dynamicObject.get("bnyffyjjkcze"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (readonly = ((Boolean)this.getView().getFormShowParameter().getCustomParam("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String entrytype = evt.getFieldName();
        Object serialno = this.getModel().getValue("serialno", rowIndex);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = customParams.get("skssqq").toString();
        String skssqz = customParams.get("skssqz").toString();
        String org = customParams.get("orgid").toString();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String taxorg = String.valueOf(((DynamicObject)itemsEntity.getModel().getValue("taxorg")).get(0));
        String ruleid = String.valueOf(((DynamicObject)this.getModel().getValue("itemname")).get("id"));
        customParams.put("taxorg", taxorg);
        customParams.put("columnType", entrytype);
        customParams.put("entrytype", "adddeduction");
        customParams.put("itemnumber", ruleid);
        customParams.put("ruleid", ruleid);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        customParams.put("entryname", draftTypeObjectVo.getYjAddDuduction().getDetail());
        customParams.put("taxaccountserialno", serialno);
        customParams.put("draftpurpose", customParams.getOrDefault("draftpurpose", "nssb"));
        Boolean isAjsb = DeadlineService.getDeadline(taxorg);
        AddDeductionScene scene = AddDeductionService.isSuitEndDate(customParams.getOrDefault("draftpurpose", "nssb").toString(), isAjsb, DateUtils.stringToDate2((String)customParams.get("skssqz").toString()));
        if (AddDeductionScene.display_last_rule == scene) {
            BigDecimal originalamount = AddDeductionService.queryLastPeriodData(org, Long.parseLong(taxorg), skssqq, skssqz, Long.parseLong(ruleid), draftTypeObjectVo.getYjAddDuduction().getNumber());
            customParams.put("existsRules", false);
            customParams.put("originalamount", originalamount);
            customParams.put("tip", "labelap");
            customParams.put("tipContent", ResManager.loadKDString((String)"\u539f\u6570\u503c\u4e3a\u4e0a\u671f\u8ba1\u7a0e\u5e95\u7a3f\u91d1\u989d", (String)"AddDeductionFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParams(customParams);
        parameter.setFormId("tccit_detail_tz_dialog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get("orgid");
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        Date startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String ruleid = dynamicObject.getString("rule_id");
            long taxorgid = dynamicObject.getLong("taxorg_id");
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(ruleid)).filter(s -> s.getLong("taxorg") == taxorgid).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            dynamicObject.set("income", (Object)adjustAmount);
            BigDecimal rate = dynamicObject.getBigDecimal("jjkcpercent");
            BigDecimal bnyffyjjkcze = BigDecimalUtil.multiplyObject((Object)adjustAmount, (Object)rate, (int)2);
            dynamicObject.set("bnyffyjjkcze", (Object)bnyffyjjkcze);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                DeleteServiceHelper.delete((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (QFilter[])new QFilter[]{q1, q2, q3, new QFilter("type", "=", (Object)"5")});
                NontaxService.handleSummaryMiddle(Arrays.stream(dynamicObjects).collect(Collectors.toList()), "5", "bnyffyjjkcze", 3, true, 1, draftTypeObjectVo.getNontaxSummaryM().getNumber());
                List<DynamicObject> objects = Arrays.stream(dynamicObjects).collect(Collectors.toList());
                this.recalcRecoupDeficit(draftTypeObjectVo, "AddDeductionEngine_summary", objects, customParams);
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        return dynamicObjects;
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        String ruleid = (String)customParams.get("ruleid");
        if (StringUtils.isBlank((CharSequence)ruleid)) {
            return new DynamicObject[0];
        }
        QFilter ruleIdFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)ruleid).or(new QFilter("itemnumber", "=", (Object)(ruleid + "_")));
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleIdFilter, itemnumberFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,itemnumber";
        return BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return Collections.singleton("income");
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        String taxorg = obj.getString("taxorg_id");
        String ruleid = obj.getString("itemname_id");
        params.put("taxorg", taxorg);
        params.put("entrytype", "adddeduction");
        params.put("itemnumber", ruleid);
        params.put("ruleid", ruleid);
        return params;
    }
}

