/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.enums.AdvertScriptRowIndexEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.ThinkOfSellFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;

public class AdvertScriptTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_02", "001_03", "001_04", "002", "002_01", "002_02", "002_03", "003", "003_01", "003_02", "003_03", "003_04", "004", "004_01", "004_02", "005", "005_01"});
    private final Set<String> titleRows = Sets.newHashSet((Object[])new String[]{"001", "002", "003", "004", "005"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String MONEY = "money";
    private static final String ID = "id";
    private Map<Integer, BigDecimal> dataMap = new HashMap<Integer, BigDecimal>();
    private Map<String, String> projects = new HashMap<String, String>(){
        {
            this.put(AdvertScriptTZFormPlugin.MONEY, "30103");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        String selectFields = "itemno,itemtype,money";
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_advert_script", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter = new QFilter("skssqq", "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq"))))).and(new QFilter("skssqz", "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))))}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String itemType = dynamicObject.getString(ITEM_TYPE);
            DynamicObject dataEntity = (DynamicObject)entryentity.get(i);
            dot.getProperty(ITEM_NO).setValueFast((Object)dataEntity, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)dataEntity, (Object)dynamicObject.getString(ITEM_TYPE));
            dot.getProperty(MONEY).setValueFast((Object)dataEntity, (Object)(this.titleRows.contains(dynamicObject.getString(ITEM_TYPE)) ? "" : this.getFormatData(itemType, dynamicObject.getBigDecimal(MONEY).setScale(2, 4).toString())));
        }
        this.getView().updateView("entryentity");
    }

    private String getFormatData(String columnType, String data) {
        StringBuilder link = new StringBuilder("<nolink>");
        if ("002_02".equals(columnType)) {
            return link.append(DataFormat.formatRate(data)).toString();
        }
        if (StringUtil.isNotBlank((CharSequence)data)) {
            if ("001_01".equals(columnType) || "001_02".equals(columnType) || "001_03".equals(columnType) || "002_01".equals(columnType) || "004_01".equals(columnType) || "004_02".equals(columnType)) {
                return DataFormat.formatMicrometer(data);
            }
            return link.append(DataFormat.formatMicrometer(data)).toString();
        }
        return data;
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_advert_script", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct2")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            boolean exists;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_advert_script");
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set(ITEM_TYPE, (Object)this.itemTypes.get(i));
            dynamicObject.set(MONEY, this.calcAmount(this.itemTypes.get(i), MONEY, customParams));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            if (i == 6) {
                dynamicObject.set("originalmoney", (Object)this.dataMap.get(0));
            }
            if (i == 2 && !(exists = this.exists(customParams, MONEY, AdvertScriptRowIndexEnum.TWO.getEntry()))) {
                BigDecimal amount = this.getDetailAmount(customParams, MONEY, AdvertScriptRowIndexEnum.ONE.getEntry());
                dynamicObject.set("originalmoney", (Object)amount);
            }
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if (this.titleRows.contains(rowType)) {
            return "";
        }
        if ("001_01".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.ONE.getEntry(), false);
            this.dataMap.put(2, amount);
            return amount;
        }
        if ("001_02".equals(rowType)) {
            boolean exists = this.exists(customParams, columnType, AdvertScriptRowIndexEnum.TWO.getEntry());
            BigDecimal amount3 = exists ? this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.TWO.getEntry(), false) : this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.TWO.getEntry());
            this.dataMap.put(3, amount3);
            return amount3;
        }
        if ("001_03".equals(rowType)) {
            BigDecimal amount4 = this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.THREE.getEntry(), false);
            this.dataMap.put(4, amount4);
            return amount4;
        }
        if ("001_04".equals(rowType)) {
            BigDecimal amount5 = this.dataMap.get(3).subtract(this.dataMap.get(4)).setScale(2, 4);
            this.dataMap.put(5, amount5);
            return amount5;
        }
        if ("002_01".equals(rowType)) {
            String orgId = String.valueOf(customParams.get("orgid"));
            String skssqq = String.valueOf(customParams.get("skssqq"));
            String skssqz = String.valueOf(customParams.get("skssqz"));
            QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
            QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
            QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"001");
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_1_sum", (String)"amount", (QFilter[])new QFilter[]{orgIdFilter, skssqqFilter, skssqzFilter, itemtypeFilter});
            BigDecimal dgyysr = dynamicObject1 != null ? dynamicObject1.getBigDecimal("amount") : BigDecimal.ZERO;
            QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz)));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_thinkofsell_summary", (String)"sum(income) as income,sum(adjustamount) as adjustamount", (QFilter[])new QFilter[]{orgFilter, dateFilter});
            BigDecimal stxsIncome = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("income");
            BigDecimal adjustamount = this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.SIX.getEntry(), true);
            BigDecimal originalamount = stxsIncome.add(dgyysr).setScale(2, 4);
            BigDecimal xsyysr = adjustamount.add(originalamount).setScale(2, 4);
            this.dataMap.put(7, xsyysr);
            this.dataMap.put(0, originalamount);
            return xsyysr;
        }
        if ("002_02".equals(rowType)) {
            List strings = AssistService.queryAssistParams((String)"GGXCF", (String)String.valueOf(customParams.get("orgid")), (String)String.valueOf(customParams.get("skssqq")), (String)String.valueOf(customParams.get("skssqz")));
            BigDecimal amount8 = (CollectionUtils.isEmpty((Collection)strings) ? BigDecimal.valueOf(0.0) : new BigDecimal((String)strings.get(0))).setScale(2, 4);
            this.dataMap.put(8, amount8);
            return amount8;
        }
        if ("002_03".equals(rowType)) {
            BigDecimal amount9 = this.dataMap.get(7).multiply(this.dataMap.get(8)).divide(BigDecimal.valueOf(100L), 2, 4);
            this.dataMap.put(9, amount9);
            return amount9;
        }
        if ("003_01".equals(rowType)) {
            BigDecimal amount11 = (this.dataMap.get(5).compareTo(this.dataMap.get(9)) > 0 ? this.dataMap.get(5).subtract(this.dataMap.get(9)) : BigDecimal.valueOf(0.0)).setScale(2, 4);
            this.dataMap.put(11, amount11);
            return amount11;
        }
        if ("003_02".equals(rowType)) {
            BigDecimal amount12 = this.getLjjzyhndkce(customParams).setScale(2, 4);
            this.dataMap.put(12, amount12);
            return amount12;
        }
        if ("003_03".equals(rowType)) {
            BigDecimal amount13 = BigDecimal.valueOf(0.0);
            if (this.dataMap.get(5).compareTo(this.dataMap.get(9)) <= 0) {
                BigDecimal subtract = this.dataMap.get(9).subtract(this.dataMap.get(5));
                amount13 = (this.dataMap.get(12).compareTo(subtract) > 0 ? subtract : this.dataMap.get(12)).setScale(2, 4);
            }
            this.dataMap.put(13, amount13);
            return amount13;
        }
        if ("003_04".equals(rowType)) {
            BigDecimal amount14 = this.dataMap.get(11).add(this.dataMap.get(12)).subtract(this.dataMap.get(13)).setScale(2, 4);
            this.dataMap.put(14, amount14);
            return amount14;
        }
        if ("004_01".equals(rowType)) {
            BigDecimal amountTem = this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.FIFTEEN.getEntry(), false);
            BigDecimal secondMin = amountTem.compareTo(this.dataMap.get(5)) > 0 ? this.dataMap.get(5) : amountTem;
            BigDecimal amount16 = (secondMin.compareTo(this.dataMap.get(9)) > 0 ? this.dataMap.get(9) : secondMin).setScale(2, 4);
            this.dataMap.put(16, amount16);
            return amount16;
        }
        if ("004_02".equals(rowType)) {
            BigDecimal amount17 = this.getAmount(customParams, columnType, AdvertScriptRowIndexEnum.SIXTEEN.getEntry(), false);
            this.dataMap.put(17, amount17);
            return amount17;
        }
        if ("005_01".equals(rowType)) {
            BigDecimal amount19 = (this.dataMap.get(5).compareTo(this.dataMap.get(9)) > 0 ? this.dataMap.get(4).add(this.dataMap.get(5)).subtract(this.dataMap.get(9)).add(this.dataMap.get(16).subtract(this.dataMap.get(17))) : this.dataMap.get(4).add(this.dataMap.get(16)).subtract(this.dataMap.get(17)).subtract(this.dataMap.get(13))).setScale(2, 4);
            this.dataMap.put(2, amount19);
            return amount19;
        }
        return "";
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = this.projects.get(columnType);
        return this.getCellAmount(customParams, MONEY, entrytype, null, itemnumber, null, "tccit_advert_detail");
    }

    private BigDecimal getDetailAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        QFilter[] filters = this.getqFilters(customParams, columnType, entrytype);
        DynamicObject[] deductTzDetails = BusinessDataServiceHelper.load((String)"tccit_advert_detail", (String)"amount,fetchamount", (QFilter[])filters);
        if (deductTzDetails.length > 0) {
            BigDecimal amount = Arrays.stream(deductTzDetails).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            return amount.setScale(2, 4);
        }
        return BigDecimal.ZERO;
    }

    private boolean exists(Map<String, Object> customParams, String columnType, String entrytype) {
        QFilter[] filters = this.getqFilters(customParams, columnType, entrytype);
        return QueryServiceHelper.exists((String)"tccit_advert_detail", (QFilter[])filters);
    }

    private BigDecimal getOriginalmoney(Map<String, Object> customParams, String itemTypes) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_advert_script", (String)"originalmoney", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        return object == null ? BigDecimal.ZERO : object.getBigDecimal("originalmoney");
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype, boolean isAJustAmount) {
        if (!isAJustAmount) {
            return this.getAmount(customParams, columnType, entrytype);
        }
        QFilter[] filters = this.getqFilters(customParams, columnType, entrytype);
        DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)"tccit_adjust_detail", (String)"adjustamount,totalamount", (QFilter[])filters);
        BigDecimal totalamount = Arrays.stream(adjustDetails).map(s -> isAJustAmount ? s.getBigDecimal("adjustamount") : s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount.setScale(2, 4);
    }

    private QFilter[] getqFilters(Map<String, Object> customParams, String columnType, String entrytype) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        String itemnumber = this.projects.get(columnType);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        return new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        boolean exists;
        int rowIndex = evt.getRowIndex();
        String entrytype = AdvertScriptRowIndexEnum.getEntryByRowIndex(rowIndex);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", this.projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_advert_detail");
        BigDecimal sum = BigDecimal.valueOf(0.0);
        if (AdvertScriptRowIndexEnum.SIX.getEntry().equals(entrytype)) {
            String original_amount_field = "originalmoney";
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"002_01");
            QFilter qFilter2 = new QFilter("orgid", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
            QFilter qFilter1 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
            QFilter qFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_advert_script", (String)original_amount_field, (QFilter[])new QFilter[]{itemtypeFilter, qFilter, qFilter1, qFilter2});
            sum = query.stream().map(s -> StringUtil.isEmpty((CharSequence)s.getString(original_amount_field)) ? BigDecimal.ZERO : s.getBigDecimal(original_amount_field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (AdvertScriptRowIndexEnum.TWO.getEntry().equals(entrytype) && !(exists = this.exists(customParams, evt.getFieldName(), AdvertScriptRowIndexEnum.TWO.getEntry()))) {
            sum = this.getOriginalmoney(customParams, "001_02");
            customParams.put("existsRules", Boolean.FALSE);
        }
        customParams.put("originalamount", sum);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private BigDecimal getLjjzyhndkce(Map<String, Object> customParams) {
        String type = "qysdsnb";
        String orgId = String.valueOf(customParams.get("orgid"));
        String skssqq = String.valueOf(customParams.get("skssqq"));
        int year = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)skssqq));
        BigDecimal ljjzyhndkce = BigDecimal.valueOf(0.0);
        DynamicObject dynamicObject = YbnsrService.queryYbnsr((String)orgId, (String)type, (String)(year - 1 + "-01-01"), (String)(year - 1 + "-12-31"), (int)0, null);
        if (null != dynamicObject) {
            String sbbid = dynamicObject.getString(ID);
            QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter qFilter2 = new QFilter("ewblname", "=", (Object)ResManager.loadKDString((String)"\u5e7f\u544a\u8d39\u548c\u4e1a\u52a1\u5ba3\u4f20\u8d39", (String)"AdvertScriptTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tccit_qysds_a105060", (String)"ljjzyhndkce", (QFilter[])new QFilter[]{qFilter, qFilter2});
            if (dynamicObject1 != null) {
                ljjzyhndkce = dynamicObject1.getBigDecimal("ljjzyhndkce");
            }
        }
        return ljjzyhndkce;
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_advert_script", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{MONEY});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entrytype = AdvertScriptRowIndexEnum.getEntryByRowIndex(row.getInt("seq") - 1);
        customParams.put("entryname", "tccit_advert_detail");
        customParams.put("entrytype", entrytype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", this.projects.get(column));
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(AdvertScriptTZFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{A100000_1_DGFormPlugin.class.getSimpleName(), ThinkOfSellFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

