/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;

public class ApportionFormPlugin
extends AbstractAccountPlugin
implements IDraftTypeObserver {
    private static final String TAXORG = "taxorg";
    private static final String ID = "id";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TAXPAYER = "taxpayer";
    private ApportionService apportionService = new ApportionService();

    @Override
    public void afterBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObject[] dynamicObjects = this.apportionService.querySecondStepTaxSplitDraft(customParams, draftTypeObjectVo);
        this.showDynamicObject(dynamicObjects, Collections.emptyMap(), Boolean.FALSE);
    }

    private void showDynamicObject(DynamicObject[] dynamicObjects, Map<String, Object> objectMap, Boolean isSharidjyu) {
        if (dynamicObjects.length > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", dynamicObjects.length);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject dynamicObject = dynamicObjects[i];
                DynamicObject dataEntity = (DynamicObject)entryentity.get(i);
                dot.getProperty(ID).setValueFast((Object)dataEntity, dynamicObject.get(ID));
                dot.getProperty(TAXORG).setValueFast((Object)dataEntity, dynamicObject.get(TAXORG));
                dot.getProperty("unifiedsocialcode").setValueFast((Object)dataEntity, dynamicObject.get("unifiedsocialcode"));
                dot.getProperty("unifiedsocialcode1").setValueFast((Object)dataEntity, dynamicObject.get("unifiedsocialcode1"));
                DynamicObject taxorg = dynamicObject.getDynamicObject(TAXORG);
                if (null != taxorg) {
                    DynamicObject taxorgDyo = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)TAXPAYER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)taxorg.getLong(ID))});
                    String taxpayer = taxorgDyo.getString(TAXPAYER);
                    dot.getProperty("orgname").setValueFast((Object)dataEntity, (Object)taxpayer);
                } else {
                    dot.getProperty("orgname").setValueFast((Object)dataEntity, dynamicObject.get("taxorgname"));
                }
                dot.getProperty("orgname1").setValueFast((Object)dataEntity, dynamicObject.get("taxorgname1"));
                dot.getProperty("income").setValueFast((Object)dataEntity, isSharidjyu != false ? (BigDecimal)objectMap.get("income") : dynamicObject.get("income"));
                dot.getProperty("emolument").setValueFast((Object)dataEntity, isSharidjyu != false ? (BigDecimal)objectMap.get("emolument") : dynamicObject.get("emolument"));
                dot.getProperty("totalassets").setValueFast((Object)dataEntity, isSharidjyu != false ? (BigDecimal)objectMap.get("totalassets") : dynamicObject.get("totalassets"));
                dot.getProperty("rate").setValueFast((Object)dataEntity, isSharidjyu != false ? (BigDecimal)objectMap.get("rate") : dynamicObject.get("rate"));
            }
            this.getView().updateView("entryentity");
        }
    }
}

