/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.AssertAcceDepreService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;
import org.apache.commons.lang3.StringUtils;

public class AssertAcceDeprePlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    private static final String SELECTED_FIELDS = "taxorg,rule,ewblname,ewblxh,zcyz,bntotalzzdepre,bntotalsfdepre,bntotaljsdepre,zzzjje,azssybgdjsdzjje,xsjszjyhjsdzjje,currentadjustamount,preadjustamount,ispredata,zzzjje1,xsjszjyhjsdzjje1,currentadjustamount1";
    private static final String ORG = "org";
    private static final String TAXORG = "taxorg";
    private static final String ID = "id";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TAXPAYER = "taxpayer";
    private static final String ENTRY_ENTITY = "entryentity";
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private final Map<String, String> MAP = new LinkedHashMap<String, String>(){
        {
            this.put("zcyz", "origin");
            this.put("zzzjje", "depreciate");
            this.put("azssybgdjsdzjje", "normal");
            this.put("xsjszjyhjsdzjje", "quick");
            this.put("zzzjje1", "depreciate");
            this.put("xsjszjyhjsdzjje1", "quick");
        }
    };
    private static final String[] ENTRYTYPES = new String[]{"depreciate", "origin", "normal", "quick"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get(ORGID);
        String columnType = (String)customParams.get("columnType");
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid.toString()));
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams, draftTypeObjectVo);
        String startDate = (String)customParams.get(SKSSQQ);
        String endDate = (String)customParams.get(SKSSQZ);
        QFilter q1 = new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q2 = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate((String)startDate));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAssertAcce().getNumber(), (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{orgFilter, q1, q2});
        if (adjustAmount.length > 0) {
            dynamicObjects = this.mergeSaveData(dynamicObjects, adjustAmount, columnType, draftTypeObjectVo, customParams);
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (dynamicObjects.length > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dynamicObjects.length);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObjectType dot = entryEntity.getDynamicObjectType();
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject dynamicObject = dynamicObjects[i];
                DynamicObject dataEntity = (DynamicObject)entryEntity.get(i);
                DynamicObject taxorg = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)TAXPAYER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)dynamicObject.getDynamicObject(TAXORG).getLong(ID))});
                String taxpayer = taxorg.getString(TAXPAYER);
                dot.getProperty(TAXPAYER).setValueFast((Object)dataEntity, (Object)taxpayer);
                for (String field : SELECTED_FIELDS.split(",")) {
                    dot.getProperty(field).setValueFast((Object)dataEntity, dynamicObject.get(field));
                }
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts, String columnType, DraftTypeObjectVo draftTypeObjectVo, Map<String, Object> customParams) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection collect;
            if (dynamicObject.getDynamicObject(TAXORG).getLong(ID) != adjustAmounts[0].getLong(TAXORG) || CollectionUtils.isEmpty((Collection)(collect = Arrays.stream(adjustAmounts).filter(s -> {
                boolean equalEntrytype = s.getString("entrytype").equals(this.MAP.get(columnType));
                boolean equalRule = s.getLong("ruleid") == dynamicObject.getDynamicObject("rule").getLong(ID);
                return equalEntrytype & equalRule;
            }).collect(Collectors.toCollection(DynamicObjectCollection::new))))) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            switch (columnType) {
                case "zcyz": {
                    dynamicObject.set("zcyz", (Object)adjustAmount);
                    break;
                }
                case "zzzjje": {
                    dynamicObject.set("zzzjje", (Object)adjustAmount);
                    dynamicObject.set("currentadjustamount", (Object)dynamicObject.getBigDecimal("xsjszjyhjsdzjje").subtract(adjustAmount));
                    break;
                }
                case "azssybgdjsdzjje": {
                    dynamicObject.set("azssybgdjsdzjje", (Object)adjustAmount);
                    break;
                }
                case "xsjszjyhjsdzjje": {
                    dynamicObject.set("xsjszjyhjsdzjje", (Object)adjustAmount);
                    dynamicObject.set("currentadjustamount", (Object)adjustAmount.subtract(dynamicObject.getBigDecimal("zzzjje")));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        this.recalcRecoupDeficit(draftTypeObjectVo, "AssertAcceDepreEngine_summary", Arrays.stream(dynamicObjects).collect(Collectors.toList()), customParams);
        return dynamicObjects;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entrytype = evt.getFieldName();
        if (entrytype.equals("zcyz") || entrytype.equals("zzzjje") || entrytype.equals("azssybgdjsdzjje") || entrytype.equals("xsjszjyhjsdzjje") || entrytype.equals("zzzjje1") || entrytype.equals("xsjszjyhjsdzjje1")) {
            String key = ((Control)evt.getSource()).getKey();
            EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
            String number = String.valueOf(itemsEntity.getModel().getValue("ewblxh"));
            String taxorg = String.valueOf(((DynamicObject)itemsEntity.getModel().getValue(TAXORG)).get(0));
            String ruleid = String.valueOf(((DynamicObject)itemsEntity.getModel().getValue("rule")).get(ID));
            Boolean ispredata = (Boolean)itemsEntity.getModel().getValue("ispredata");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put(TAXORG, taxorg);
            customParams.put("columnType", evt.getFieldName());
            customParams.put("entrytype", this.MAP.get(entrytype));
            customParams.put("itemnumber", number);
            customParams.put("ruleid", ruleid);
            if (entrytype.equals("zzzjje1") || entrytype.equals("xsjszjyhjsdzjje1")) {
                customParams.put("noadjusttype", "1");
            }
            if (ispredata.booleanValue() && !entrytype.equals("zzzjje1") && !entrytype.equals("xsjszjyhjsdzjje1")) {
                String startDate = (String)customParams.get(SKSSQQ);
                String endDate = (String)customParams.get(SKSSQZ);
                DynamicObject preData = AssertAcceDepreService.getPreData(Long.parseLong(taxorg), Long.parseLong(ruleid), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), this.getDraftTypeObjectVo(customParams).getAssertAcce().getNumber(), customParams.getOrDefault("draftpurpose", "nssb"));
                BigDecimal originalamount = preData == null ? BigDecimal.ZERO : preData.getBigDecimal(entrytype);
                customParams.put("originalamount", originalamount);
                customParams.put("existsRules", false);
                customParams.put("tip", "labelap");
                customParams.put("tipContent", ResManager.loadKDString((String)"\u539f\u6570\u503c\u4e3a\u4e0a\u671f\u8ba1\u7a0e\u5e95\u7a3f\u91d1\u989d", (String)"AssertAcceDeprePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
            customParams.put("entryname", draftTypeObjectVo.getAssertAcce().getDetail());
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        }
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        String ruleid = (String)customParams.get("ruleid");
        if (StringUtils.isBlank((CharSequence)ruleid)) {
            return new DynamicObject[0];
        }
        QFilter ruleIdFilter = new QFilter("ruleid", "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
        Object taxorg = customParams.get(TAXORG);
        QFilter taxorgFilter = new QFilter(TAXORG, "=", (Object)Long.parseLong((String)taxorg));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter[] filters = new QFilter[]{taxorgFilter, startFilter, endFilter, ruleIdFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,itemnumber";
        return BusinessDataServiceHelper.load((String)draftTypeObjectVo.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return this.MAP.entrySet().stream().filter(m -> rowSet.contains(m.getValue())).filter(m -> !"zzzjje1".equals(m.getKey()) && !"xsjszjyhjsdzjje1".equals(m.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        String number = obj.getString("ewblxh");
        String taxorg = obj.getString("taxorg_id");
        String ruleid = obj.getString("rule_id");
        params.put(TAXORG, taxorg);
        params.put("entrytype", String.join((CharSequence)",", ENTRYTYPES));
        params.put("itemnumber", number);
        params.put("ruleid", ruleid);
        return params;
    }
}

