/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.AssetsLossTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetsReserveFormPlugin;
import kd.taxc.tccit.formplugin.account.ZcOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ZczjtxFormPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;

public class AssetAdjustFormPlugin
extends AbstractSummaryPlugin {
    private final ArrayList<String> ARRAY_LIST = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        BigDecimal result = BigDecimal.ZERO;
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        switch (rowType) {
            case "1": {
                result = this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(nstz) as nstz", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstz");
                break;
            }
            case "2": {
                result = this.getSum(rowType, columnType, "tccit_assets_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "3": {
                result = this.getSum(rowType, columnType, "tccit_assets_loss_summary", "sum(nstzje) as nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "4": {
                QFilter countFilter = new QFilter("itemtype", "=", (Object)"count");
                baseQfilters.add(countFilter);
                result = this.getOne(rowType, columnType, "tccit_zc_other_sum", "nstzje", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "nstzje");
                break;
            }
            case "5": {
                result = this.getSum(this.ARRAY_LIST, "amount");
                break;
            }
        }
        return result;
    }

    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.ASSETADJUST;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.ASSETADJUST.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(AssetAdjustFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{ZczjtxFormPlugin.class.getSimpleName(), AssetsReserveFormPlugin.class.getSimpleName(), AssetsLossTZFormPlugin.class.getSimpleName(), ZcOtherTZFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

