/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class AssetExpenseFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String SUMMARY_ENTRY_NAME = "tccit_zctz_expense_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_zctz_expense_det";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_NAME = "itemname";
    public static final String NAME = "name";
    public static final String RULE_ID = "ruleid";
    public static final String ZZJE = "zzje";
    public static final String TAX_AMOUNT = "taxamount";
    public static final String NSTZJE = "nstzje";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private Set<String> itemTypes = YearAccEngine.getEntityItemMapping().get("tccit_zctz_expense_det").stream().collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, SUMMARY_ENTRY_NAME, this.itemTypes, RULE_DETAIL_ENTRY_NAME, RuleTypeEnum.ASSETS);
        }
        this.initData(SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    public void initData(String summaryEntryName, Set<String> itemTypes) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,itemname,name,zzje,taxamount,nstzje";
        DynamicObjectCollection list = QueryServiceHelper.query((String)summaryEntryName, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", list.size() + 1);
        int rowIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)list.get(i);
            model.setValue(ITEM_NO, (Object)dynamicObject.getString(ITEM_NO), rowIndex);
            model.setValue(ITEM_NAME, (Object)dynamicObject.getString(ITEM_NAME), rowIndex);
            model.setValue(NAME, (Object)dynamicObject.getString(NAME), rowIndex);
            Long ruleId = dynamicObject.getLong(RULE_ID);
            model.setValue(RULE_ID, (Object)ruleId, rowIndex);
            model.setValue(ZZJE, (Object)this.formatData(dynamicObject.getBigDecimal(ZZJE), ZZJE, ruleId), rowIndex);
            model.setValue(TAX_AMOUNT, (Object)this.formatData(dynamicObject.getBigDecimal(TAX_AMOUNT), TAX_AMOUNT, ruleId), rowIndex);
            model.setValue(NSTZJE, (Object)this.formatData(dynamicObject.getBigDecimal(NSTZJE), NSTZJE, ruleId), rowIndex);
            ++rowIndex;
        }
        this.appendRow(orgid, skssqq, skssqz, model, rowIndex, summaryEntryName);
    }

    private String formatData(BigDecimal data, String columnType, Long ruleId) {
        StringBuilder link = new StringBuilder("<nolink>");
        String amount = data.setScale(2, 4).toString();
        if (0L == ruleId) {
            if (columnType.equals(NSTZJE)) {
                return DataFormat.formatMicrometer(amount);
            }
            return link.append(DataFormat.formatMicrometer(amount)).toString();
        }
        return DataFormat.formatMicrometer(amount);
    }

    public DynamicObjectCollection calc(Map<String, Object> customParams, String summaryEntryName, Set<String> itemTypes, String ruleDetailEntryName, RuleTypeEnum typeEnum) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz, summaryEntryName, itemTypes);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("assetexpense")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), typeEnum);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && itemTypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        int index = 0;
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)summaryEntryName);
            String itemNumber = dynamicObject.getDynamicObject("item").getString("number");
            String itemName = dynamicObject.getDynamicObject("item").getString(NAME);
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(ITEM_TYPE, (Object)itemNumber);
            dynamicObject2.set(ITEM_NAME, (Object)itemName);
            dynamicObject2.set(NAME, (Object)dynamicObject.getString(NAME));
            dynamicObject2.set(RULE_ID, (Object)dynamicObject.getString("id"));
            dynamicObject2.set(ZZJE, (Object)this.calcAmount(dynamicObject.getString("id"), ZZJE, customParams, ruleDetailEntryName, itemNumber));
            dynamicObject2.set(TAX_AMOUNT, (Object)this.calcAmount(dynamicObject.getString("id"), TAX_AMOUNT, customParams, ruleDetailEntryName, itemNumber));
            dynamicObject2.set(NSTZJE, (Object)this.calcAmount(dynamicObject.getString("id"), NSTZJE, customParams, ruleDetailEntryName, itemNumber));
            dynamicObject2.set("orgid", (Object)orgid);
            dynamicObject2.set("skssqq", (Object)skssqq);
            dynamicObject2.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String summaryEntryName, Set<String> itemTypes) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)summaryEntryName, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private void appendRow(Long orgid, Date skssqq, Date skssqz, IDataModel model, int rowIndex, String summaryEntryName) {
        model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
        model.setValue(ITEM_NAME, (Object)"*", rowIndex);
        model.setValue(NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AssetExpenseFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(ZZJE, (Object)this.formatData(this.getSum(ZZJE), "", 0L), rowIndex);
        model.setValue(TAX_AMOUNT, (Object)this.formatData(this.getSum(TAX_AMOUNT), "", 0L), rowIndex);
        model.setValue(NSTZJE, (Object)this.formatData(this.getSum(NSTZJE), NSTZJE, 0L), rowIndex);
    }

    private BigDecimal getSum(String columnType) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : this.dataMap.entrySet()) {
            if (!entry.getKey().endsWith(columnType)) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, String ruleDetailEntryName, String itemNumber) {
        if (ZZJE.equals(columnType)) {
            BigDecimal amount = this.getAmount(rowType, customParams, columnType, ZZJE, ruleDetailEntryName);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if (TAX_AMOUNT.equals(columnType)) {
            BigDecimal taxAmount = this.getAmount(rowType, customParams, columnType, "ssje", ruleDetailEntryName);
            this.dataMap.put(this.getKey(rowType, columnType), taxAmount);
            return taxAmount;
        }
        if (NSTZJE.equals(columnType)) {
            BigDecimal zzjeAmount = this.dataMap.get(this.getKey(rowType, ZZJE));
            BigDecimal taxAmount = this.dataMap.get(this.getKey(rowType, TAX_AMOUNT));
            BigDecimal taxIncome = BigDecimal.ZERO;
            taxIncome = "7010503".equals(itemNumber) ? taxAmount.subtract(zzjeAmount).setScale(2, 4) : zzjeAmount.subtract(taxAmount).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), taxIncome);
            return taxIncome;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(String ruleid, Map<String, Object> customParams, String columnType, String entrytype, String ruleDetailEntryName) {
        return this.getCellAmount(customParams, columnType, entrytype, null, null, Long.valueOf(ruleid), ruleDetailEntryName);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULE_ID));
        if (ruleid.equals("0")) {
            return;
        }
        String fieldName = evt.getFieldName();
        String entrytype = fieldName.equals(ZZJE) ? ZZJE : "ssje";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, SUMMARY_ENTRY_NAME, this.itemTypes, RULE_DETAIL_ENTRY_NAME, RuleTypeEnum.ASSETS);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE, TAX_AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULE_ID);
        String entrytype = column.equals(ZZJE) ? ZZJE : "ssje";
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", entrytype);
        customParams.put("columnType", column);
        customParams.put(RULE_ID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

