/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.formplugin.account.AbstractAccountPlugin;

public class AssetsDataFormPlugin
extends AbstractAccountPlugin
implements HyperLinkClickListener,
IDraftTypeObserver {
    private String fields = "type,bqamount,bjamount";
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean readonly;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Boolean isAjflag = DeadlineService.getDeadline(orgid.toString(), customParams.getOrDefault("draftpurpose", "nssb"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        int month = DateUtils.getMonthOfDate((Date)skssqq);
        DynamicObject[] adjustAmount = this.getAdjustAmount(customParams);
        IDataModel model = this.getModel();
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(customParams);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeVoObject.getYjAssets().getNumber(), (String)"type,bqamount,bjamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter}, (String)"type");
        if (adjustAmount.length > 0) {
            dynamicObjects = this.mergeSaveData(dynamicObjects, adjustAmount, isAjflag, month);
        }
        model.deleteEntryData("entryentity");
        if (dynamicObjects.length > 0) {
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.length);
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            DynamicObjectType dot = entryentity.getDynamicObjectType();
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject dataEntity = (DynamicObject)entryentity.get(rowIndex);
                for (String field : this.fields.split(",")) {
                    dot.getProperty(field).setValueFast((Object)dataEntity, dynamicObject.get(field));
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{field});
                }
                ++rowIndex;
            }
            this.getView().updateView("entryentity");
        }
        if (readonly = ((Boolean)this.getView().getFormShowParameter().getCustomParam("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private DynamicObject[] mergeSaveData(DynamicObject[] dynamicObjects, DynamicObject[] adjustAmounts, Boolean isAjflag, int month) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String type = dynamicObject.getString("type");
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals(type) || s.getString("itemnumber").equals(type + "_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal bqamount = adjustAmount.divide(new BigDecimal("10000"), 2, 4);
            dynamicObject.set("bqamount", (Object)bqamount);
            if (isAjflag.booleanValue()) {
                dynamicObject.set("bjamount", (Object)bqamount);
                continue;
            }
            if ("021".equals(type) && Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10}).contains(month)) {
                dynamicObject.set("bjamount", (Object)bqamount);
                continue;
            }
            if (!"022".equals(type)) continue;
            dynamicObject.set("bjamount", (Object)bqamount);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return dynamicObjects;
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getFieldName().equals("bqamount")) {
            String key = ((Control)evt.getSource()).getKey();
            EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
            String type = String.valueOf(itemsEntity.getModel().getValue("type"));
            String entrytype = evt.getFieldName();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("columnType", evt.getFieldName());
            customParams.put("entrytype", "yjassets");
            customParams.put("itemnumber", type);
            DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(customParams);
            customParams.put("entryname", draftTypeVoObject.getYjAssets().getDetail());
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        }
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private DynamicObject[] getAdjustAmount(Map<String, Object> customParams) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)"yjassets");
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter};
        String selectPrope = "ruleid,entrytype,adjustamount,totalamount,itemnumber";
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(customParams);
        DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)draftTypeVoObject.getAdjustDetail().getNumber(), (String)selectPrope, (QFilter[])filters);
        return adjustDetails;
    }

    @Override
    public Set<String> adaptDraftCellName(Set<String> rowSet) {
        return Collections.singleton("bqamount");
    }

    @Override
    public Map<String, Object> createParams(DynamicObject obj) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(customParams);
        params.put("entrytype", "yjassets");
        params.put("itemnumber", obj.get("type"));
        return params;
    }
}

