/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.dto.DraftAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class AssetsLossTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String RULEID = "ruleid";
    public static final String NAME = "name";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ZZJE = "zzje";
    public static final String RESERVEVERIFY = "reserveverify";
    public static final String INCOME_SUM = "incomesum";
    public static final String DISPOSAL_INCOME = "disposalincome";
    public static final String DAMAGES_INCOME = "damagesincome";
    public static final String ASSETS_BASE = "assetsbase";
    public static final String ORIGINAL = "original";
    public static final String SUM_DEPRECIATE = "sumdepreciate";
    public static final String ABNORMAL_INCOME = "abnormalincome";
    public static final String ASSETS_LOSS_AMOUNT = "assetslossamount";
    public static final String NSTZJE = "nstzje";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private List<String> columns = Lists.newArrayList((Object[])new String[]{"zzje", "reserveverify", "incomesum", "disposalincome", "damagesincome", "assetsbase", "original", "sumdepreciate", "abnormalincome", "assetslossamount", "nstzje"});
    private Map<String, String> projects = new HashMap<String, String>(){
        {
            this.put(AssetsLossTZFormPlugin.ZZJE, "assetsloss");
            this.put(AssetsLossTZFormPlugin.RESERVEVERIFY, "assetsreserveverify");
            this.put(AssetsLossTZFormPlugin.DISPOSAL_INCOME, "assetsdisposalincome");
            this.put(AssetsLossTZFormPlugin.DAMAGES_INCOME, "assetsdamagesincome");
            this.put(AssetsLossTZFormPlugin.ORIGINAL, "assetsoriginal");
            this.put(AssetsLossTZFormPlugin.SUM_DEPRECIATE, "assetssumdepreciate");
            this.put(AssetsLossTZFormPlugin.ABNORMAL_INCOME, "assetsabnormalincome");
        }
    };
    private Set<String> itemtypes = YearAccEngine.getEntityItemMapping().get("tccit_assets_loss_detail").stream().collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,ruleid,name,itemtype,zzje,reserveverify,incomesum,disposalincome,damagesincome,assetsbase,original,sumdepreciate,abnormalincome,assetslossamount,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_assets_loss_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject dataEntity = (DynamicObject)entryentity.get(rowIndex);
            long ruleId = dynamicObject.getLong(RULEID);
            for (String columnType : this.columns) {
                dot.getProperty(ITEM_NO).setValueFast((Object)dataEntity, (Object)(rowIndex + 1));
                dot.getProperty(RULEID).setValueFast((Object)dataEntity, (Object)ruleId);
                dot.getProperty(NAME).setValueFast((Object)dataEntity, (Object)dynamicObject.getString(NAME));
                dot.getProperty(ITEM_TYPE).setValueFast((Object)dataEntity, (Object)dynamicObject.getString(ITEM_TYPE));
                dot.getProperty(columnType).setValueFast((Object)dataEntity, (Object)this.formatData(ruleId, columnType, dynamicObject.getBigDecimal(columnType)));
            }
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        this.columns.stream().forEach(column -> {
            model.setValue(ITEM_NO, (Object)(rowIndex + 1), rowIndex);
            model.setValue(RULEID, (Object)0L, rowIndex);
            model.setValue(NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AssetsLossTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
            model.setValue(ITEM_TYPE, (Object)"", rowIndex);
            model.setValue(column, (Object)this.formatData(0L, (String)column, this.getSum(query, (String)column)), rowIndex);
        });
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(Long ruleId, String columnType, BigDecimal data) {
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if (ruleId == 0L) {
            if (Arrays.asList(INCOME_SUM, ASSETS_BASE, ASSETS_LOSS_AMOUNT, NSTZJE).contains(columnType)) {
                return DataFormat.formatMicrometer(text);
            }
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("asset2")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.ASSETS);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && this.itemtypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        int index = 0;
        List<String> entryTypeList = Arrays.asList("assetsloss", "assetsreserveverify", "assetsdisposalincome", "assetsdamagesincome", "assetsoriginal", "assetssumdepreciate", "assetsabnormalincome");
        List<Long> ruleList = sellRuleList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        List<DraftAmountDto> amountList = this.getCellAmountList(customParams, entryTypeList, null, ruleList, "tccit_assets_loss_detail");
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)"tccit_assets_loss_summary");
            String itemnumber = dynamicObject.getDynamicObject("item").getString("number");
            String ruleId = dynamicObject.getString("id");
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(NAME, (Object)dynamicObject.getString(NAME));
            dynamicObject2.set(RULEID, (Object)dynamicObject.getLong("id"));
            dynamicObject2.set(ITEM_TYPE, (Object)itemnumber);
            BigDecimal loss = this.getAmount(amountList, "assetsloss", ruleId);
            dynamicObject2.set(ZZJE, (Object)loss);
            BigDecimal assetsreserveverify = this.getAmount(amountList, "assetsreserveverify", ruleId);
            dynamicObject2.set(RESERVEVERIFY, (Object)assetsreserveverify);
            BigDecimal disposalincome = this.getAmount(amountList, "assetsdisposalincome", ruleId);
            BigDecimal damagesincome = this.getAmount(amountList, "assetsdamagesincome", ruleId);
            BigDecimal incomeSum = disposalincome.add(damagesincome);
            dynamicObject2.set(INCOME_SUM, (Object)incomeSum);
            dynamicObject2.set(DISPOSAL_INCOME, (Object)disposalincome);
            dynamicObject2.set(DAMAGES_INCOME, (Object)damagesincome);
            BigDecimal original = this.getAmount(amountList, "assetsoriginal", ruleId);
            dynamicObject2.set(ORIGINAL, (Object)original);
            BigDecimal sumdepreciate = this.getAmount(amountList, "assetssumdepreciate", ruleId);
            dynamicObject2.set(SUM_DEPRECIATE, (Object)sumdepreciate);
            BigDecimal abnormalincome = this.getAmount(amountList, "assetsabnormalincome", ruleId);
            BigDecimal assetsBase = original.subtract(sumdepreciate).add(abnormalincome);
            dynamicObject2.set(ASSETS_BASE, (Object)assetsBase);
            dynamicObject2.set(ABNORMAL_INCOME, (Object)abnormalincome);
            BigDecimal lossAmount = assetsBase.subtract(incomeSum);
            dynamicObject2.set(ASSETS_LOSS_AMOUNT, (Object)lossAmount);
            dynamicObject2.set(NSTZJE, (Object)loss.subtract(lossAmount));
            if (this.isSpecialRule(itemnumber, orgid)) {
                dynamicObject2.set(NSTZJE, (Object)loss.add(assetsreserveverify).subtract(lossAmount));
            }
            dynamicObject2.set(ORGID, (Object)orgid);
            dynamicObject2.set(SKSSQQ, (Object)skssqq);
            dynamicObject2.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private boolean isSpecialRule(String itemnumber, Long orgid) {
        boolean b1 = Arrays.asList("70103080101", "70103080102", "70103080103", "70103080104", "70103080105", "7010311").contains(itemnumber);
        if (!b1) {
            return false;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
        if (result != null && result.isSuccess() && result.getData() != null) {
            return this.isSpecialCompany((DynamicObject)result.getData());
        }
        return false;
    }

    private Boolean isSpecialCompany(DynamicObject taxMain) {
        String number = taxMain.getString("codeandname.number");
        if (Lists.newArrayList((Object[])new String[]{"6621", "6622", "6623", "6631", "6632", "6635"}).contains(number)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_assets_loss_summary", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private BigDecimal getAmount(List<DraftAmountDto> amountList, String entryType, String ruleId) {
        if (CollectionUtils.isEmpty(amountList)) {
            return BigDecimal.ZERO;
        }
        return amountList.stream().filter(e -> e.getRuleId().equals(ruleId) && e.getEntrytype().equals(entryType)).map(s -> s.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String itemnumber, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), "tccit_assets_loss_detail");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        String itemnumber = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entrytype", this.projects.get(evt.getFieldName()));
        customParams.put("columnType", evt.getFieldName());
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_assets_loss_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE, RESERVEVERIFY, DISPOSAL_INCOME, DAMAGES_INCOME, ORIGINAL, SUM_DEPRECIATE, ABNORMAL_INCOME});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", "tccit_assets_loss_detail");
        customParams.put("entrytype", this.projects.get(column));
        customParams.put("columnType", column);
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

