/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class BeforeTaxDeductTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "002", "003", "004", "005", "006", "007", "008"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ZZJE = "zzje";
    public static final String NSTZJE = "nstzje";
    private Map<String, String> dataMap = new HashMap<String, String>();
    private Map<String, String> projects = new HashMap<String, String>(){
        {
            this.put("001", "3010701");
            this.put("002", "3010702");
            this.put("003", "3010703");
            this.put("004", "3010704");
            this.put("005", "3010705");
            this.put("006", "3010706");
            this.put("007", "3010707");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        this.dataMap.clear();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,zzje,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_beforetax_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_TYPE));
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, ZZJE));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject, NSTZJE));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(DynamicObject dynamicObject, String columnType) {
        String text = DataFormat.formatMicrometer(dynamicObject.getBigDecimal(columnType).setScale(2, 4).toString());
        if (dynamicObject.getString(ITEM_NO).equals("8") && ZZJE.equals(columnType)) {
            StringBuilder link = new StringBuilder("<nolink>");
            return link.append(text).toString();
        }
        return text;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_beforetax_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct9")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (int i = 0; i < itemTypes.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_beforetax_summary");
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set(ITEM_TYPE, (Object)itemTypes.get(i));
            BigDecimal amount = this.calcAmount(itemTypes.get(i), ZZJE, customParams);
            dynamicObject.set(ZZJE, (Object)amount);
            dynamicObject.set(NSTZJE, (Object)this.getNstzje(itemTypes.get(i), NSTZJE, amount));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal getNstzje(String rowType, String columnType, BigDecimal amount) {
        this.dataMap.put(this.getKey(rowType, columnType), amount.toString());
        return amount;
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        String entrytype = columnType;
        if (Lists.newArrayList((Object[])new String[]{"001", "002", "003", "004", "005", "006", "007"}).contains(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, entrytype, rowType);
            this.dataMap.put(this.getKey(rowType, columnType), amount.toString());
            return amount;
        }
        if ("008".equals(rowType)) {
            BigDecimal sum = this.getSum(columnType).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), sum.toString());
            return sum;
        }
        this.dataMap.put(this.getKey(rowType, columnType), "0.00");
        return BigDecimal.valueOf(0.0);
    }

    private BigDecimal getSum(String columnType) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, String> entry : this.dataMap.entrySet()) {
            if (!entry.getKey().endsWith(columnType)) continue;
            String value = StringUtil.isNotEmpty((CharSequence)entry.getValue()) ? entry.getValue() : "0.0";
            sum = sum.add(new BigDecimal(value));
        }
        return sum;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype, String rowType) {
        String itemnumber = this.projects.get(rowType);
        return this.getCellAmount(customParams, columnType, entrytype, rowType, itemnumber, null, "tccit_beforetax_detail");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > 6) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String rowType = (String)itemsEntity.getModel().getValue(ITEM_TYPE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", ZZJE);
        customParams.put("itemnumber", this.projects.get(rowType));
        customParams.put("entryname", "tccit_beforetax_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_beforetax_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_beforetax_detail");
        customParams.put("entrytype", ZZJE);
        customParams.put("columnType", column);
        customParams.put("itemnumber", this.projects.get(itemtype));
        return customParams;
    }
}

