/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.ThinkOfSellFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;

public class BusinessEntertainmentCostTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "002", "003", "003_01", "003_02", "003_03", "003_04", "003_05", "003_06", "004", "004_01", "004_02"});
    private final Set<String> titleRows = Sets.newHashSet((Object[])new String[]{"003", "004"});
    private final Set<String> linkList = Sets.newHashSet((Object[])new String[]{"001", "002", "003_01"});
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String AMOUNT = "amount";
    private static final String SUMARRY_ENTITY = "tccit_ywzdf_tz_summary";
    private static final String YWZDF_TZ_DETAIL = "tccit_ywzdf_tz_detail";
    private Map<String, String> dataMap = new HashMap<String, String>();
    private Map<String, String> rateNumberMaps = new HashMap<String, String>(){
        {
            this.put("003_02", "YWZDF01");
            this.put("003_05", "YWZDF02");
        }
    };
    private Map<String, String> columnToRuleProjects = new HashMap<String, String>(){
        {
            this.put(BusinessEntertainmentCostTZFormPlugin.AMOUNT, "30102");
            this.put("originalamount", "ywzdfdg");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entrytype;
        int rowIndex = evt.getRowIndex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("itemnumber", this.columnToRuleProjects.get(evt.getFieldName()));
        customParams.put("entryname", YWZDF_TZ_DETAIL);
        switch (rowIndex) {
            case 0: {
                entrytype = "zzje";
                break;
            }
            case 1: {
                entrytype = "swkjje";
                break;
            }
            case 3: {
                entrytype = "ywzdf_sr";
                String original_amount_field = "originalamount";
                QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"003_01");
                QFilter qFilter2 = new QFilter("orgid", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
                QFilter qFilter1 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
                QFilter qFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
                DynamicObjectCollection query = QueryServiceHelper.query((String)SUMARRY_ENTITY, (String)original_amount_field, (QFilter[])new QFilter[]{itemtypeFilter, qFilter, qFilter1, qFilter2});
                BigDecimal sum = query.stream().map(s -> StringUtil.isEmpty((CharSequence)s.getString(original_amount_field)) ? BigDecimal.ZERO : s.getBigDecimal(original_amount_field)).reduce(BigDecimal.ZERO, BigDecimal::add);
                customParams.put("originalamount", sum);
                customParams.put("itemnumber", this.columnToRuleProjects.get(original_amount_field));
                break;
            }
            default: {
                return;
            }
        }
        customParams.put("entrytype", entrytype);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void initData() {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        String selectFields = "itemno,itemtype,amount";
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)SUMARRY_ENTITY, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter = new QFilter("skssqq", "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq"))))).and(new QFilter("skssqz", "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))))))}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String itemType = dynamicObject.getString(ITEM_TYPE);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_TYPE));
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)(this.titleRows.contains(dynamicObject.getString(ITEM_TYPE)) ? "" : this.getFormatData(itemType, dynamicObject.getBigDecimal(AMOUNT).setScale(2, 4).toString())));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String getFormatData(String columnType, String data) {
        StringBuilder link = new StringBuilder("<nolink>");
        if ("003_02".equals(columnType) || "003_05".equals(columnType)) {
            data = DataFormat.formatRate(data);
        } else if (StringUtil.isNotBlank((CharSequence)data)) {
            data = DataFormat.formatMicrometer(data);
        }
        if (!this.linkList.contains(columnType)) {
            data = link.append(data).toString();
        }
        return data;
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)SUMARRY_ENTITY, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct1")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SUMARRY_ENTITY);
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set(ITEM_TYPE, (Object)this.itemTypes.get(i));
            dynamicObject.set(AMOUNT, this.calcAmount(this.itemTypes.get(i), AMOUNT, customParams));
            if (StringUtil.equals((CharSequence)this.itemTypes.get(i), (CharSequence)"003_01")) {
                dynamicObject.set("originalamount", (Object)this.dataMap.get(this.getKey(this.itemTypes.get(i), "originalamount")));
            }
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        String row3;
        String row2;
        String rate;
        String amount;
        if (this.titleRows.contains(rowType)) {
            return "";
        }
        String key = this.getKey(rowType, columnType);
        if ("001".equals(rowType)) {
            BigDecimal amount2 = this.getAmount(customParams, columnType, "zzje", false);
            this.dataMap.put(key, amount2.toString());
            return amount2.toString();
        }
        if ("002".equals(rowType)) {
            BigDecimal amount3 = this.getAmount(customParams, columnType, "swkjje", false);
            this.dataMap.put(key, amount3.toString());
            return amount3.toString();
        }
        if ("003_01".equals(rowType)) {
            String orgId = String.valueOf(customParams.get("orgid"));
            String skssqq = String.valueOf(customParams.get("skssqq"));
            String skssqz = String.valueOf(customParams.get("skssqz"));
            QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
            QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
            QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"001");
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_1_sum", (String)AMOUNT, (QFilter[])new QFilter[]{orgIdFilter, skssqqFilter, skssqzFilter, itemtypeFilter});
            BigDecimal dgyysr = dynamicObject1 != null ? dynamicObject1.getBigDecimal(AMOUNT) : BigDecimal.ZERO;
            QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz)));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_thinkofsell_summary", (String)"sum(income) as income,sum(adjustamount) as adjustamount", (QFilter[])new QFilter[]{orgFilter, dateFilter});
            BigDecimal stxsIncome = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("income");
            BigDecimal adjustamount = this.getAmount(customParams, "originalamount", "ywzdf_sr", true);
            BigDecimal originalamount = stxsIncome.add(dgyysr).setScale(2, 4);
            BigDecimal xsyysr = adjustamount.add(originalamount).setScale(2, 4);
            this.dataMap.put(key, xsyysr.toString());
            this.dataMap.put(this.getKey(rowType, "originalamount"), originalamount.toString());
            return xsyysr.toString();
        }
        if ("003_02".equals(rowType)) {
            String rate2 = this.getRate(rowType, columnType, customParams);
            this.dataMap.put(key, rate2);
            return rate2;
        }
        if ("003_03".equals(rowType)) {
            amount = this.dataMap.get(this.getKey("003_01", columnType));
            rate = this.dataMap.get(this.getKey("003_02", columnType));
            if (amount != null && rate != null) {
                BigDecimal deduct = new BigDecimal(amount).multiply(new BigDecimal(rate)).divide(new BigDecimal("100")).setScale(2, 4);
                this.dataMap.put(key, deduct.compareTo(BigDecimal.valueOf(0L)) > 0 ? deduct.toString() : "0");
                return deduct;
            }
        }
        if ("003_04".equals(rowType)) {
            amount = this.dataMap.get(this.getKey("002", columnType));
            this.dataMap.put(key, amount);
            return amount;
        }
        if ("003_05".equals(rowType)) {
            String rate3 = this.getRate(rowType, columnType, customParams);
            this.dataMap.put(key, rate3);
            return rate3;
        }
        if ("003_06".equals(rowType)) {
            amount = this.dataMap.get(this.getKey("003_04", columnType));
            rate = this.dataMap.get(this.getKey("003_05", columnType));
            if (amount != null && rate != null) {
                BigDecimal deduct = new BigDecimal(amount).multiply(new BigDecimal(rate)).divide(new BigDecimal("100")).setScale(2, 4);
                this.dataMap.put(key, deduct.compareTo(BigDecimal.valueOf(0L)) > 0 ? deduct.toString() : "0");
                return deduct;
            }
        }
        if ("004_01".equals(rowType)) {
            row2 = this.dataMap.get(this.getKey("002", columnType));
            row3 = this.dataMap.get(this.getKey("003_03", columnType));
            String row7 = this.dataMap.get(this.getKey("003_06", columnType));
            List list = Lists.newArrayList((Object[])new String[]{row2, row3, row7}).stream().map(s -> new BigDecimal((String)s)).collect(Collectors.toList());
            String decimal = list.stream().sorted().findFirst().orElse(BigDecimal.ZERO).setScale(2, 4).toString();
            this.dataMap.put(key, decimal);
            return decimal;
        }
        if ("004_02".equals(rowType)) {
            row2 = this.dataMap.get(this.getKey("001", columnType));
            row3 = this.dataMap.get(this.getKey("004_01", columnType));
            String tiaoz = new BigDecimal(row2).subtract(new BigDecimal(row3)).setScale(2, 4).toString();
            this.dataMap.put(key, tiaoz);
            return tiaoz;
        }
        this.dataMap.put(key, "");
        return "";
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype, boolean isAJustAmount) {
        String itemnumber = this.columnToRuleProjects.get(columnType);
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, YWZDF_TZ_DETAIL);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    private String getRate(String rowType, String columnType, Map<String, Object> customParams) {
        String orgId = String.valueOf(customParams.get("orgid"));
        String skssqq = String.valueOf(customParams.get("skssqq"));
        String skssqz = String.valueOf(customParams.get("skssqz"));
        List deductionRateList = AssistService.queryAssistParams((String)this.rateNumberMaps.get(rowType), (String)orgId, (String)skssqq, (String)skssqz);
        BigDecimal rate = CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.valueOf(0L) : new BigDecimal((String)deductionRateList.get(0));
        return rate.setScale(2, 4).toString();
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", this.itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)SUMARRY_ENTITY, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entrytype = this.getEntryType(row.getInt("seq"));
        customParams.put("entryname", YWZDF_TZ_DETAIL);
        customParams.put("entrytype", entrytype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", "ywzdf_sr".equals(entrytype) ? "ywzdfdg" : this.columnToRuleProjects.get(column));
        return customParams;
    }

    public String getEntryType(int rowIndex) {
        String entrytype = null;
        if (rowIndex == 1) {
            entrytype = "zzje";
        } else if (rowIndex == 2) {
            entrytype = "swkjje";
        } else if (rowIndex == 4) {
            entrytype = "ywzdf_sr";
        }
        return entrytype;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(BusinessEntertainmentCostTZFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{A100000_1_DGFormPlugin.class.getSimpleName(), ThinkOfSellFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

