/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.YearCalcSummaryPageService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.AdvertScriptTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetDisposeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetExpenseFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetsLossTZFormPlugin;
import kd.taxc.tccit.formplugin.account.AssetsReserveFormPlugin;
import kd.taxc.tccit.formplugin.account.BeforeTaxDeductTZFormPlugin;
import kd.taxc.tccit.formplugin.account.BusinessEntertainmentCostTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductPreferentialSummaryPlugin;
import kd.taxc.tccit.formplugin.account.DeductTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DevJjkcTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DksszbjTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.DomesticAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.EduFullTZFormPlugin;
import kd.taxc.tccit.formplugin.account.EduLimitTZFormPlugin;
import kd.taxc.tccit.formplugin.account.FgyxjzzcFormPlugin;
import kd.taxc.tccit.formplugin.account.FhmstjdtzsyFormPlugin;
import kd.taxc.tccit.formplugin.account.GetReduceFormPlugin;
import kd.taxc.tccit.formplugin.account.GyjzbdsyTZFormPlugin;
import kd.taxc.tccit.formplugin.account.HhqyhhrTZFormPlugin;
import kd.taxc.tccit.formplugin.account.IncomeAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.InsuranceTZFormPlugin;
import kd.taxc.tccit.formplugin.account.InvestProfitTZFormPlugin;
import kd.taxc.tccit.formplugin.account.MbyqndksjsdgFormPlugin;
import kd.taxc.tccit.formplugin.account.NonInsuranceTZFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherFreeTaxFormPlugin;
import kd.taxc.tccit.formplugin.account.OtherSpecTZFormPlugin;
import kd.taxc.tccit.formplugin.account.PeriodTZFormPlugin;
import kd.taxc.tccit.formplugin.account.QtSalaryTZFormPlugin;
import kd.taxc.tccit.formplugin.account.QttzHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.QyczjdynsTZFormPlugin;
import kd.taxc.tccit.formplugin.account.RightsIncomeTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SalaryTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SaleZkzrthTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SejsSetzSummaryPlugin;
import kd.taxc.tccit.formplugin.account.ThinkOfSellFormPlugin;
import kd.taxc.tccit.formplugin.account.TssxHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.TzzccscbtzTZFormPlugin;
import kd.taxc.tccit.formplugin.account.XekcgyxFormPlugin;
import kd.taxc.tccit.formplugin.account.ZcOtherTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ZczjtxFormPlugin;
import kd.taxc.tccit.formplugin.account.ZeroRatingFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.sdtz.B105093_DGFormPlugin;

public class CalcSummaryPagePlugin
extends AbstractEngine
implements Observer {
    private static Log logger = LogFactory.getLog(CalcSummaryPagePlugin.class);
    public final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "4", "4a", "4a(1)", "4a(2)", "4a(3)", "4a(4)", "4a(5)", "4a(6)", "4a(7)", "4a(8)", "4b", "4b(1)", "4b(2)", "4b(3)", "4b(4)", "4b(5)", "4b(6)", "4b(7)", "4b(8)", "4b(9)", "4b(10)", "4c", "4c(1)", "4c(2)", "4c(3)", "4c(4)", "4c(5)", "4c(6)", "4c(7)", "4c(8)", "5", "5a", "5a(1)", "5a(2)", "5a(3)", "5a(4)", "5b", "5b(1)", "5c", "5c(1)", "5d", "5d(1)", "6", "6a", "6b", "6c", "6d", "6e", "6f", "7", "7a", "7b", "7c", "7d", "7e", "7f", "8", "9", "10", "11", "12", "13", "14", "15", "16", "16a", "16b", "17", "18", "19", "20", "21", "22", "23", "24"});
    public final Set<String> level1 = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "other"});
    public final Set<String> level2 = Sets.newHashSet((Object[])new String[]{"3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "4a", "4b", "4c", "5a", "5b", "5c", "5d", "6a", "6b", "6c", "6d", "6e", "6f", "7a", "7b", "7c", "7d", "7e", "7f", "16a", "16b"});
    public final Set<String> level3 = Sets.newHashSet((Object[])new String[]{"4a(1)", "4a(2)", "4a(3)", "4a(4)", "4a(5)", "4a(6)", "4a(7)", "4a(8)", "4b(1)", "4b(2)", "4b(3)", "4b(4)", "4b(5)", "4b(6)", "4b(7)", "4b(8)", "4b(9)", "4b(10)", "4c(1)", "4c(2)", "4c(3)", "4c(4)", "4c(5)", "4c(6)", "4c(7)", "4c(8)", "5a(1)", "5a(2)", "5a(3)", "5a(4)", "5b(1)", "5c(1)", "5d(1)"});
    private List<String> needHides = Lists.newArrayList((Object[])new String[]{"3a", "4a(1)", "4a(5)", "4a(6)", "4a(7)", "4a(8)", "4c(1)", "4b(5)", "4b(6)"});
    private static final String ENTITY_NAME = "treeentryentity";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String CUR_YEAR_AMOUNT = "curyearamount";
    private static final String PRE_YEAR_AMOUNT = "preyearamount";
    private static final String INCREASE = "increase";
    private static final String MYPARENTID = "myparentid";
    private static final String MYPKID = "mypkid";
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static Pattern pattern = Pattern.compile("[^0-9]");
    private Map<String, Long> keyIds = new HashMap<String, Long>();
    private YearCalcSummaryPageService yearCalcSummaryPageService = new YearCalcSummaryPageService();

    public void initialize() {
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        List<String> showItems = this.hideList(this.needHide(this.needHides, customParams));
        CopyOnWriteArrayList<String> copyOnWriteArrayList = new CopyOnWriteArrayList<String>(showItems);
        copyOnWriteArrayList.sort(Comparator.comparing(String::length).reversed());
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (String itemType : copyOnWriteArrayList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_calc_summary_detail");
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            BigDecimal currentYear = this.yearCalcSummaryPageService.calcCell(itemType, CUR_YEAR_AMOUNT, customParams);
            dynamicObject.set(CUR_YEAR_AMOUNT, (Object)currentYear);
            BigDecimal preYear = this.yearCalcSummaryPageService.calcCell(itemType, PRE_YEAR_AMOUNT, customParams);
            dynamicObject.set(PRE_YEAR_AMOUNT, (Object)preYear);
            dynamicObject.set(INCREASE, (Object)this.getIncrease(itemType, currentYear, preYear));
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        this.buildTree(showItems, sum);
        try (TXHandle h = TX.required();){
            try {
                this.yearCalcSummaryPageService.clearCurrentPeriod(orgid, skssqq, skssqz);
                DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
                this.yearCalcSummaryPageService.updateYearDraftData(save, orgid, skssqq, skssqz);
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("calc summary error:", (Object)e.getMessage());
            }
        }
    }

    private void buildTree(List<String> showItems, DynamicObjectCollection sum) {
        for (String itemType : showItems) {
            DynamicObject dynamicObject1 = sum.stream().filter(s -> s.getString(ITEM_NO).equals(itemType)).findFirst().get();
            dynamicObject1.set(MYPARENTID, (Object)this.getParentId(itemType));
            dynamicObject1.set(MYPKID, (Object)this.getPkId(itemType));
        }
    }

    private String getIncrease(String itemType, BigDecimal currentYear, BigDecimal preYear) {
        if (preYear == null || preYear.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        BigDecimal decimal = currentYear.divide(preYear, 4, 4).subtract(new BigDecimal("1"));
        return decimal.setScale(4, 4).toString();
    }

    private void initData() {
        this.getModel().deleteEntryData(ENTITY_NAME);
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,curyearamount,preyearamount,increase,mypkid,myparentid,orgid,skssqq,skssqz";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_calc_summary_detail", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        List<String> showItems = this.hideList(this.needHide(this.needHides, customParams));
        model.beginInit();
        for (String itemType : showItems) {
            DynamicObject object = query.stream().filter(s -> s.getString("itemType").equals(itemType)).findFirst().get();
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            keyObject.set("id", (Object)object.getLong(MYPKID));
            keyObject.set("pid", (Object)object.getLong(MYPARENTID));
            int index = this.getModel().createNewEntryRow(ENTITY_NAME, keyObject);
            model.setValue(ITEM_NO, (Object)object.getString(ITEM_NO), index);
            model.setValue(ITEM_TYPE, (Object)object.getString(ITEM_NO), index);
            model.setValue(CUR_YEAR_AMOUNT, (Object)this.formatData(object, itemType, CUR_YEAR_AMOUNT), index);
            model.setValue(PRE_YEAR_AMOUNT, (Object)this.formatData(object, itemType, PRE_YEAR_AMOUNT), index);
            model.setValue(INCREASE, (Object)this.formatIncrease(object, itemType, INCREASE), index);
        }
        model.endInit();
        this.getView().updateView(ENTITY_NAME);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTITY_NAME);
        treeEntryGrid.setCollapse(false);
        List rows1 = Lists.newArrayList((Object[])new String[]{"3", "6", "7", "16"}).stream().map(s -> this.itemTypes.indexOf(s)).collect(Collectors.toList());
        List rows2 = Lists.newArrayList((Object[])new String[]{"4a", "4b", "4c", "5a", "5b", "5c", "5d"}).stream().map(s -> this.itemTypes.indexOf(s)).collect(Collectors.toList());
        rows2.addAll(rows1);
        treeEntryGrid.collapse(rows2.stream().mapToInt(Integer::intValue).toArray());
    }

    private String formatIncrease(DynamicObject object, String rowType, String columnType) {
        if ("14".equals(rowType)) {
            return "";
        }
        BigDecimal rate = object.getBigDecimal(columnType);
        return String.format("%s%%", rate.multiply(new BigDecimal("100")).setScale(2, 4).toString());
    }

    private String formatData(DynamicObject object, String rowType, String columnType) {
        if ("14".equals(rowType)) {
            BigDecimal rate = object.getBigDecimal(columnType);
            return String.format("%s%%", rate.multiply(new BigDecimal("100")).setScale(0, 4).toString());
        }
        return DataFormat.formatMicrometer(object.getString(columnType));
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private List<String> needHide(List<String> needHides, Map<String, Object> customParams) {
        Date skssqz;
        Date skssqq;
        QFilter dateFilter;
        String selectFields = "income1,deduct1,deduct2,deduct6,deduct9,deduct10,income9,deduct11";
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        DynamicObjectCollection policyConfirm = QueryServiceHelper.query((String)"tccit_policy_confirm", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter = new QFilter("startdate", "=", (Object)(skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))))).and(new QFilter("enddate", "=", (Object)(skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ))))))});
        if (CollectionUtils.isEmpty((Collection)policyConfirm)) {
            return needHides;
        }
        needHides.removeIf(needHide -> ((DynamicObject)policyConfirm.get(0)).getBoolean(this.mappingRelation().get(needHide)));
        if (needHides.contains("4a(5)") && ((DynamicObject)policyConfirm.get(0)).getBoolean("deduct11")) {
            needHides.remove("4a(5)");
        }
        return needHides;
    }

    private Map<String, String> mappingRelation() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("3a", "income1");
        map.put("4c(1)", "income1");
        map.put("4a(1)", "deduct1");
        map.put("4a(6)", "deduct2");
        map.put("4a(5)", "deduct11");
        map.put("4a(7)", "deduct6");
        map.put("4a(8)", "deduct10");
        map.put("4b(5)", "income9");
        map.put("4b(6)", "deduct9");
        return map;
    }

    private List<String> hideList(List<String> rows) {
        for (String row : rows) {
            this.itemTypes.removeIf(s -> s.equals(row));
        }
        this.itemTypes.remove("5c(1)");
        this.itemTypes.remove("5d(1)");
        this.itemTypes.remove("7f");
        return this.itemTypes;
    }

    private Long getPkId(String itemType) {
        Long pkId = this.itemTypes.indexOf(itemType) + 1;
        this.keyIds.put(itemType, pkId);
        return pkId;
    }

    private Long getParentId(String id) {
        if (this.level1.contains(id)) {
            return 0L;
        }
        if (this.level2.contains(id)) {
            return this.keyIds.get(pattern.matcher(id).replaceAll(""));
        }
        if (this.level3.contains(id)) {
            return this.keyIds.get(id.substring(0, 2));
        }
        return 0L;
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        this.yearCalcSummaryPageService.clearCurrentPeriod(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(16){
            {
                this.put(CalcSummaryPagePlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{A100000_1_DGFormPlugin.class.getSimpleName(), ThinkOfSellFormPlugin.class.getSimpleName(), RightsIncomeTZFormPlugin.class.getSimpleName(), TzzccscbtzTZFormPlugin.class.getSimpleName(), GyjzbdsyTZFormPlugin.class.getSimpleName(), InvestProfitTZFormPlugin.class.getSimpleName(), ZeroRatingFormPlugin.class.getSimpleName(), SaleZkzrthTZFormPlugin.class.getSimpleName(), IncomeAdjustFormPlugin.class.getSimpleName(), AssetDisposeTZFormPlugin.class.getSimpleName(), BusinessEntertainmentCostTZFormPlugin.class.getSimpleName(), DeductTZFormPlugin.class.getSimpleName(), EduLimitTZFormPlugin.class.getSimpleName(), EduFullTZFormPlugin.class.getSimpleName(), XekcgyxFormPlugin.class.getSimpleName(), AdvertScriptTZFormPlugin.class.getSimpleName(), InsuranceTZFormPlugin.class.getSimpleName(), NonInsuranceTZFormPlugin.class.getSimpleName(), QtSalaryTZFormPlugin.class.getSimpleName(), FgyxjzzcFormPlugin.class.getSimpleName(), BeforeTaxDeductTZFormPlugin.class.getSimpleName(), SalaryTZFormPlugin.class.getSimpleName(), PeriodTZFormPlugin.class.getSimpleName(), AssetExpenseFormPlugin.class.getSimpleName(), DeductOtherTZFormPlugin.class.getSimpleName(), DeductAdjustFormPlugin.class.getSimpleName(), ZczjtxFormPlugin.class.getSimpleName(), AssetsReserveFormPlugin.class.getSimpleName(), AssetsLossTZFormPlugin.class.getSimpleName(), AssetAdjustFormPlugin.class.getSimpleName(), ZcOtherTZFormPlugin.class.getSimpleName(), QyczjdynsTZFormPlugin.class.getSimpleName(), DksszbjTZFormPlugin.class.getSimpleName(), B105093_DGFormPlugin.class.getSimpleName(), HhqyhhrTZFormPlugin.class.getSimpleName(), OtherSpecTZFormPlugin.class.getSimpleName(), TssxHzdgSummaryPlugin.class.getSimpleName(), QttzHzdgSummaryPlugin.class.getSimpleName(), FhmstjdtzsyFormPlugin.class.getSimpleName(), DevJjkcTZFormPlugin.class.getSimpleName(), OtherFreeTaxFormPlugin.class.getSimpleName(), DomesticAdjustFormPlugin.class.getSimpleName(), GetReduceFormPlugin.class.getSimpleName(), MbyqndksjsdgFormPlugin.class.getSimpleName(), DkynssdeTZFormPlugin.class.getSimpleName(), SejsSetzSummaryPlugin.class.getSimpleName(), DeductPreferentialSummaryPlugin.class.getSimpleName()}));
            }
        };
    }
}

