/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractDeductSummaryPlugin;
import kd.taxc.tccit.formplugin.account.JmyhhzDgFormPlugin;
import kd.taxc.tccit.formplugin.account.SmallEnterprisesTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SoftIcTZFormPlugin;
import kd.taxc.tccit.formplugin.account.SonGetReduceFormPlugin;

public class DeductPreferentialSummaryPlugin
extends AbstractDeductSummaryPlugin
implements HyperLinkClickListener,
Observer {
    private static final String ENTRYENTITY = "treeentryentity";
    private static final String ITEMNO = "itemno";
    public static final String ITEMTYPE = "itemtype";
    private static final String CANUSE = "canuse";
    private static final String DEDUCTIBLERATIO = "deductibleratio";
    private static final String ENTRYENTITY_JMSE = "entryentity.jmse";
    private static final String ENTRYENTITY_JMBL = "entryentity.jmbl";
    private static final String AMOUNTORRATIO = "amountorratio";
    private static final String ORGID = "orgid";
    private static final String MYPARENTID = "myparentid";
    private static final String MYPKID = "mypkid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TCCIT_SETZ_JMYHHZ_SUMMARY = "tccit_setz_jmyhhz_summary";
    private static final String QUALIFIED = "qualified";
    private static final String ORIITEMNO = "oriitemno";
    private static final String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] numbers = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"};
    private final List<String> JZMZ_TYPES = Lists.newArrayList((Object[])new String[]{"4.1", "4.2", "4.4", "4.5", "4.6", "5", "6.3"});
    private final List<String> EXCLUDE_TYPES = Lists.newArrayList((Object[])new String[]{"4.4.u", "4.5.f", "4.5.g", "4.4.s", "4.4.r", "4.4.p", "4.4.e", "4.4.f", "4.4.n", "4.4.m", "4.4.k", "4.4.h", "4.4.i", "6.1", "6.2", "4.6.d", "4.6.e"});
    private static BigDecimal DIVISOR = new BigDecimal(100);
    private ArrayList<String> list43a = Lists.newArrayList((Object[])new String[]{"110", "120", "130"});
    private ArrayList<String> list43b = Lists.newArrayList((Object[])new String[]{"210", "220", "240"});
    private Map<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(128);
    private Map<String, Object> paramMaps = new HashMap<String, Object>(16);
    private Map<String, Long> keyIds = new HashMap<String, Long>();
    private Set<String> selectItems = Sets.newHashSet((Object[])new String[]{"4.1", "4.2", "4.3", "4.4", "4.5", "4.6"});

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.buildForm(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (CANUSE.equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            DynamicObject dataEntity = changeSet[0].getDataEntity();
            Object oldValue = changeSet[0].getOldValue();
            QFilter qfilter2 = this.getQfilter2(customParams);
            ArrayList<String> items = new ArrayList<String>();
            items.addAll(this.selectItems);
            items.addAll(Lists.newArrayList((Object[])new String[]{"3", "4", "5", "6", "7"}));
            QFilter qFilter = new QFilter(ITEMTYPE, "in", items);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)TCCIT_SETZ_JMYHHZ_SUMMARY, (String)"id,itemno,itemtype,deductibleratio,amountorratio,mypkid,myparentid,orgid,skssqq,skssqz,canuse,qualified,oriitemno", (QFilter[])new QFilter[]{qFilter, qfilter2});
            Map<String, DynamicObject> collect = Arrays.stream(load).collect(Collectors.toMap(a -> a.getString(ITEMTYPE), a -> a, (r1, r2) -> r1));
            for (String selectItem : this.selectItems) {
                collect.get(selectItem).set(CANUSE, (Object)Boolean.FALSE);
            }
            if (Boolean.TRUE.equals(newValue)) {
                String itemtype = dataEntity.getString(ITEMTYPE);
                DynamicObject dynamicObject = collect.get(itemtype);
                dynamicObject.set(CANUSE, (Object)Boolean.TRUE);
                collect.get("4").set(AMOUNTORRATIO, collect.get(itemtype).get(AMOUNTORRATIO));
            } else {
                collect.get("4").set(AMOUNTORRATIO, (Object)BigDecimal.ZERO);
            }
            BigDecimal bigDecimal3 = collect.get("3").getBigDecimal(AMOUNTORRATIO);
            BigDecimal bigDecimal4 = collect.get("4").getBigDecimal(AMOUNTORRATIO);
            BigDecimal bigDecimal5 = collect.get("5").getBigDecimal(AMOUNTORRATIO);
            BigDecimal bigDecimal6 = collect.get("6").getBigDecimal(AMOUNTORRATIO);
            BigDecimal sevenrow = bigDecimal3.add(bigDecimal5).subtract(bigDecimal4).subtract(bigDecimal6);
            collect.get("7").set(AMOUNTORRATIO, (Object)(sevenrow.compareTo(BigDecimal.ZERO) > 0 ? sevenrow : BigDecimal.ZERO));
            SaveServiceHelper.update((DynamicObject[])load);
            this.buildForm(false);
        }
    }

    private void buildForm(boolean isnew) {
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,deductibleratio,amountorratio,canuse,qualified,mypkid,myparentid,orgid,skssqq,skssqz";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SETZ_JMYHHZ_SUMMARY, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEMTYPE);
        ArrayList<Integer> collapses = new ArrayList<Integer>(16);
        int index = 0;
        for (String itemType : AbstractDeductSummaryPlugin.ALL_ITEM_TYPES) {
            DynamicObject object;
            Optional<DynamicObject> first = query.stream().filter(s -> s.getString(ITEMTYPE).equals(itemType)).findFirst();
            if (!first.isPresent() || !(object = first.get()).getBoolean(QUALIFIED)) continue;
            DynamicObject keyObject = isnew ? treeEntryEntity.addNew() : (DynamicObject)treeEntryEntity.get(index);
            keyObject.set("id", (Object)object.getLong(MYPKID));
            keyObject.set("pid", (Object)object.getLong(MYPARENTID));
            keyObject.set(ITEMNO, (Object)object.getString(ITEMNO));
            keyObject.set(ITEMTYPE, (Object)object.getString(ITEMTYPE));
            keyObject.set(DEDUCTIBLERATIO, (Object)this.formatData(object, itemType, DEDUCTIBLERATIO));
            keyObject.set(AMOUNTORRATIO, (Object)this.formatData(object, itemType, AMOUNTORRATIO));
            keyObject.set(CANUSE, object.get(CANUSE));
            if (AbstractDeductSummaryPlugin.COLLAPSE_ITEMS.contains(object.getString(ITEMTYPE))) {
                collapses.add(index);
            }
            if (!AbstractDeductSummaryPlugin.CAN_USE_ITEMS.contains(object.getString(ITEMTYPE))) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{CANUSE});
            } else {
                this.getView().setEnable(Boolean.valueOf("A".equals(customParams.get("billstatus"))), index, new String[]{CANUSE});
            }
            ++index;
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        treeEntryGrid.collapse(collapses.stream().mapToInt(Integer::intValue).toArray());
        this.getView().updateView(ENTRYENTITY);
    }

    private String formatData(DynamicObject object, String rowType, String columnType) {
        if (DEDUCTIBLERATIO.equals(columnType)) {
            if (AbstractDeductSummaryPlugin.RATE_NO_ITEMS.contains(rowType)) {
                return "*";
            }
            BigDecimal rate = object.getBigDecimal(columnType);
            return String.format("%s%%", rate.multiply(new BigDecimal("100")).setScale(2, 4).toString());
        }
        if (AMOUNTORRATIO.equals(columnType) && rowType.equals("2")) {
            BigDecimal rate = object.getBigDecimal(columnType);
            return String.format("%s%%", rate.multiply(new BigDecimal("100")).setScale(2, 4).toString());
        }
        return DataFormat.formatMicrometer(object.getBigDecimal(columnType).setScale(2, 4).toString());
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_SETZ_JMYHHZ_SUMMARY, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        ArrayList<String> sortItems = new ArrayList<String>(128);
        sortItems.addAll(AbstractDeductSummaryPlugin.firstCalItems);
        List secondCollect = AbstractDeductSummaryPlugin.ALL_ITEM_TYPES.stream().filter(a -> a.length() > 1).sorted(Comparator.comparing(String::length).reversed()).collect(Collectors.toList());
        sortItems.addAll(secondCollect);
        sortItems.addAll(AbstractDeductSummaryPlugin.lastCalItems);
        this.fillParams(customParams);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        ArrayList<String> showItems = new ArrayList<String>(128);
        for (String itemType : sortItems) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_SETZ_JMYHHZ_SUMMARY);
            String itemno = AbstractDeductSummaryPlugin.itemtypeToItemno.get(itemType);
            dynamicObject.set(ORIITEMNO, (Object)itemno);
            dynamicObject.set(ITEMNO, (Object)itemno);
            dynamicObject.set(ITEMTYPE, (Object)itemType);
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            this.calcRow(itemType, dynamicObject, customParams);
            sum.add((Object)dynamicObject);
        }
        this.buildItemNo(sum);
        this.calSelect(sum);
        showItems.addAll(AbstractDeductSummaryPlugin.level1);
        showItems.addAll(AbstractDeductSummaryPlugin.level2);
        showItems.addAll(AbstractDeductSummaryPlugin.level3);
        this.buildTree(showItems, sum);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void calSelect(DynamicObjectCollection sum) {
        DynamicObject first;
        String itemtype;
        String apitudetype;
        DynamicObject first2;
        List collect = sum.stream().filter(a -> this.selectItems.contains(a.getString(ITEMTYPE))).collect(Collectors.toList());
        long count = collect.stream().filter(a -> a.getBigDecimal(AMOUNTORRATIO).compareTo(BigDecimal.ZERO) > 0).count();
        Object quolifications = this.paramMaps.get("quolifications");
        Optional<Object> yxsy = Optional.empty();
        if (EmptyCheckUtils.isNotEmpty((Object)quolifications)) {
            yxsy = ((DynamicObjectCollection)quolifications).stream().filter(a -> a.getBoolean("yxsy")).findFirst();
        }
        if (count == 1L) {
            first2 = collect.stream().filter(a -> a.getBigDecimal(AMOUNTORRATIO).compareTo(BigDecimal.ZERO) > 0).findFirst().get();
            this.dataMap.get("4").set(AMOUNTORRATIO, (Object)first2.getBigDecimal(AMOUNTORRATIO));
            first2.set(CANUSE, (Object)Boolean.TRUE);
        } else if (count > 1L) {
            if (yxsy.isPresent()) {
                apitudetype = ((DynamicObject)yxsy.get()).getString("apitudetype");
                itemtype = AbstractDeductSummaryPlugin.apitudetypeToItem.get(apitudetype);
                if (StringUtil.isNotEmpty((CharSequence)itemtype)) {
                    first = this.dataMap.get(itemtype);
                    this.dataMap.get("4").set(AMOUNTORRATIO, (Object)first.getBigDecimal(AMOUNTORRATIO));
                    first.set(CANUSE, (Object)Boolean.TRUE);
                }
            } else {
                first2 = (DynamicObject)collect.stream().reduce((r1, r2) -> r1.getBigDecimal(AMOUNTORRATIO).compareTo(r2.getBigDecimal(AMOUNTORRATIO)) > 0 ? r1 : r2).get();
                this.dataMap.get("4").set(AMOUNTORRATIO, (Object)first2.getBigDecimal(AMOUNTORRATIO));
                first2.set(CANUSE, (Object)Boolean.TRUE);
            }
        } else if (count == 0L && yxsy.isPresent() && StringUtil.isNotEmpty((CharSequence)(itemtype = AbstractDeductSummaryPlugin.apitudetypeToItem.get(apitudetype = ((DynamicObject)yxsy.get()).getString("apitudetype"))))) {
            first = this.dataMap.get(itemtype);
            this.dataMap.get("4").set(AMOUNTORRATIO, (Object)first.getBigDecimal(AMOUNTORRATIO));
            first.set(CANUSE, (Object)Boolean.TRUE);
        }
        BigDecimal bigDecimal3 = this.dataMap.get("3").getBigDecimal(AMOUNTORRATIO);
        BigDecimal bigDecimal4 = this.dataMap.get("4").getBigDecimal(AMOUNTORRATIO);
        BigDecimal bigDecimal5 = this.dataMap.get("5").getBigDecimal(AMOUNTORRATIO);
        BigDecimal bigDecimal6 = this.dataMap.get("6").getBigDecimal(AMOUNTORRATIO);
        BigDecimal sevenrow = bigDecimal3.add(bigDecimal5).subtract(bigDecimal4).subtract(bigDecimal6);
        this.dataMap.get("7").set(AMOUNTORRATIO, (Object)(sevenrow.compareTo(BigDecimal.ZERO) > 0 ? sevenrow : BigDecimal.ZERO));
    }

    private void buildItemNo(DynamicObjectCollection sum) {
        HashMap<String, Integer> itemsNumMap = new HashMap<String, Integer>(8);
        for (DynamicObject dynamicObject : sum) {
            String itemtype = dynamicObject.getString(ITEMTYPE);
            if (AbstractDeductSummaryPlugin.FIXED_ITEMS.contains(itemtype) || !dynamicObject.getBoolean(QUALIFIED) || itemtype.lastIndexOf(".") <= 0) continue;
            int i = itemtype.lastIndexOf(".");
            String key = itemtype.substring(0, i);
            Integer integer = itemsNumMap.getOrDefault(key, 0);
            int level = key.split("\\.").length - 1;
            if (level == 1) {
                int i1 = key.lastIndexOf(".");
                String substring = key.substring(i1 + 1);
                dynamicObject.set(ITEMNO, (Object)(substring + letters[integer]));
            } else {
                dynamicObject.set(ITEMNO, (Object)numbers[integer]);
            }
            itemsNumMap.put(key, integer + 1);
        }
    }

    private void fillParams(Map<String, Object> customParams) {
        this.paramMaps.put("policy", this.getPolicy(customParams));
        this.paramMaps.put("quolifications", this.getQualifications(customParams));
        this.paramMaps.put("xwqydg", this.getXwqyDg(customParams));
        this.paramMaps.put("gxjsdg", this.getGxjsDg(customParams));
        this.paramMaps.put("rjjcdg", this.getRjjcDg(customParams));
        this.paramMaps.put("rjjcdgsyzc", this.getRjjcdgSyzc(customParams));
        this.paramMaps.put("xmsddg", this.getXmsdDg(customParams));
        this.paramMaps.put("qyyhdg", this.getQyyhDg(customParams));
        this.paramMaps.put("ynssdedg", this.getYnssdeDg(customParams));
        this.paramMaps.put("yssl", this.getYssl(customParams));
        this.paramMaps.put("qtseyhtz", this.getQtseyhtz(customParams));
    }

    private void calcRow(String itemType, DynamicObject rowData, Map<String, Object> customParams) {
        BigDecimal jmbl = BigDecimal.ZERO;
        BigDecimal jehbl = BigDecimal.ZERO;
        Boolean canuser = Boolean.FALSE;
        Boolean qualified = Boolean.TRUE;
        rowData.set(DEDUCTIBLERATIO, (Object)jmbl);
        rowData.set(AMOUNTORRATIO, (Object)jehbl);
        rowData.set(QUALIFIED, (Object)qualified);
        rowData.set(CANUSE, (Object)canuser);
        if (StringUtil.equals((CharSequence)itemType, (CharSequence)"1")) {
            Object ynssdedg = this.paramMaps.get("ynssdedg");
            BigDecimal amount = ynssdedg == null ? BigDecimal.ZERO : ((DynamicObject)ynssdedg).getBigDecimal("zzqcurrent");
            rowData.set(AMOUNTORRATIO, (Object)amount);
        } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"2")) {
            Object yssl = this.paramMaps.get("yssl");
            if (EmptyCheckUtils.isNotEmpty((Object)yssl)) {
                rowData.set(AMOUNTORRATIO, yssl);
            }
        } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"3")) {
            DynamicObject ynssde = this.dataMap.get("1");
            DynamicObject yssl = this.dataMap.get("2");
            if (EmptyCheckUtils.isNotEmpty((Object)yssl) && EmptyCheckUtils.isNotEmpty((Object)ynssde)) {
                BigDecimal ysslBigdecimal;
                BigDecimal ynssdeBigdecimal = ynssde.getBigDecimal(AMOUNTORRATIO);
                BigDecimal amount = ynssdeBigdecimal.multiply(ysslBigdecimal = yssl.getBigDecimal(AMOUNTORRATIO)).setScale(2, 4);
                if (amount.compareTo(BigDecimal.ZERO) < 0) {
                    amount = BigDecimal.ZERO;
                }
                rowData.set(AMOUNTORRATIO, (Object)amount);
            }
        } else if (!StringUtil.equals((CharSequence)itemType, (CharSequence)"4")) {
            if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.1")) {
                ArrayList itemtyps = Lists.newArrayList((Object[])new String[]{"4.1.a"});
                this.calcSumRow(itemtyps, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.1.a")) {
                Object xwqydg = this.paramMaps.get("xwqydg");
                if (EmptyCheckUtils.isNotEmpty((Object)xwqydg)) {
                    DynamicObjectCollection xwqydg1 = (DynamicObjectCollection)xwqydg;
                    String smalldeductamount = "smalldeductamount";
                    jehbl = xwqydg1.stream().map(a -> a.getBigDecimal("smalldeductamount") == null ? BigDecimal.ZERO : a.getBigDecimal("smalldeductamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    rowData.set(AMOUNTORRATIO, (Object)jehbl);
                }
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.2")) {
                ArrayList itemtyps = Lists.newArrayList((Object[])new String[]{"4.2.a", "4.2.b"});
                this.calcSumRow(itemtyps, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.2.a")) {
                this.calcGxjsqydgRow(rowData, "1");
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.2.b")) {
                this.calcGxjsqydgRow(rowData, "2");
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.3")) {
                ArrayList itemtyps = Lists.newArrayList((Object[])new String[]{"4.3.a", "4.3.b"});
                this.calcSumRow(itemtyps, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.3.a")) {
                this.calcJsxjxfwqyRow(itemType, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.3.b")) {
                this.calcJsxjxfwqyRow(itemType, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4")) {
                ArrayList<String> itemtyps = new ArrayList<String>(32);
                for (int i = 0; i < 21; ++i) {
                    String type = "4.4." + letters[i];
                    itemtyps.add(type);
                }
                this.calcSumRow(itemtyps, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.a")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"110"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.b")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"120"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.c")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"130"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.d")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"140"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.e")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"140"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.f")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"150"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.g")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"150"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.h")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"160"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.i")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"210"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.j")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"210"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.k")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"220", "230"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.l")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"311", "321"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.m")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"311", "321"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.n")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"312", "314", "322", "323", "324"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.o")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"400"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.p")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"400"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.q")) {
                this.calcHyyhRow("1", "1", Lists.newArrayList((Object[])new String[]{"600"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.r")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"500"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.s")) {
                this.calcHyyhRow("2", "1", Lists.newArrayList((Object[])new String[]{"600"}), rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.t")) {
                this.calcQtyhRow("5", "ETC001", rowData, customParams);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.4.u")) {
                this.calcQtyhRow("5", "ETC004", rowData, customParams);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5")) {
                ArrayList<String> itemtyps = new ArrayList<String>(8);
                for (int i = 0; i < 7; ++i) {
                    String type = "4.5." + letters[i];
                    itemtyps.add(type);
                }
                this.calcSumRow(itemtyps, rowData);
            } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.a")) {
                this.calcQyyh("FTA001", rowData);
            } else if (!StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.b")) {
                if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.c")) {
                    this.calcQyyh("FTA002", rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.d")) {
                    this.calcQyyh("FTA003", rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.e")) {
                    this.calcQyyh("FTA004", rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.f")) {
                    this.calcQyyh("FTA005", rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.5.g")) {
                    this.calcQyyh("FTA006", rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6")) {
                    ArrayList<String> itemtyps = new ArrayList<String>(8);
                    for (int i = 0; i < 5; ++i) {
                        String type = "4.6." + letters[i];
                        itemtyps.add(type);
                    }
                    this.calcSumRow(itemtyps, rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6.a")) {
                    this.calcQtyqmz(itemType, rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6.b")) {
                    this.calcQtyqmz(itemType, rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6.c")) {
                    this.calcQtyqmz(itemType, rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6.d")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"4.6.e")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"5")) {
                    this.calcXmsde(rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6")) {
                    ArrayList<String> itemtyps = new ArrayList<String>(8);
                    for (int i = 0; i < 6; ++i) {
                        String type = "6." + numbers[i];
                        itemtyps.add(type);
                    }
                    this.calcSumRow(itemtyps, rowData);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.1")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.2")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.3")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.4")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.5")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"6.6")) {
                    this.calcQtseyhtz(itemType, rowData, customParams);
                } else if (StringUtil.equals((CharSequence)itemType, (CharSequence)"7")) {
                    DynamicObject a3 = this.dataMap.get("3");
                    DynamicObject a4 = this.dataMap.get("4");
                    DynamicObject a5 = this.dataMap.get("5");
                    DynamicObject a6 = this.dataMap.get("6");
                    BigDecimal a3bigdecimal = EmptyCheckUtils.isNotEmpty((Object)a3) ? a3.getBigDecimal(AMOUNTORRATIO) : BigDecimal.ZERO;
                    BigDecimal a4bigdecimal = EmptyCheckUtils.isNotEmpty((Object)a4) ? a4.getBigDecimal(AMOUNTORRATIO) : BigDecimal.ZERO;
                    BigDecimal a5bigdecimal = EmptyCheckUtils.isNotEmpty((Object)a5) ? a5.getBigDecimal(AMOUNTORRATIO) : BigDecimal.ZERO;
                    BigDecimal a6bigdecimal = EmptyCheckUtils.isNotEmpty((Object)a6) ? a6.getBigDecimal(AMOUNTORRATIO) : BigDecimal.ZERO;
                    BigDecimal subtract = a3bigdecimal.subtract(a4bigdecimal).add(a5bigdecimal).subtract(a6bigdecimal);
                    rowData.set(AMOUNTORRATIO, (Object)(subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO));
                }
            }
        }
        if (!AbstractDeductSummaryPlugin.FIXED_ITEMS.contains(itemType) && BigDecimal.ZERO.compareTo(rowData.getBigDecimal(AMOUNTORRATIO)) >= 0) {
            rowData.set(QUALIFIED, (Object)Boolean.FALSE);
            rowData.set(CANUSE, (Object)Boolean.FALSE);
        }
        this.dataMap.put(itemType, rowData);
    }

    private void calcQyyh(String projectNumber, DynamicObject rowData) {
        DynamicObjectCollection qyyhdgs;
        Optional<DynamicObject> basenumber;
        Object qyyhdg = this.paramMaps.get("qyyhdg");
        if (EmptyCheckUtils.isNotEmpty((Object)qyyhdg) && (basenumber = (qyyhdgs = (DynamicObjectCollection)qyyhdg).stream().filter(a -> projectNumber.equals(a.getString("basenumber"))).findAny()).isPresent()) {
            rowData.set(DEDUCTIBLERATIO, (Object)basenumber.get().getBigDecimal("jmrate"));
            rowData.set(AMOUNTORRATIO, (Object)basenumber.get().getBigDecimal("jmse"));
        }
    }

    private void calcQtyhRow(String apitudetype, String companytype, DynamicObject rowData, Map<String, Object> customParams) {
        DynamicObjectCollection apitudeentryentity;
        long count;
        rowData.set(QUALIFIED, (Object)Boolean.FALSE);
        Object policy = this.paramMaps.get("policy");
        if (EmptyCheckUtils.isNotEmpty((Object)policy) && (count = (apitudeentryentity = ((DynamicObject)policy).getDynamicObjectCollection("apitudeentryentity")).stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)apitudetype)).filter(a -> StringUtil.equals((CharSequence)a.getString("companytype.number"), (CharSequence)companytype)).count()) > 0L) {
            BigDecimal ynssde = this.dataMap.get("1") == null ? BigDecimal.ZERO : this.dataMap.get("1").getBigDecimal(AMOUNTORRATIO);
            BigDecimal rate = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            if (StringUtil.equals((CharSequence)companytype, (CharSequence)"ETC001")) {
                Optional<DynamicObject> first = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)apitudetype)).filter(a -> StringUtil.equals((CharSequence)a.getString("companytype.number"), (CharSequence)companytype)).findFirst();
                Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
                Date apitudestartdate = first.get().getDate("apitudestartdate");
                Date enddate5 = DateUtils.addYear((Date)apitudestartdate, (int)5);
                Date enddate2 = DateUtils.addYear((Date)apitudestartdate, (int)2);
                rate = skssqz.before(enddate2) || DateUtils.format((Date)skssqz).equals(DateUtils.format((Date)enddate2)) ? BigDecimal.valueOf(0.25) : (skssqz.after(enddate5) ? BigDecimal.ZERO : BigDecimal.valueOf(0.125));
            } else if (StringUtil.equals((CharSequence)companytype, (CharSequence)"ETC004")) {
                rate = BigDecimal.valueOf(0.1);
            }
            amount = rate.multiply(ynssde).setScale(2, 4);
            rowData.set(AMOUNTORRATIO, (Object)amount);
            rowData.set(DEDUCTIBLERATIO, (Object)rate);
            rowData.set(QUALIFIED, (Object)Boolean.TRUE);
        }
    }

    private void calcHyyhRow(String yhzc, String apitudetype, List<String> companytype, DynamicObject rowData) {
        Object rjjcdgObj;
        DynamicObjectCollection apitudeentryentity;
        long count;
        Object policy;
        String syyhzc;
        rowData.set(QUALIFIED, (Object)Boolean.FALSE);
        Object syzcObj = this.paramMaps.get("rjjcdgsyzc");
        if (syzcObj != null && StringUtil.equals((CharSequence)yhzc, (CharSequence)(syyhzc = ((DynamicObject)syzcObj).getString("syyhzc"))) && EmptyCheckUtils.isNotEmpty((Object)(policy = this.paramMaps.get("policy"))) && (count = (apitudeentryentity = ((DynamicObject)policy).getDynamicObjectCollection("apitudeentryentity")).stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)apitudetype)).filter(a -> companytype.contains(a.getString("companytype.number"))).filter(a -> !Boolean.TRUE.equals(a.get("yxsy"))).count()) > 0L && EmptyCheckUtils.isNotEmpty((Object)(rjjcdgObj = this.paramMaps.get("rjjcdg")))) {
            DynamicObjectCollection rjjcdgObj1 = (DynamicObjectCollection)rjjcdgObj;
            Optional<DynamicObject> first = rjjcdgObj1.stream().filter(a -> StringUtil.equals((CharSequence)a.getString(ITEMTYPE), (CharSequence)"15")).findFirst();
            Optional<DynamicObject> first1 = rjjcdgObj1.stream().filter(a -> StringUtil.equals((CharSequence)a.getString(ITEMTYPE), (CharSequence)"16")).findFirst();
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal rate = BigDecimal.ZERO;
            if (first.isPresent()) {
                rate = first.get().getBigDecimal("jesl");
            }
            if (first1.isPresent()) {
                amount = first1.get().getBigDecimal("jesl");
            }
            rowData.set(AMOUNTORRATIO, (Object)amount);
            rowData.set(DEDUCTIBLERATIO, (Object)rate);
            rowData.set(QUALIFIED, (Object)Boolean.TRUE);
        }
    }

    private void calcQtyqmz(String itemType, DynamicObject rowData) {
        rowData.set(QUALIFIED, (Object)Boolean.FALSE);
        Object policy = this.paramMaps.get("policy");
        if (EmptyCheckUtils.isNotEmpty((Object)policy)) {
            DynamicObjectCollection apitudeentryentity = ((DynamicObject)policy).getDynamicObjectCollection("apitudeentryentity");
            long count = 0L;
            if ("4.6.a".equals(itemType)) {
                count = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)"5") && "ETC002".equals(a.getString("companytype.number"))).count();
            } else if ("4.6.b".equals(itemType)) {
                count = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)"5") && "ETC003".equals(a.getString("companytype.number"))).count();
            } else if ("4.6.c".equals(itemType)) {
                count = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)"5") && "ETC009".equals(a.getString("companytype.number"))).count();
            }
            if (count > 0L) {
                BigDecimal jmbl = BigDecimal.valueOf(0.25);
                BigDecimal ynssde = this.dataMap.get("1") == null ? BigDecimal.ZERO : this.dataMap.get("1").getBigDecimal(AMOUNTORRATIO);
                rowData.set(DEDUCTIBLERATIO, (Object)jmbl);
                rowData.set(AMOUNTORRATIO, (Object)ynssde.multiply(jmbl).setScale(2, 4));
                rowData.set(QUALIFIED, (Object)Boolean.TRUE);
            }
        }
    }

    private void calcQtseyhtz(String itemType, DynamicObject rowData, Map<String, Object> customParams) {
        Object qtseyhtz = this.paramMaps.get("qtseyhtz");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;
        if (EmptyCheckUtils.isNotEmpty((Object)qtseyhtz)) {
            DynamicObjectCollection cols = (DynamicObjectCollection)qtseyhtz;
            BigDecimal ynssde = this.dataMap.get("1") == null ? BigDecimal.ZERO : this.dataMap.get("1").getBigDecimal(AMOUNTORRATIO);
            switch (itemType) {
                case "6.1": {
                    amount = this.getSum(this.getOtherSummary(customParams), ENTRYENTITY_JMSE, "100");
                    break;
                }
                case "6.2": {
                    amount = this.getSum(this.getOtherSummary(customParams), ENTRYENTITY_JMSE, "200");
                    break;
                }
                case "6.3": {
                    amount = this.getSum(this.getOtherSummary(customParams), ENTRYENTITY_JMSE, "300");
                    break;
                }
                case "6.4": {
                    rate = this.getQtseyhtzValue(cols, ENTRYENTITY_JMBL, "500", "dffxdbfmz");
                    amount = this.calcJzmz(rate, ynssde);
                    break;
                }
                case "6.5": {
                    rate = this.getQtseyhtzValue(cols, ENTRYENTITY_JMBL, "500", "dffxdbfjz");
                    amount = this.calcJzmz(rate, ynssde);
                    break;
                }
                case "6.6": {
                    rate = this.getQtseyhtzValue(cols, ENTRYENTITY_JMBL, "400", "qt");
                    amount = ynssde.multiply(rate).setScale(2, 4);
                    break;
                }
                case "4.6.d": {
                    amount = this.getSum(this.getOtherSummary(customParams), ENTRYENTITY_JMSE, "600");
                    break;
                }
                case "4.6.e": {
                    amount = this.getSum(this.getOtherSummary(customParams), ENTRYENTITY_JMSE, "700");
                }
            }
            rowData.set(DEDUCTIBLERATIO, (Object)rate);
            rowData.set(AMOUNTORRATIO, (Object)amount);
        }
    }

    private DynamicObjectCollection getOtherSummary(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID);
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        QFilter filter = new QFilter("org", "in", OrgGroupService.getOrgIds(Long.valueOf(orgid), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz)));
        filter.and(new QFilter("year", ">=", (Object)startDate));
        filter.and(new QFilter("year", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        return QueryServiceHelper.query((String)"tccit_other_deductions", (String)"org,year,entryentity.project.number,entryentity.type,entryentity.jmbl,entryentity.jmse", (QFilter[])new QFilter[]{filter});
    }

    private BigDecimal getSum(DynamicObjectCollection cols, String field, String code) {
        BigDecimal value = cols.stream().filter(s -> code.equals(s.getString("entryentity.project.number"))).map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return value;
    }

    private BigDecimal calcJzmz(BigDecimal rate, BigDecimal ynssde) {
        BigDecimal gdbl = new BigDecimal("0.4");
        BigDecimal amount = ynssde;
        for (int i = 0; i < this.JZMZ_TYPES.size(); ++i) {
            String itemType = this.JZMZ_TYPES.get(i);
            BigDecimal itemAmount = this.dataMap.get(itemType) == null ? BigDecimal.ZERO : this.dataMap.get(itemType).getBigDecimal(AMOUNTORRATIO);
            amount = "5".equals(itemType) ? amount.add(itemAmount) : amount.subtract(itemAmount);
        }
        BigDecimal otherAmount = BigDecimal.ZERO;
        for (int i = 0; i < this.EXCLUDE_TYPES.size(); ++i) {
            String itemType = this.EXCLUDE_TYPES.get(i);
            BigDecimal itemAmount = this.dataMap.get(itemType) == null ? BigDecimal.ZERO : this.dataMap.get(itemType).getBigDecimal(AMOUNTORRATIO);
            otherAmount = otherAmount.add(itemAmount);
        }
        amount = amount.add(otherAmount);
        return rate.multiply(gdbl).multiply(amount).setScale(2, 4);
    }

    private BigDecimal getQtseyhtzValue(DynamicObjectCollection cols, String field, String code, String type) {
        BigDecimal value = BigDecimal.ZERO;
        Optional<Object> first = Optional.empty();
        first = type != null ? cols.stream().filter(s -> code.equals(s.getString("entryentity.project.number")) && type.equals(s.getString("entryentity.type"))).findFirst() : cols.stream().filter(s -> code.equals(s.getString("entryentity.project.number"))).findFirst();
        if (first.isPresent()) {
            DynamicObject dynamicObject = (DynamicObject)first.get();
            value = dynamicObject.getBigDecimal(field);
        }
        return value;
    }

    private void calcXmsde(DynamicObject rowData) {
        Object obj = this.paramMaps.get("xmsddg");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;
        if (EmptyCheckUtils.isNotEmpty((Object)obj)) {
            DynamicObjectCollection xmsd = (DynamicObjectCollection)obj;
            String s = ResManager.loadKDString((String)"\u51cf\u534a\u5f81\u6536", (String)"DeductPreferentialSummaryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            amount = xmsd.stream().filter(a -> StringUtil.equals((CharSequence)s, (CharSequence)a.getString("yhfs"))).map(v -> v.getBigDecimal("xmsde")).reduce(BigDecimal.ZERO, BigDecimal::add);
            Optional<DynamicObject> max = this.dataMap.values().stream().filter(a -> AbstractDeductSummaryPlugin.level3.contains(a.getString(ITEMTYPE))).filter(a -> BigDecimal.ZERO.compareTo(a.getBigDecimal(DEDUCTIBLERATIO) == null ? BigDecimal.ZERO : a.getBigDecimal(DEDUCTIBLERATIO)) <= 0).max(Comparator.comparing(n -> n.getBigDecimal(AMOUNTORRATIO) == null ? BigDecimal.ZERO : n.getBigDecimal(AMOUNTORRATIO)));
            if (max.isPresent()) {
                rate = max.get().getBigDecimal(DEDUCTIBLERATIO);
            }
        }
        rate = BigDecimal.valueOf(0.25).subtract(rate);
        BigDecimal result = BigDecimal.valueOf(0.5).multiply(amount).multiply(rate).setScale(2, 4);
        rowData.set(AMOUNTORRATIO, (Object)result);
    }

    private void calcSumRow(ArrayList<String> itemtyps, DynamicObject rowData) {
        BigDecimal a2bigdecimal = BigDecimal.ZERO;
        for (String itemtyp : itemtyps) {
            DynamicObject b2 = this.dataMap.get(itemtyp);
            BigDecimal b2bigdecimal = EmptyCheckUtils.isNotEmpty((Object)b2) ? b2.getBigDecimal(AMOUNTORRATIO) : BigDecimal.ZERO;
            a2bigdecimal = a2bigdecimal.add(b2bigdecimal);
        }
        rowData.set(AMOUNTORRATIO, (Object)a2bigdecimal);
    }

    private void calcJsxjxfwqyRow(String itemType, DynamicObject rowData) {
        rowData.set(QUALIFIED, (Object)Boolean.FALSE);
        Object policy = this.paramMaps.get("policy");
        if (EmptyCheckUtils.isNotEmpty((Object)policy)) {
            DynamicObjectCollection apitudeentryentity = ((DynamicObject)policy).getDynamicObjectCollection("apitudeentryentity");
            long count = 0L;
            if ("4.3.a".equals(itemType)) {
                count = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)"2") && this.list43a.contains(a.getString("companytype.number"))).count();
            } else if ("4.3.b".equals(itemType)) {
                count = apitudeentryentity.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("apitudetype"), (CharSequence)"2") && this.list43b.contains(a.getString("companytype.number"))).count();
            }
            if (count > 0L) {
                BigDecimal jmbl = BigDecimal.valueOf(0.1);
                BigDecimal ynssde = this.dataMap.get("1") == null ? BigDecimal.ZERO : this.dataMap.get("1").getBigDecimal(AMOUNTORRATIO);
                rowData.set(DEDUCTIBLERATIO, (Object)jmbl);
                rowData.set(AMOUNTORRATIO, (Object)ynssde.multiply(jmbl).setScale(2, 4));
                rowData.set(QUALIFIED, (Object)Boolean.TRUE);
            }
        }
    }

    private void calcGxjsqydgRow(DynamicObject rowData, String yhlx) {
        DynamicObjectCollection gxjsdg1;
        Optional<DynamicObject> first;
        rowData.set(QUALIFIED, (Object)Boolean.FALSE);
        Object gxjsdg = this.paramMaps.get("gxjsdg");
        if (EmptyCheckUtils.isNotEmpty((Object)gxjsdg) && (first = (gxjsdg1 = (DynamicObjectCollection)gxjsdg).stream().filter(a -> StringUtil.equals((CharSequence)a.getString(ITEMTYPE), (CharSequence)yhlx)).findFirst()).isPresent()) {
            BigDecimal jmbl = first.get().getBigDecimal("rate");
            BigDecimal jehbl = first.get().getBigDecimal("jmse");
            rowData.set(DEDUCTIBLERATIO, (Object)jmbl);
            rowData.set(AMOUNTORRATIO, (Object)jehbl);
            rowData.set(QUALIFIED, (Object)Boolean.TRUE);
        }
    }

    private void buildTree(List<String> showItems, DynamicObjectCollection sum) {
        for (String itemType : showItems) {
            Optional<DynamicObject> first = sum.stream().filter(s -> s.getString(ITEMTYPE).equals(itemType)).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject dynamicObject1 = first.get();
            dynamicObject1.set(MYPARENTID, (Object)this.getParentId(itemType));
            dynamicObject1.set(MYPKID, (Object)this.getPkId(itemType));
        }
    }

    private Long getPkId(String itemType) {
        Long pkId = AbstractDeductSummaryPlugin.ALL_ITEM_TYPES.indexOf(itemType) + 1;
        this.keyIds.put(itemType, pkId);
        return pkId;
    }

    private Long getParentId(String id) {
        if (AbstractDeductSummaryPlugin.level1.contains(id)) {
            return 0L;
        }
        if (AbstractDeductSummaryPlugin.level2.contains(id) || AbstractDeductSummaryPlugin.level3.contains(id)) {
            return this.keyIds.get(id.substring(0, id.length() - 2));
        }
        return 0L;
    }

    private DynamicObjectCollection getQualifications(Map<String, Object> customParams) {
        Object orgid = customParams.get(ORGID);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgid.toString()));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return ((DynamicObject)result.getData()).getDynamicObjectCollection("apitudeentryentity");
        }
        return new DynamicObjectCollection();
    }

    private DynamicObject getPolicy(Map<String, Object> customParams) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)"id", (QFilter[])this.getQfilter(customParams).toArray());
        if (dynamicObject == null) {
            String msg = ResManager.loadKDString((String)"\u653f\u7b56\u786e\u8ba4\u672a\u5b8c\u6210\u3002", (String)"DeductPreferentialSummaryPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"tccit_policy_confirm");
    }

    private DynamicObjectCollection getXwqyDg(Map<String, Object> customParams) {
        return QueryServiceHelper.query((String)"tccit_small_summary", (String)"smalldeductamount,orgid,skssqz,skssqq ", (QFilter[])this.getQfilter2(customParams).toArray());
    }

    private DynamicObjectCollection getGxjsDg(Map<String, Object> customParams) {
        return QueryServiceHelper.query((String)"tccit_dg_a301010200_sum", (String)" * ", (QFilter[])this.getQfilter2(customParams).toArray());
    }

    private DynamicObjectCollection getRjjcDg(Map<String, Object> customParams) {
        return QueryServiceHelper.query((String)"tccit_soft_ic_yg_summary", (String)" orgid,skssqq,skssqz,itemtype,jesl", (QFilter[])this.getQfilter2(customParams).toArray());
    }

    private DynamicObject getRjjcdgSyzc(Map<String, Object> customParams) {
        return QueryServiceHelper.queryOne((String)"tccit_soft_ic_summary", (String)" orgid,skssqq,skssqz,syyhzc", (QFilter[])this.getQfilter2(customParams).toArray());
    }

    private DynamicObjectCollection getXmsdDg(Map<String, Object> customParams) {
        return QueryServiceHelper.query((String)"tccit_getredu_sum", (String)" orgid,skssqq,skssqz,sheetname,xmsde,yhfs", (QFilter[])this.getQfilter2(customParams).toArray());
    }

    private DynamicObjectCollection getQyyhDg(Map<String, Object> customParams) {
        QFilter qfilter2 = this.getQfilter2(customParams);
        return QueryServiceHelper.query((String)"tccit_jmyhhz_summary", (String)"jmse,jmrate,companytype.number basenumber", (QFilter[])qfilter2.toArray());
    }

    private DynamicObject getYnssdeDg(Map<String, Object> customParams) {
        QFilter baseQfilters = this.getQfilter2(customParams);
        baseQfilters.and(new QFilter(ITEMTYPE, "=", (Object)"0"));
        return QueryServiceHelper.queryOne((String)"tccit_dg_a100000_7_sum", (String)"zzqcurrent", (QFilter[])baseQfilters.toArray());
    }

    private BigDecimal getYssl(Map<String, Object> customParams) {
        String skssqz;
        String skssqq;
        String orgid = (String)customParams.get(ORGID);
        List list = AssistService.queryAssistParams((String)"SYSL", (String)orgid, (String)(skssqq = (String)customParams.get(SKSSQQ)), (String)(skssqz = (String)customParams.get(SKSSQZ)));
        if (list.size() > 0) {
            return new BigDecimal((String)list.get(0)).divide(DIVISOR, 2, 4);
        }
        return BigDecimal.ZERO;
    }

    private DynamicObjectCollection getQtseyhtz(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID);
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        filter.and(new QFilter("year", ">=", (Object)startDate));
        filter.and(new QFilter("year", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        return QueryServiceHelper.query((String)"tccit_other_deductions", (String)"org,year,entryentity.project.number,entryentity.type,entryentity.jmbl,entryentity.jmse", (QFilter[])new QFilter[]{filter});
    }

    private QFilter getQfilter(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID);
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        QFilter filter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)).and("startdate", ">=", (Object)startDate).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        return filter;
    }

    private QFilter getQfilter2(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID);
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        QFilter filter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)).and(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        return filter;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_SETZ_JMYHHZ_SUMMARY, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(DeductPreferentialSummaryPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{SmallEnterprisesTZFormPlugin.class.getSimpleName(), SoftIcTZFormPlugin.class.getSimpleName(), SonGetReduceFormPlugin.class.getSimpleName(), JmyhhzDgFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

