/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FieldTip;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.helper.TzDialogValidHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.datadetails.DataDetailsOpenUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.job.JobUtils;
import kd.taxc.tccit.business.calc.YearAdjustCalcTask;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.engine.YearAccEngine;
import kd.taxc.tccit.business.graph.BuilderYearEngineGraphService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.enums.NssbDraftTypeEnum;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.enums.SjjtDraftTypeEnum;
import kd.taxc.tccit.common.utils.DraftEntityUtils;
import org.apache.commons.lang3.StringUtils;

public class DeductTZDetailFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
IDraftTypeObserver,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(DeductTZDetailFormPlugin.class);
    private final Set<String> NORULELIST = Sets.newHashSet((Object[])new String[]{"ywzdf_sr", "ggxcf_sr", "xwqyyhdg_quarter1", "xwqyyhdg_quarter2", "xwqyyhdg_quarter3", "xwqyyhdg_quarter4", "dksszbj_jtbl", "dksszbj_dksszbjye", "dksszbj_dksszbj", "dksszbj_nstzje", "kxssl", "yqxsyfzjxccpdclbf", "xekc_6a", "xekc_6b", "xekc_6c"});
    private final Set<String> NORULENUMBER = Sets.newHashSet((Object[])new String[]{"001", "001_01", "001_03", "001_04", "001_05", "002", "002_01", "002_02", "003"});
    private final Set<String> BY_RULES = YearAccEngine.getByRules();
    private final Set<String> CAN_NOT_NEGATIVE = Sets.newHashSet((Object[])new String[]{"tccit_dg_b105019_det", "tccit_dg_b105020_det", "tccit_dg_b105021_det", "tccit_beforetax_detail", "tccit_dg_b105038_det", "tccit_dg_a100000_7_det", "tccit_branch_share_detail", "tccit_recoup_deficit"});
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ITEMNUMBER = "itemnumber";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    public static final String CLOSECALLBACK_KEY = "closecallback";
    public static final String TOTAL_RESULT_KEY = "adjustsumamount";
    private static final String WSJTS = "entryentity1";
    private static final String QSMS = "flexpanelap2";
    private static final String[] ENTRYTYPES = new String[]{"depreciate", "origin", "normal", "quick"};
    private final List<String> ENTRYTYPE = new ArrayList<String>(Arrays.asList(ENTRYTYPES));
    private final List<String> YJ_YHXM = Lists.newArrayList((Object[])new String[]{"nontaxincome", "treducedincome", "incredincome", "incredpresent", "adddeduction"});
    public static final String IS_CONFIRM_SAVE = "isConfirmSave";
    public static final String CAN_CALC_DRAFT = "canCalcDraft";
    private static boolean ENABLE = true;
    private static final String TEMPLATETYPE = "qysdsnb";
    private static final BuilderYearEngineGraphService builderYearEngineGraphService = BuilderYearEngineGraphService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.showRightFlex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setTip(customParams);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        this.setEnable(customParams);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        String entrytype = (String)customParams.get("entrytype");
        String entryname = (String)customParams.get("entryname");
        Boolean isExists110Rules = customParams.getOrDefault("isExists110Rules", Boolean.FALSE);
        Boolean existsRules = customParams.getOrDefault("existsRules", Boolean.TRUE);
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,titlename,adjustexplain";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, draftTypeObjectVo.getAdjustDetail().getNumber(), selectPrope);
        this.doSetAdjustList(customParams, draftTypeObjectVo);
        if (this.isNoRullItem(entrytype, itemnumber, entryname, isExists110Rules, existsRules)) {
            this.appendCard(customParams, entrytype, itemnumber, adjustDetails, null, entryname);
            return;
        }
        DynamicObject[] genericObjects = this.loadDetailData(customParams, entryname);
        if (genericObjects.length == 0) {
            this.appendCard(customParams, entrytype, itemnumber, adjustDetails, null, entryname);
            return;
        }
        Map<String, List<DynamicObject>> map = Arrays.stream(genericObjects).sorted(Comparator.comparing(d -> d.getLong("taxorg_id"))).collect(Collectors.groupingBy(s -> s.getString("taxorg_id") + "_" + s.getString("ruleid_id")));
        this.getModel().beginInit();
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            String entrytype1 = entry.getValue().get(0).getString("entrytype");
            DynamicObject rule = entry.getValue().get(0).getDynamicObject(RULEID);
            if (null != rule) {
                rule = BusinessDataServiceHelper.loadSingleFromCache((Object)rule.getLong("id"), (String)rule.getDataEntityType().getName());
                this.getModel().setValue(RULEID, (Object)rule.getLong("id"), rowIndex);
                this.getModel().setValue("entrytype", (Object)entrytype1, rowIndex);
                DynamicObject taxorg = entry.getValue().get(0).getDynamicObject("taxorg");
                this.getModel().setValue("taxorg", (Object)taxorg, rowIndex);
                this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
                if (this.ENTRYTYPE.contains(entrytype1)) {
                    this.getModel().setValue("itemname", (Object)rule.getDynamicObject("depreciatetype").getString("name"), rowIndex);
                } else if (rule.getDynamicObjectType().getProperties().containsKey((Object)"standingbooks")) {
                    this.getModel().setValue("itemname", (Object)rule.getDynamicObject("standingbooks").getString("name"), rowIndex);
                } else if (rule.getDynamicObjectType().getProperties().containsKey((Object)"itemchoicename")) {
                    this.getModel().setValue("itemname", (Object)rule.getDynamicObject("itemchoicename").getString("name"), rowIndex);
                } else {
                    this.getModel().setValue("itemname", (Object)rule.getDynamicObject("item").getString("name"), rowIndex);
                }
                this.getModel().setValue(ITEMNUMBER, (Object)itemnumber, rowIndex);
                this.getModel().setValue("amount", (Object)this.getAmount(taxorg, rule, entry.getValue()), rowIndex);
                this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(taxorg, rule.getLong("id"), entrytype, adjustDetails), rowIndex);
                this.getModel().setValue("totalamount", (Object)this.getTotalamount(taxorg, rule, entrytype, adjustDetails, entry.getValue()), rowIndex);
                this.getModel().setValue("cardadjustexplain", (Object)this.getAdjustExplain(taxorg, rule.getLong("id"), entrytype, adjustDetails), rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(customParams, entrytype, itemnumber, adjustDetails, genericObjects, entryname);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        String taxorgid = ((String)first.getKey()).split("_")[0];
        String ruleid = ((String)first.getKey()).split("_")[1];
        this.setEntryentitylist(Long.valueOf(taxorgid), Long.valueOf(ruleid), entrytype, entryname);
        this.setVisible(customParams);
    }

    private boolean isNoAdjustType() {
        return "1".equals(this.getView().getFormShowParameter().getCustomParam("noadjusttype"));
    }

    private void setVisible(Map<String, Object> customParams) {
        if ("1".equals(customParams.get("noadjusttype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "btnok"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumamount", "labelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"record"});
            CardEntry entry = (CardEntry)this.getControl(ENTRYENTITY_CARD);
            int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY_CARD);
            for (int i = 0; i < rowCount; ++i) {
                entry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardentryflexpanelap111", "cardentryflexpanelap1"});
                entry.setChildEnable(Boolean.FALSE.booleanValue(), i, new String[]{"totalamount"});
            }
        }
    }

    private void setTip(Map<String, Object> customParams) {
        String tip = (String)customParams.get("tip");
        String tipContent = (String)customParams.get("tipContent");
        if (StringUtil.isNotBlank((CharSequence)tip) && StringUtil.isNotBlank((CharSequence)tipContent)) {
            Label control1 = (Label)this.getControl(tip);
            Tips tips = new Tips();
            tips.setContent(new LocaleString(tipContent));
            tips.setType("text");
            control1.addTips(tips);
        }
    }

    private void doSetAdjustList(Map<String, Object> customParams, DraftTypeObjectVo draftTypeObjectVo) {
        String selectPrope = "adjusttype,itemname,taxorg,preadjust,postadjust,adjustexplain,creator,createtime";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, draftTypeObjectVo.getAdjustRecord().getNumber(), selectPrope);
        if (adjustDetails == null || adjustDetails.length == 0) {
            return;
        }
        for (DynamicObject a : adjustDetails) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("adjusttype", a.get("adjusttype"), rowIndex);
            this.getModel().setValue("title", a.get("itemname"), rowIndex);
            this.getModel().setValue("orgname", a.get("taxorg"), rowIndex);
            this.getModel().setValue("preadjust", a.get("preadjust"), rowIndex);
            this.getModel().setValue("postadjust", a.get("postadjust"), rowIndex);
            this.getModel().setValue("adjustexplain", a.get("adjustexplain"), rowIndex);
            this.getModel().setValue("creator", a.get("creator_id"), rowIndex);
            this.getModel().setValue("createtime", a.get("createtime"), rowIndex);
        }
    }

    private void setEnable(Map<String, Object> customParams) {
        if (Boolean.parseBoolean(String.valueOf(customParams.get("showNotEditableTips")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6570\u636e\u5df2\u63d0\u4ea4/\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"DeductTZDetailFormPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        String orgid = (String)customParams.get(ORGID);
        String startDate = (String)customParams.get(SKSSQQ);
        String endDate = (String)customParams.get(SKSSQZ);
        List orgList = (List)customParams.get("orgList");
        orgid = orgList != null && orgList.size() > 0 ? orgList.get(0).toString() : orgid;
        Boolean sbbDeclareStatus = "sjjt".equals(draftpurpose) ? Boolean.TRUE : this.sbbDeclareStatusEnable(orgid, startDate, endDate);
        Boolean billStatus = this.draftStatusEnable(orgid, startDate, endDate, draftpurpose);
        boolean bl = ENABLE = sbbDeclareStatus != false && billStatus != false;
        if (!billStatus.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u5df2\u7ecf\u63d0\u4ea4\u6216\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u3002", (String)"DeductTZDetailFormPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if ("nssb".equals(draftpurpose) && !sbbDeclareStatus.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u3002", (String)"DeductTZDetailFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
    }

    private Boolean sbbDeclareStatusEnable(String orgid, String startDate, String endDate) {
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)(this.isDeclareByYear() != false ? TEMPLATETYPE : "qysdsjb"), (String)startDate, (String)endDate, null);
        if (dyo != null) {
            return "A".equals(dyo.getString("billstatus"));
        }
        return Boolean.TRUE;
    }

    private Boolean draftStatusEnable(String orgId, String startdate, String enddate, String draftpurpose) {
        String templatetype = this.isDeclareByYear() != false ? "draft_qysdsnb" : "draft_qysdsjb";
        DynamicObject object = StatusUtils.queryOne((String)templatetype, (String)orgId, (String)startdate, (String)enddate, (String)draftpurpose);
        if (object != null) {
            return "A".equals(object.getString("billstatus"));
        }
        return Boolean.TRUE;
    }

    private Boolean isDeclareByYear() {
        Optional<FormShowParameter> optional = Optional.ofNullable(this.getView().getParentView()).map(s -> s.getParentView()).map(s -> s.getFormShowParameter());
        if (optional.isPresent()) {
            return "tccit_mainpage".equals(optional.get().getParentFormId());
        }
        return Boolean.TRUE;
    }

    private void showRightFlex() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String righttype = (String)customParams.get("righttype");
        this.getView().setVisible(Boolean.FALSE, new String[]{WSJTS, QSMS});
        if (righttype != null) {
            switch (righttype) {
                case "1": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{WSJTS});
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_LIST, QSMS});
                    break;
                }
                case "2": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{QSMS});
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_LIST, WSJTS});
                    this.getModel().setValue("qsy", customParams.get("qsy"));
                    this.getModel().setValue("sjlx", customParams.get("sjlx"));
                    this.getModel().setValue("jslj", customParams.get("jslj"));
                }
            }
        }
        this.getView().updateView("flexpanelap4");
    }

    private DynamicObject[] getAdjustData(Map<String, Object> customParams, String entryname, String selectPrope) {
        QFilter[] filters = null;
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        String entrytype = (String)customParams.get("entrytype");
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        if ("0".equals(customParams.get("hbfnszt"))) {
            List independOrgList = (List)customParams.get("orgList");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)independOrgList);
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if ("2".equals(customParams.get("declaration"))) {
            List zjgFtzzList = (List)customParams.get("orgList");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)zjgFtzzList);
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
        } else if (this.ENTRYTYPE.contains(customParams.get("entrytype")) || this.YJ_YHXM.contains(customParams.get("entrytype")) || "yjother".equals(customParams.get("entrytype")) && "true".equals(customParams.get("isByRule"))) {
            String ruleid = (String)customParams.get(RULEID);
            QFilter ruleidFilter = new QFilter(RULEID, "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
            Object taxorg = customParams.get("taxorg");
            QFilter taxorgFilter = new QFilter("taxorg", "in", (Object)new long[]{Long.parseLong(taxorg.toString()), 0L});
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, ruleidFilter, taxorgFilter};
        } else if (Lists.newArrayList((Object[])new String[]{"xswsgcpsr", "xswsgcpzwgcpqrxssr", "xswwgcpyjmle", "zhdxswwgcpyjmle", "xswsgcpsr_mll", "xswsgcpzwgcpqrxssr_mll"}).contains(customParams.get("entrytype"))) {
            String ruleid = (String)customParams.get(RULEID);
            QFilter ruleidFilter = new QFilter(RULEID, "in", (Object)new long[]{Long.parseLong(ruleid), 0L});
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, ruleidFilter};
        } else {
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        }
        return BusinessDataServiceHelper.load((String)entryname, (String)selectPrope, (QFilter[])filters);
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams, String entryname) {
        QFilter[] filters;
        String selectProperties = "taxorg,taxaccountserialno,skssqq,table,amountfield,datadirection,amount,fetchamount,filtercondition,ruleid,entrytype";
        String entrytype = (String)customParams.get("entrytype");
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        List orgList = (List)customParams.get("orgList");
        orgFilter = orgList == null ? orgFilter : new QFilter("org", "in", (Object)orgList);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String ruleid = (String)customParams.get(RULEID);
        String taxorg = (String)customParams.get("taxorg");
        QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)(StringUtils.isNotBlank((CharSequence)taxorg) ? Long.parseLong(taxorg) : 0L));
        if (this.BY_RULES.contains(entryname) && !"30102".equals(itemnumber) && !"30104".equals(itemnumber) && !"8010502".equals(itemnumber)) {
            QFilter ruleidFilter = new QFilter(RULEID, "=", (Object)Long.valueOf(!"null".equals(ruleid) && StringUtil.isNotEmpty((CharSequence)ruleid) ? ruleid : "0"));
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, ruleidFilter};
            if (this.ENTRYTYPE.contains(entrytype) || this.YJ_YHXM.contains(entrytype) || "yjother".equals(customParams.get("entrytype")) && "true".equals(customParams.get("isByRule"))) {
                filters = new QFilter[]{taxorgFilter, startFilter, endFilter, entrytypeFilter, ruleidFilter};
            }
        } else {
            if ("tccit_dg_a100000_1_det".equals(entryname) && "002".equals(itemnumber)) {
                itemnumberFilter = new QFilter(ITEMNUMBER, "in", (Object)Lists.newArrayList((Object[])new String[]{"110", "110_"}));
            }
            filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        }
        boolean isYjOrNb = this.isYjOrNb(entryname);
        if (isYjOrNb) {
            selectProperties = selectProperties + ",conditionjson,advancedconfjson,itemnumber";
        }
        return BusinessDataServiceHelper.load((String)entryname, (String)selectProperties, (QFilter[])filters);
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal totalamount = entryentitycard.stream().map(s -> s.getBigDecimal("amount").add(s.getBigDecimal("adjustamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount;
    }

    private void appendCard(Map<String, Object> customParams, String entrytype, String itemnumber, DynamicObject[] adjustDetails, DynamicObject[] genericObjects, String entryname) {
        if ("1".equals(customParams.get("noadjusttype"))) {
            this.getModel().setValue(TOTAL_RESULT_KEY, this.calcAdjustsumamount());
            return;
        }
        String titleName = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"DeductTZDetailFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getString("titlename").equals(titleName) && s.getString("entrytype").equals(entrytype)).findFirst();
        DynamicObject dynamicObject = optional.isPresent() ? optional.get() : null;
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        String ruleid = (String)customParams.getOrDefault(RULEID, "0");
        Boolean isExists110Rules = (Boolean)customParams.getOrDefault("isExists110Rules", Boolean.FALSE);
        Boolean existsRules = (Boolean)customParams.getOrDefault("existsRules", Boolean.TRUE);
        try {
            this.getModel().setValue(RULEID, (Object)Long.parseLong(ruleid), rowIndex);
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            this.getModel().setValue(RULEID, (Object)0L, rowIndex);
        }
        this.getModel().setValue("entrytype", (Object)entrytype, rowIndex);
        this.getModel().setValue("titlename", (Object)titleName, rowIndex);
        this.getModel().setValue(ITEMNUMBER, (Object)(itemnumber + "_"), rowIndex);
        this.getModel().setValue("amount", (Object)0, rowIndex);
        this.getModel().setValue("cardadjustexplain", (Object)(dynamicObject != null ? dynamicObject.getString("adjustexplain") : ""), rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        if (this.YJ_YHXM.contains(entrytype) || "yjother".equals(customParams.get("entrytype")) && "true".equals(customParams.get("isByRule"))) {
            this.getModel().setValue("taxorg", customParams.get("taxorg"), rowIndex);
        }
        if (this.isNoRullItem(entrytype, itemnumber, entryname, isExists110Rules, existsRules)) {
            BigDecimal originalTotalAmount = this.getOriginalTotalAmount(itemnumber);
            this.getModel().setValue("amount", (Object)originalTotalAmount, rowIndex);
            this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount").add(originalTotalAmount) : BigDecimal.ZERO), rowIndex);
            this.getModel().setValue("sumamount", (Object)originalTotalAmount);
            this.getModel().setValue(TOTAL_RESULT_KEY, dynamicObject == null ? originalTotalAmount : this.calcAdjustsumamount());
        } else if ("xswsgcpsr_mll".equals(entrytype) || "xswsgcpzwgcpqrxssr_mll".equals(entrytype)) {
            Optional<DynamicObject> objectOptional;
            if (adjustDetails.length > 0 && (objectOptional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)ruleid, (CharSequence)s.getString(RULEID)) && s.getString("entrytype").equals(entrytype)).findFirst()).isPresent()) {
                DynamicObject adjustDetail = objectOptional.get();
                this.getModel().setValue("adjustamount", (Object)adjustDetail.getBigDecimal("adjustamount"), rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustDetail.getBigDecimal("totalamount"), rowIndex);
                this.getModel().setValue(TOTAL_RESULT_KEY, (Object)adjustDetail.getBigDecimal("totalamount"));
            }
        } else {
            this.getModel().setValue("sumamount", (Object)this.calcSumAmount(genericObjects));
            this.getModel().setValue(TOTAL_RESULT_KEY, this.calcAdjustsumamount());
        }
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
    }

    private boolean isNoRullItem(String entrytype, String itemnumber, String entryname, Boolean isExists110Rules, Boolean existsRules) {
        if ("002".equals(itemnumber) && "tccit_dg_a100000_1_det".equals(entryname)) {
            return isExists110Rules == false;
        }
        return this.NORULELIST.contains(entrytype) || this.NORULENUMBER.contains(itemnumber) && !"tccit_yj_profits_accdet".equals(entryname) && !"tccit_yj_profits_acc_sjjt".equals(entryname) || existsRules == false;
    }

    private BigDecimal getTotalamount(DynamicObject taxorg, DynamicObject rule, String entrytype, DynamicObject[] adjustDetails, List<DynamicObject> genericObjects) {
        BigDecimal adjustamount = this.getAdjustamount(taxorg, rule.getLong("id"), entrytype, adjustDetails);
        BigDecimal amount = this.getAmount(taxorg, rule, genericObjects);
        return this.isNoAdjustType() ? amount : amount.add(adjustamount);
    }

    private BigDecimal getAdjustamount(DynamicObject taxorg, Long ruleid, String entrytype, DynamicObject[] adjustDetails) {
        if (this.isNoAdjustType()) {
            return BigDecimal.ZERO;
        }
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("taxorg") == (taxorg != null ? taxorg.getLong("id") : 0L) && s.getLong(RULEID) == ruleid.longValue() && s.getString("entrytype").equals(entrytype)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private String getAdjustExplain(DynamicObject taxorg, Long ruleid, String entrytype, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("taxorg") == (taxorg != null ? taxorg.getLong("id") : 0L) && s.getLong(RULEID) == ruleid.longValue() && s.getString("entrytype").equals(entrytype)).findFirst();
        return optional.map(dynamicObject -> dynamicObject.getString("adjustexplain")).orElse(null);
    }

    private BigDecimal calcSumAmount(DynamicObject[] genericObjects) {
        if (genericObjects == null || genericObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = Arrays.stream(genericObjects).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getOriginalTotalAmount(String rowtype) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("originalamount_" + rowtype);
        if (customParam != null) {
            return new BigDecimal(customParam.toString());
        }
        customParam = formShowParameter.getCustomParam("originalamount");
        if (customParam != null) {
            return new BigDecimal(customParam.toString());
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(DynamicObject taxorg, DynamicObject rule, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> s.getDynamicObject(RULEID).getLong("id") == rule.getLong("id") && s.getLong("taxorg_id") == (taxorg != null ? taxorg.getLong("id") : 0L)).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean mustPositiveInteger;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        } else if (TOTAL_RESULT_KEY.equals(name) && (mustPositiveInteger = (Boolean)this.getView().getFormShowParameter().getCustomParam("mustPositiveInt")) != null && mustPositiveInteger.booleanValue()) {
            String notPositiveIntMsg = (String)this.getView().getFormShowParameter().getCustomParam("notPositiveIntMsg");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", "");
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
            }
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("amount").add(s.getBigDecimal("adjustamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue(TOTAL_RESULT_KEY, (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object orgid = customParams.get(ORGID);
            Object taxorg = customParams.get("taxorg");
            String entrytype = (String)customParams.get("entrytype");
            String columnType = (String)customParams.get("columnType");
            String ruleid = (String)customParams.get(RULEID);
            String draftpurpose = (String)customParams.get("draftpurpose");
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            Object entryname = customParams.get("entryname");
            Boolean sbbDeclareStatus = "sjjt".equals(draftpurpose) ? Boolean.TRUE : this.sbbDeclareStatusEnable((String)orgid, (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
            Boolean billStatus = this.draftStatusEnable((String)orgid, (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ), draftpurpose);
            if (!billStatus.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u5df2\u7ecf\u63d0\u4ea4\u6216\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u3002", (String)"DkynsdeTZDetailFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            if ("nssb".equals(draftpurpose) && !sbbDeclareStatus.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u3002", (String)"DkynsdeTZDetailFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                String itemnumber = ((DynamicObject)entryentitycard.get(0)).getString(ITEMNUMBER);
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue(TOTAL_RESULT_KEY);
                if (String.valueOf(adjustsumamount).replace("-", "").split("\\.")[0].length() > 13) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ed3\u679c\u503c\u4e3a\uff1a%s ,\u6574\u6570\u4f4d\u4e0d\u5141\u8bb8\u8d85\u8fc713\u4f4d\u8bf7\u91cd\u65b0\u8c03\u6574\uff01", (String)"DeductTZDetailFormPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), adjustsumamount));
                    return;
                }
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0 && this.CAN_NOT_NEGATIVE.contains(entryname) && !Arrays.asList("income", "asset").contains(entrytype)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5408\u8ba1\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"DeductTZDetailFormPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                if ("tccit_dg_a301010201_det".equals(entryname) && "peopleamount".equals(columnType) && adjustsumamount.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4eba\u6570\u5fc5\u987b\u4e3a\u6574\u6570", (String)"DeductTZDetailFormPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                if (("xswsgcpsr_mll".equals(entrytype) || "xswsgcpzwgcpqrxssr_mll".equals(entrytype)) && (BigDecimal.ZERO.compareTo(adjustsumamount) > 0 || BigDecimal.ONE.compareTo(adjustsumamount) < 0)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u503c\u8303\u56f4\u662f[0,1]", (String)"DeductTZDetailFormPlugin_10", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                if (!TzDialogValidHelper.validTzsmMustInput((AbstractFormPlugin)this, (String)ENTRYENTITY_CARD, (String)"cardadjustexplain", (String)"totalamount", (String)"amount")) {
                    return;
                }
                Object savecheck = customParams.get("savecheck");
                if ("true".equals(String.valueOf(savecheck)) && !this.beforeSaveCheck(customParams)) {
                    return;
                }
                this.addAdjustRecordAndWriteInfoDraft(entryentitycard);
                if ("0".equals(customParams.get("hbfnszt")) || "2".equals(customParams.get("declaration"))) {
                    this.deleteDetail(orgid, entrytype, skssqq, skssqz, itemnumber, customParams.get("declaration"), draftTypeObjectVo.getAdjustDetail().getNumber());
                } else {
                    this.deleteDetail(orgid, entrytype, skssqq, skssqz, itemnumber, ruleid, draftTypeObjectVo.getAdjustDetail().getNumber(), taxorg != null ? taxorg.toString() : "0");
                }
                for (DynamicObject dynamicObject : entryentitycard) {
                    DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)draftTypeObjectVo.getAdjustDetail().getNumber()));
                    object.set(RULEID, (Object)dynamicObject.getLong(RULEID));
                    object.set("entrytype", (Object)dynamicObject.getString("entrytype"));
                    object.set("titlename", (Object)dynamicObject.getString("titlename"));
                    object.set("itemname", (Object)dynamicObject.getString("itemname"));
                    object.set(ITEMNUMBER, (Object)dynamicObject.getString(ITEMNUMBER));
                    object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                    object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                    object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                    object.set("adjustexplain", (Object)dynamicObject.getString("cardadjustexplain"));
                    object.set("org", orgid);
                    object.set("taxorg", (Object)dynamicObject.getLong("taxorg_id"));
                    if ("2".equals(customParams.get("declaration")) && dynamicObject.getLong("taxorg_id") == 0L) {
                        object.set("taxorg", orgid);
                    }
                    if (this.ENTRYTYPE.contains(dynamicObject.getString("entrytype")) && dynamicObject.getLong("taxorg_id") == 0L) {
                        object.set("taxorg", taxorg);
                    }
                    object.set(SKSSQQ, (Object)skssqq);
                    object.set(SKSSQZ, (Object)skssqz);
                    datas.add(object);
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue(TOTAL_RESULT_KEY);
            String currentNodePluginName = this.getCurrentNodePluginSimpleName(this.getView());
            Map<String, IEngine> pluginMapper = builderYearEngineGraphService.getYearEnginePluginMapper();
            if (StringUtil.isNotBlank((CharSequence)currentNodePluginName) && pluginMapper.containsKey(currentNodePluginName)) {
                customParams.put(IS_CONFIRM_SAVE, "true");
                customParams.put("nodeName", currentNodePluginName);
                customParams.put(TOTAL_RESULT_KEY, adjustsumamount);
                customParams.put("parentPageId", this.getView().getParentView().getPageId());
                String taskName = ResManager.loadKDString((String)"\u6570\u636e\u8c03\u6574\u8ba1\u7b97\u6267\u884c\u8fdb\u5ea6", (String)"DeductTZDetailFormPlugin_14", (String)"taxc-tccit", (Object[])new Object[0]);
                String taskClassName = YearAdjustCalcTask.class.getName();
                String taskId = JobUtils.dispatch((IFormView)this.getView(), (Map)customParams, (String)taskName, (String)taskClassName);
                this.getPageCache().put("taskId", taskId);
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49......", (String)"DeductTZDetailFormPlugin_15", (String)"taxc-tccit", (Object[])new Object[0])), 5000);
                this.getView().addClientCallBack("saveCallBack", Integer.valueOf(1000));
            } else {
                Map parentCustomParams;
                if (EmptyCheckUtils.isNotEmpty(customParams.get(CLOSECALLBACK_KEY))) {
                    customParams.put(TOTAL_RESULT_KEY, adjustsumamount);
                    parentCustomParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
                    parentCustomParams.put(IS_CONFIRM_SAVE, "true");
                    parentCustomParams.put(CAN_CALC_DRAFT, ENABLE);
                    this.getView().returnDataToParent((Object)customParams);
                } else {
                    parentCustomParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
                    parentCustomParams.put("columnType", this.getView().getFormShowParameter().getCustomParams().get("columnType"));
                    parentCustomParams.put(RULEID, this.getView().getFormShowParameter().getCustomParams().get(RULEID));
                    parentCustomParams.put("taxorg", this.getView().getFormShowParameter().getCustomParams().get("taxorg"));
                    parentCustomParams.put(IS_CONFIRM_SAVE, "true");
                    parentCustomParams.put(CAN_CALC_DRAFT, ENABLE);
                    IFormView subView = this.getView().getParentView();
                    subView.invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().returnDataToParent((Object)"true");
                }
                this.getView().close();
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (StringUtil.equals((CharSequence)e.getName(), (CharSequence)"saveCallBack")) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getPageCache().get("taskId"));
            if (taskInfo != null && taskInfo.isTaskEnd()) {
                String data = taskInfo.getData();
                Map customParams = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String pageid = (String)customParams.get("parentPageId");
                IFormView childView = this.getView().getView(pageid);
                Map customParams1 = childView.getFormShowParameter().getCustomParams();
                customParams1.putAll(customParams);
                childView.invokeOperation("refresh");
                this.getView().sendFormAction(childView);
                this.getView().hideLoading(true);
                this.getView().close();
            } else {
                this.getView().addClientCallBack("saveCallBack", Integer.valueOf(500));
            }
        }
    }

    private boolean beforeSaveCheck(Map<String, Object> customParams) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        String errorMeg = ResManager.loadKDString((String)"\u672c\u884c\u7b2c2\u5217\u548c\u672c\u884c\u7b2c3\u5217\u7684\u5408\u8ba1\u503c\u4e0d\u5f97\u5927\u4e8e\u672c\u884c\u7b2c1\u5217\u7684\u503c\u3002", (String)"DeductTZDetailFormPlugin_12", (String)"taxc-tccit", (Object[])new Object[0]);
        String itemnumber = String.valueOf(customParams.get(ITEMNUMBER));
        BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue(TOTAL_RESULT_KEY);
        if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5408\u8ba1\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570\u3002", (String)"DeductTZDetailFormPlugin_13", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        String row7 = (String)parentModel.getValue("hjjecurrent", 7);
        if (itemnumber.equals("7&wsscurrent")) {
            String zzqcurrentStr = (String)parentModel.getValue("zzqcurrent", 7);
            BigDecimal zzqcurrent = new BigDecimal(zzqcurrentStr.replace(",", ""));
            BigDecimal hjjecurrent = new BigDecimal(row7.replace(",", "").replace("<nolink>", ""));
            if (zzqcurrent.add(adjustsumamount).compareTo(hjjecurrent) > 0) {
                this.getView().showErrorNotification(errorMeg);
                return false;
            }
        } else if (itemnumber.equals("7&zzqcurrent")) {
            String wsscurrentStr = (String)parentModel.getValue("wsscurrent", 7);
            BigDecimal wsscurrent = new BigDecimal(wsscurrentStr.replace(",", ""));
            BigDecimal hjjecurrent = new BigDecimal(row7.replace(",", "").replace("<nolink>", ""));
            if (wsscurrent.add(adjustsumamount).compareTo(hjjecurrent) > 0) {
                this.getView().showErrorNotification(errorMeg);
                return false;
            }
        } else {
            String row15 = (String)parentModel.getValue("hjjecurrent", 16);
            if (itemnumber.equals("15&wsscurrent")) {
                String zzqcurrentStr = (String)parentModel.getValue("zzqcurrent", 16);
                BigDecimal zzqcurrent = new BigDecimal(zzqcurrentStr.replace(",", ""));
                BigDecimal hjjecurrent = new BigDecimal(row15.replace(",", "").replace("<nolink>", ""));
                if (zzqcurrent.add(adjustsumamount).compareTo(hjjecurrent) > 0) {
                    this.getView().showErrorNotification(errorMeg);
                    return false;
                }
            } else if (itemnumber.equals("15&zzqcurrent")) {
                String wsscurrentStr = (String)parentModel.getValue("wsscurrent", 16);
                BigDecimal wsscurrent = new BigDecimal(wsscurrentStr.replace(",", ""));
                BigDecimal hjjecurrent = new BigDecimal(row15.replace(",", "").replace("<nolink>", ""));
                if (wsscurrent.add(adjustsumamount).compareTo(hjjecurrent) > 0) {
                    this.getView().showErrorNotification(errorMeg);
                    return false;
                }
            }
        }
        return true;
    }

    private void addAdjustRecordAndWriteInfoDraft(DynamicObjectCollection entryentitycard) {
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"DeductTZDetailFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Object orgid = customParams.get(ORGID);
        Object taxorg = customParams.get("taxorg");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,titlename";
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, draftTypeObjectVo.getAdjustDetail().getNumber(), selectPrope);
        Map<String, BigDecimal> adjustDetailMap = Arrays.asList(adjustDetails).stream().collect(Collectors.toMap(a -> this.getRuleCardKey((DynamicObject)a).concat(a.getString("taxorg")), a -> a.getBigDecimal("adjustamount"), (k, v) -> k));
        for (DynamicObject d : entryentitycard) {
            BigDecimal currentAdjustAmount;
            String key = this.getRuleCardKey(d);
            key = d.getDynamicObject("taxorg") != null ? key.concat(d.getDynamicObject("taxorg").getString("id")) : key.concat("0");
            BigDecimal preAdjustAmount = adjustDetailMap.get(key);
            if ((preAdjustAmount = preAdjustAmount == null ? BigDecimal.ZERO : preAdjustAmount).compareTo(currentAdjustAmount = d.getBigDecimal("adjustamount")) == 0) continue;
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getAdjustRecord().getNumber());
            adjustObj.set("adjusttype", (Object)(manualAdjust.equals(d.getString("titlename")) ? 2 : 1));
            adjustObj.set(RULEID, (Object)d.getLong(RULEID));
            adjustObj.set("entrytype", (Object)d.getString("entrytype"));
            adjustObj.set("titlename", (Object)d.getString("titlename"));
            adjustObj.set("itemname", (Object)d.getString("itemname"));
            adjustObj.set(ITEMNUMBER, (Object)d.getString(ITEMNUMBER));
            adjustObj.set("preadjust", (Object)preAdjustAmount);
            adjustObj.set("postadjust", (Object)currentAdjustAmount);
            adjustObj.set("adjustexplain", d.get("cardadjustexplain"));
            adjustObj.set("org", orgid);
            adjustObj.set("taxorg", (Object)d.getLong("taxorg_id"));
            if ("2".equals(customParams.get("declaration")) && d.getLong("taxorg_id") == 0L) {
                adjustObj.set("taxorg", orgid);
            }
            if (this.ENTRYTYPE.contains(d.getString("entrytype")) && d.getLong("taxorg_id") == 0L) {
                adjustObj.set("taxorg", taxorg);
            }
            adjustObj.set(SKSSQQ, (Object)skssqq);
            adjustObj.set(SKSSQZ, (Object)skssqz);
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            saveList.add(adjustObj);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty(saveList)) {
            String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
            QFilter dateFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
            if ("sjjt".equals(draftpurpose)) {
                dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
            QFilter taxFilter = new QFilter("templatetype", "in", Arrays.asList("draft_qysdsjb", "draft_qysdsnb"));
            QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
            String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
            DynamicObject draftMain = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,ismodified", (QFilter[])new QFilter[]{orgFilter, dateFilter, taxFilter, draftPurposeFilter});
            if (draftMain == null) {
                return;
            }
            draftMain.set("ismodified", (Object)1);
            SaveServiceHelper.update((DynamicObject)draftMain);
        }
    }

    private String getRuleCardKey(DynamicObject d) {
        return String.join((CharSequence)"", d.getString(RULEID), d.getString("entrytype"), d.getString("titlename"));
    }

    private void deleteDetail(Object orgid, String entrytype, Object skssqq, Object skssqz, String itemnumber, Object declaration, String entityName) {
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        List orgList = (List)this.getView().getFormShowParameter().getCustomParams().get("orgList");
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgid.toString()))).and(new QFilter("taxorg", "in", (Object)orgList)).and(new QFilter("entrytype", "=", (Object)entrytype)).and(itemnumberFilter)});
    }

    private void deleteDetail(Object orgid, String entrytype, Object skssqq, Object skssqz, String itemnumber, String ruleid, String entityName, String taxorgid) {
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        if ("xswsgcpsr_mll".equals(entrytype) || "xswsgcpzwgcpqrxssr_mll".equals(entrytype)) {
            QFilter ruleidFilter = new QFilter(RULEID, "=", (Object)Long.parseLong(ruleid));
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgid.toString()))).and(new QFilter("entrytype", "=", (Object)entrytype)).and(itemnumberFilter).and(ruleidFilter)});
        } else if (this.ENTRYTYPE.contains(entrytype) || this.YJ_YHXM.contains(entrytype)) {
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgid.toString()))).and(new QFilter("entrytype", "=", (Object)entrytype)).and(itemnumberFilter).and(new QFilter("taxorg", "=", (Object)Long.valueOf(taxorgid)))});
        } else {
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgid.toString()))).and(new QFilter("entrytype", "=", (Object)entrytype)).and(itemnumberFilter)});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        int row = evt.getRow();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (entryentitycard.size() - 1 == row) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue(RULEID);
        Long taxorgid = (Long)cardEntry.getModel().getValue("taxorg_id");
        String entrytype = (String)cardEntry.getModel().getValue("entrytype");
        if (ruleid != null && entrytype != null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entryname = (String)customParams.get("entryname");
            this.setEntryentitylist(taxorgid, ruleid, entrytype, entryname);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(Long taxorgid, Long ruleid, String entrytype, String entryname) {
        QFilter ruleFilter = new QFilter(RULEID, "=", (Object)ruleid);
        QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)entrytype);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)taxorgid);
        List orgList = customParams.containsKey(RuleTypeEnum.STANDBOOK.getName()) ? null : (List)customParams.get("orgList");
        orgFilter = orgList == null ? orgFilter : new QFilter("org", "in", (Object)orgList);
        taxorgFilter = orgList == null ? taxorgFilter : new QFilter("taxorg", "in", (Object)orgList);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String selectProperties = "taxaccountserialno,skssqq,absolute,bizname,table,amountfield,datadirection,fetchamount,amount,filtercondition,ruleid,entrytype";
        boolean isYjOrNb = this.isYjOrNb(entryname);
        if (isYjOrNb) {
            selectProperties = selectProperties + ",conditionjson,advancedconfjson,itemnumber";
        }
        if (MetadataUtil.findProp((String)entryname, (String)"exrate") != null) {
            selectProperties = selectProperties + ",exrate";
        }
        QFilter[] filters = new QFilter[]{orgFilter, taxorgFilter, startFilter, endFilter, ruleFilter, entrytypeFilter};
        if (customParams.containsKey(RuleTypeEnum.STANDBOOK.getName())) {
            filters = new QFilter[]{taxorgFilter, startFilter, endFilter, ruleFilter, entrytypeFilter};
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entryname, (String)selectProperties, (QFilter[])filters);
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue(SKSSQQ, (Object)object.getDate(SKSSQQ), rowIndex);
            this.getModel().setValue("bizname", (Object)object.getString("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("fetchamount1", object.get("fetchamount"), rowIndex);
            if (object.containsProperty("exrate")) {
                this.getModel().setValue("exrate", object.get("exrate"), rowIndex);
            }
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
            if (isYjOrNb) {
                this.getModel().setValue("conditionjson", object.get("conditionjson"), rowIndex);
                this.getModel().setValue("advancedconfjson", object.get("advancedconfjson"), rowIndex);
                this.getModel().setValue("detailitemnumber", object.get(ITEMNUMBER), rowIndex);
            }
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("filtercondition");
            String tagPropName = largeTextEdit.getTagFieldKey();
            String largeText = (String)object.get("filtercondition");
            if (StringUtil.isEmpty((CharSequence)largeText)) {
                largeText = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\uff01", (String)"DeductTZDetailFormPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]);
            }
            this.getModel().setValue(tagPropName, (Object)largeText, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY_CARD);
        if (rowCount > 0) {
            entryentitycard.selectCard(Integer.valueOf(0));
            entryentitycard.entryRowClick(Integer.valueOf(0));
        }
    }

    private String getCurrentNodePluginSimpleName(IFormView view) {
        String currentNodePluginName = this.getCurrentNodePluginName(view);
        return StringUtil.isNotEmpty((CharSequence)currentNodePluginName) ? currentNodePluginName.substring(currentNodePluginName.lastIndexOf(46) + 1) : null;
    }

    private String getCurrentNodePluginName(IFormView view) {
        String pluginName = Optional.ofNullable(view.getParentView()).map(s -> s.getFormShowParameter().getFormId()).filter(Objects::nonNull).map(f -> FormMetadataCache.getFormConfig((String)f)).filter(s -> s.getPlugins().size() > 0).map(s -> {
            String className = ((Plugin)s.getPlugins().get(0)).getClassName();
            return className;
        }).orElseGet(() -> null);
        return pluginName;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("fetchamount1".equals(evt.getFieldName())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            long orgid = Long.parseLong(String.valueOf(customParams.get(ORGID)));
            long taxorgid = this.getTaxorgId();
            Date skssqq = DateUtils.stringToDate2((String)String.valueOf(customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate2((String)String.valueOf(customParams.get(SKSSQZ)));
            int rowIndex = evt.getRowIndex();
            DynamicObject table = (DynamicObject)this.getModel().getValue("table", rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", rowIndex);
            String conditionJson = (String)this.getModel().getValue("conditionjson", rowIndex);
            String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", rowIndex);
            String entryname = String.valueOf(customParams.get("entryname"));
            String itemnumber = (String)this.getModel().getValue("detailitemnumber", rowIndex);
            boolean viewDetails = this.isYjOrNb(entryname);
            DataDetailsOpenUtils.openDataDetailsPage((boolean)viewDetails, (Long)BaseTaxCategory.QYSDS, (Long)orgid, (Long)taxorgid, (Date)skssqq, (Date)skssqz, (Long)table.getLong("id"), (String)amountfield.getString("fieldname"), (String)conditionJson, (String)advancedconfjson, (String)itemnumber, (IFormView)this.getView());
        }
    }

    private long getTaxorgId() {
        long taxorgid = 0L;
        EntryGrid card = (EntryGrid)this.getControl(ENTRYENTITY_CARD);
        if (card.getSelectRows().length > 0) {
            int rowIndex = card.getSelectRows()[0];
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg", rowIndex);
            if (taxorg != null) {
                taxorgid = taxorg.getLong("id");
            }
        }
        return taxorgid;
    }

    private boolean isYjOrNb(String entryname) {
        if (EmptyCheckUtils.isEmpty((Object)entryname)) {
            return false;
        }
        for (NssbDraftTypeEnum nssbDraftTypeEnum : NssbDraftTypeEnum.values()) {
            if (!nssbDraftTypeEnum.getDetail().equals(entryname)) continue;
            return true;
        }
        for (Enum enum_ : SjjtDraftTypeEnum.values()) {
            if (!((SjjtDraftTypeEnum)enum_).getDetail().equals(entryname)) continue;
            return true;
        }
        return YearAccEngine.getEntityItemMapping().containsKey(entryname);
    }
}

