/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.SalaryTZFormPlugin;

public class DeductTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "zzje", "sjje", "002", "salary", "rate", "limitamount", "003", "taxamount", "nstzje"});
    public final Set<String> titles = Sets.newHashSet((Object[])new String[]{"001", "002", "003"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String GONG_HUI = "gonghui";
    public static final String ZHI_GONG = "zhigong";
    public static final String YANG_LAO = "yanglao";
    public static final String YI_LIAO = "yiliao";
    public static final String DANG_FEI = "dangfei";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private Map<String, String> maps = new HashMap<String, String>(){
        {
            this.put(DeductTZFormPlugin.GONG_HUI, "GHJF");
            this.put(DeductTZFormPlugin.ZHI_GONG, "ZGFLF");
            this.put(DeductTZFormPlugin.YANG_LAO, "BCYLYL");
            this.put(DeductTZFormPlugin.YI_LIAO, "BCYLYL");
            this.put(DeductTZFormPlugin.DANG_FEI, "DGZJF");
        }
    };
    private Map<String, String> projects = new HashMap<String, String>(){
        {
            this.put(DeductTZFormPlugin.GONG_HUI, "3010104");
            this.put(DeductTZFormPlugin.ZHI_GONG, "3010105");
            this.put(DeductTZFormPlugin.YANG_LAO, "3010108");
            this.put(DeductTZFormPlugin.YI_LIAO, "3010109");
            this.put(DeductTZFormPlugin.DANG_FEI, "30108");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,zzje,sjje,salary,rate,limitamount,taxamount,nstzje";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_deduct_summary", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        HashMap<String, BigDecimal> toMap = new HashMap<String, BigDecimal>();
        for (DynamicObject object : query) {
            toMap.put(this.getKey("zzje", object.getString(ITEM_TYPE)), object.getBigDecimal("zzje"));
            toMap.put(this.getKey("sjje", object.getString(ITEM_TYPE)), object.getBigDecimal("sjje"));
            toMap.put(this.getKey("salary", object.getString(ITEM_TYPE)), object.getBigDecimal("salary"));
            toMap.put(this.getKey("rate", object.getString(ITEM_TYPE)), object.getBigDecimal("rate").setScale(0));
            toMap.put(this.getKey("limitamount", object.getString(ITEM_TYPE)), object.getBigDecimal("limitamount"));
            toMap.put(this.getKey("taxamount", object.getString(ITEM_TYPE)), object.getBigDecimal("taxamount"));
            toMap.put(this.getKey("nstzje", object.getString(ITEM_TYPE)), object.getBigDecimal("nstzje"));
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", this.itemTypes.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (String itemType : this.itemTypes) {
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(rowIndex + 1));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(GONG_HUI).setValueFast((Object)data, (Object)this.getFormatData(itemType, (BigDecimal)toMap.get(this.getKey(itemType, GONG_HUI))));
            dot.getProperty(ZHI_GONG).setValueFast((Object)data, (Object)this.getFormatData(itemType, (BigDecimal)toMap.get(this.getKey(itemType, ZHI_GONG))));
            dot.getProperty(YANG_LAO).setValueFast((Object)data, (Object)this.getFormatData(itemType, (BigDecimal)toMap.get(this.getKey(itemType, YANG_LAO))));
            dot.getProperty(YI_LIAO).setValueFast((Object)data, (Object)this.getFormatData(itemType, (BigDecimal)toMap.get(this.getKey(itemType, YI_LIAO))));
            dot.getProperty(DANG_FEI).setValueFast((Object)data, (Object)this.getFormatData(itemType, (BigDecimal)toMap.get(this.getKey(itemType, DANG_FEI))));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String getFormatData(String columnType, BigDecimal data) {
        if (data == null) {
            return "";
        }
        StringBuilder link = new StringBuilder("<nolink>");
        if ("rate".equals(columnType)) {
            return link.append(DataFormat.formatRate(data.setScale(0).toString())).toString();
        }
        String text = data.setScale(2, 4).toString();
        if (!columnType.equals("zzje") && !columnType.equals("sjje")) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct10")) {
            return;
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        for (String itemType : this.itemTypes) {
            result.put(this.getKey(itemType, GONG_HUI), this.calcAmount(itemType, GONG_HUI, customParams));
            result.put(this.getKey(itemType, ZHI_GONG), this.calcAmount(itemType, ZHI_GONG, customParams));
            result.put(this.getKey(itemType, YANG_LAO), this.calcAmount(itemType, YANG_LAO, customParams));
            result.put(this.getKey(itemType, YI_LIAO), this.calcAmount(itemType, YI_LIAO, customParams));
            result.put(this.getKey(itemType, DANG_FEI), this.calcAmount(itemType, DANG_FEI, customParams));
        }
        this.saveCurrentPeriod(result, orgid, skssqq, skssqz);
    }

    private void saveCurrentPeriod(Map<String, BigDecimal> result, Long orgid, Date skssqq, Date skssqz) {
        DynamicObjectCollection sum = new DynamicObjectCollection();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{GONG_HUI, ZHI_GONG, YANG_LAO, YI_LIAO, DANG_FEI});
        int itemNo = 0;
        for (String column : columns) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_deduct_summary");
            dynamicObject.set("zzje", (Object)result.get(this.getKey("zzje", column)));
            dynamicObject.set("sjje", (Object)result.get(this.getKey("sjje", column)));
            dynamicObject.set("salary", (Object)result.get(this.getKey("salary", column)));
            dynamicObject.set("rate", (Object)result.get(this.getKey("rate", column)));
            dynamicObject.set("limitamount", (Object)result.get(this.getKey("limitamount", column)));
            dynamicObject.set("taxamount", (Object)result.get(this.getKey("taxamount", column)));
            dynamicObject.set("nstzje", (Object)result.get(this.getKey("nstzje", column)));
            dynamicObject.set(ITEM_TYPE, (Object)column);
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", (Object)Lists.newArrayList((Object[])new String[]{GONG_HUI, ZHI_GONG, YANG_LAO, YI_LIAO, DANG_FEI}));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_deduct_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        BigDecimal row3;
        BigDecimal row2;
        if (this.titles.contains(rowType)) {
            return BigDecimal.ZERO;
        }
        if ("zzje".equals(rowType) || "sjje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, rowType);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("salary".equals(rowType)) {
            Long orgid = Long.parseLong((String)customParams.get("orgid"));
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "in", (Object)Lists.newArrayList((Object[])new String[]{"salarystock"}));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_salary_summary", (String)"taxamount", (QFilter[])new QFilter[]{orgFilter, dateFilter, itemTypeFilter});
            BigDecimal pay = query == null ? BigDecimal.ZERO : query.stream().map(s -> s.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal salary = pay.setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), salary);
            return salary;
        }
        if ("rate".equals(rowType)) {
            BigDecimal rate = this.getRate(rowType, columnType, customParams);
            this.dataMap.put(this.getKey(rowType, columnType), rate.setScale(0));
            return rate;
        }
        if ("limitamount".equals(rowType)) {
            BigDecimal amount = this.dataMap.get(this.getKey("salary", columnType));
            BigDecimal rate = this.dataMap.get(this.getKey("rate", columnType));
            if (amount != null && rate != null) {
                BigDecimal deduct = amount.multiply(rate).divide(new BigDecimal("100")).setScale(2, 4);
                this.dataMap.put(this.getKey(rowType, columnType), deduct);
                return deduct;
            }
        }
        if ("taxamount".equals(rowType)) {
            row2 = this.dataMap.get(this.getKey("zzje", columnType));
            row3 = this.dataMap.get(this.getKey("sjje", columnType));
            BigDecimal row7 = this.dataMap.get(this.getKey("limitamount", columnType));
            ArrayList list = Lists.newArrayList((Object[])new BigDecimal[]{row2, row3, row7});
            BigDecimal decimal = list.stream().sorted().findFirst().orElse(BigDecimal.ZERO).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), decimal);
            return decimal;
        }
        if ("nstzje".equals(rowType)) {
            row2 = this.dataMap.get(this.getKey("zzje", columnType));
            row3 = this.dataMap.get(this.getKey("taxamount", columnType));
            BigDecimal tiaoz = row2.subtract(row3).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), tiaoz);
            return tiaoz;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = this.projects.get(columnType);
        return this.getCellAmount(customParams, columnType, entrytype, null, itemnumber, null, "tccit_deduct_tz_detail");
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    private BigDecimal getRate(String rowType, String columnType, Map<String, Object> customParams) {
        String orgId = String.valueOf(customParams.get("orgid"));
        String skssqq = String.valueOf(customParams.get("skssqq"));
        String skssqz = String.valueOf(customParams.get("skssqz"));
        List deductionRateList = AssistService.queryAssistParams((String)this.maps.get(columnType), (String)orgId, (String)skssqq, (String)skssqz);
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > 2) {
            return;
        }
        String entrytype = rowIndex == 1 ? "zzje" : "sjje";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", entrytype);
        customParams.put("itemnumber", this.projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_deduct_tz_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{GONG_HUI, ZHI_GONG, YANG_LAO, YI_LIAO, DANG_FEI});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entrytype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_deduct_tz_detail");
        customParams.put("entrytype", entrytype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", this.projects.get(column));
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(DeductTZFormPlugin.class.getSimpleName(), Collections.singletonList(SalaryTZFormPlugin.class.getSimpleName()));
            }
        };
    }
}

