/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleAmountFieldEnum;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.lang3.StringUtils;

public class DevJjkcTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer,
BeforeF7SelectListener {
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String AMOUNT = "amount";
    private static final String ORIGINAL_AMOUNT = "originalamount";
    private static final String DEDUCTIONTYPE = "deductiontype";
    private static final String JJKCBLJJSFF = "jjkcbljjsff";
    private static final String DEV_JJKC_SUM = "tccit_dev_jjkc_summary";
    private static final String DEVELOP_JJKC = "tccit_develop_jjkc";
    private static final String DEV_JJKC_DETAIL = "tccit_dev_jjkc_detail";
    private static final List<String> itemTypes = Arrays.asList("kxssl", "zzhzjz", "ryrgfy", "zjcsyfhdrygzxj", "zjcsyfhdrywxyj", "wpyfrydlwfy", "zjtrfy", "yfhdzjxhclfy", "yfhdzjxhrlfy", "yfhdzjxhdlfy", "mjgyzbkfzzf", "bgczcypyjybcssdgzf", "yyszcpdjyf", "yqsbwhtzjywxdfy", "zrdyfhdyqsbzlf", "zjfy", "dyqdzjf", "dsbdzjf", "wxzctxfy", "rjdtxfy", "zlqdtxfy", "fzljsdtxfy", "xcpsjfy", "xcpsjf", "xgygczdf", "xyyzdlcsyf", "ktkfjsdxcsyf", "qtxgfy", "zlffyfzxfbxf", "yfcgfy", "zscqsqzcdlf", "zgflbcylbcyl", "clfhyf", "xetzhqtxgfy", "wtyfhjje", "wtjnjghgryffsfy", "wtjwjgyffsdfy", "yxjjkcdjwjgyffy", "wtjwgryffsdfy", "ndyffyxj", "bnfyhje", "bnzbhje", "bnxcwxzctxe", "yqndxcwxzcbntxe", "yxkcdyffy", "xkcdtssr", "yxkcyffydjtssr", "dnxsyfzjxccpdclbf", "yqxsyfzjxccpdclbf", "bnyxjjkcdyfjf", "dsjdyxjjkcdyffyje", "qsjdyxjjkcdyffyje", "jjkcbl", "bndyffyjjkcze", "dsjdxgfyjjkc", "qsjdxgfyjjkc", "xsyfhdxccpyhndkj");
    private static final List<String> itemTypes2023 = Arrays.asList("kxssl", "zzhzjz", "ryrgfy", "zjcsyfhdrygzxj", "zjcsyfhdrywxyj", "wpyfrydlwfy", "zjtrfy", "yfhdzjxhclfy", "yfhdzjxhrlfy", "yfhdzjxhdlfy", "mjgyzbkfzzf", "bgczcypyjybcssdgzf", "yyszcpdjyf", "yqsbwhtzjywxdfy", "zrdyfhdyqsbzlf", "zjfy", "dyqdzjf", "dsbdzjf", "wxzctxfy", "rjdtxfy", "zlqdtxfy", "fzljsdtxfy", "xcpsjfy", "xcpsjf", "xgygczdf", "xyyzdlcsyf", "ktkfjsdxcsyf", "qtxgfy", "zlffyfzxfbxf", "yfcgfy", "zscqsqzcdlf", "zgflbcylbcyl", "clfhyf", "xetzhqtxgfy", "wtyfhjje", "wtjnjghgryffsfy", "wtjwjgyffsdfy", "yxjjkcdjwjgyffy", "wtjwgryffsdfy", "ndyffyxj", "bnfyhje", "bnzbhje", "bnxcwxzctxe", "yqndxcwxzcbntxe", "yxkcdyffy", "xkcdtssr", "yxkcyffydjtssr", "dnxsyfzjxccpdclbf", "yqxsyfzjxccpdclbf", "bnyxjjkcdyfjf", "jjkcbl", "bndyffyjjkcze", "xsyfhdxccpyhndkj");
    private static final Set<String> nolinkItem = Sets.newHashSet((Object[])new String[]{"zzhzjz", "wtyfhjje", "ndyffyxj", "yxkcdyffy", "yxkcyffydjtssr", "bnyxjjkcdyfjf", "jjkcbl", "xsyfhdxccpyhndkj"});
    private static final Set<String> exNolinkItem = Sets.newHashSet((Object[])new String[]{"dsjdyxjjkcdyffyje", "qsjdyxjjkcdyffyje", "bndyffyjjkcze", "dsjdxgfyjjkc", "qsjdxgfyjjkc"});
    private static final List<String> calcItem = Arrays.asList("ryrgfy", "zjtrfy", "zjfy", "wxzctxfy", "xcpsjfy", "qtxgfy", "zzhzjz", "wtyfhjje", "ndyffyxj", "yxkcdyffy", "yxkcyffydjtssr", "bnyxjjkcdyfjf", "bndyffyjjkcze", "xsyfhdxccpyhndkj");
    private static final List<Integer> enableItem = Arrays.asList(50, 51, 53, 54, 55);
    private static final List<String> LEVEL_2 = Arrays.asList("ryrgfy", "zjtrfy", "zjfy", "wxzctxfy", "xcpsjfy", "qtxgfy");
    protected static final String KXSSL = "kxssl";
    protected static final String YQXSYFZJXCCPDCLBF = "yqxsyfzjxccpdclbf";
    private Map<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(JJKCBLJJSFF);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initData();
        this.setEnable(customParams.get("billstatus"));
    }

    private void setEnable(Object billstatus) {
        if (!"A".equals(billstatus)) {
            for (Integer index : enableItem) {
                this.getView().setEnable(Boolean.valueOf(false), index.intValue(), new String[]{AMOUNT});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DEDUCTIONTYPE, JJKCBLJJSFF});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ChangeData[] changeSet;
        String name = e.getProperty().getName();
        if (AMOUNT.equals(name)) {
            changeSet = e.getChangeSet();
            newValue = changeSet[0].getNewValue();
            String type = (String)changeSet[0].getDataEntity().get(ITEM_TYPE);
            String value = ((String)newValue).replace(",", "");
            if (!value.matches("[-+]?\\d+(?:\\.\\d+)?")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u4ec5\u80fd\u5f55\u5165\u6570\u503c,\u975e\u6570\u503c\u5c06\u4e0d\u88ab\u4fdd\u5b58\uff01", (String)"DevJjkcTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            this.updateData(value, name, Collections.singletonList(type));
            String displayValue = DataFormat.formatMicrometer(value);
            this.getModel().setValue(AMOUNT, (Object)displayValue, changeSet[0].getRowIndex());
        }
        if (DEDUCTIONTYPE.equals(name)) {
            changeSet = e.getChangeSet();
            newValue = changeSet[0].getNewValue();
            this.updateData(newValue, name, itemTypes);
        }
        if (JJKCBLJJSFF.equals(name)) {
            changeSet = e.getChangeSet();
            newValue = changeSet[0].getNewValue();
            this.updateData(newValue, name, itemTypes);
        }
    }

    private void updateData(Object newValue, String name, List<String> itemTypes) {
        DynamicObject[] jjkcDatas;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        for (DynamicObject jjkcData : jjkcDatas = this.getJjkcSum(orgid, skssqq, skssqz, itemTypes)) {
            jjkcData.set(name, newValue);
        }
        SaveServiceHelper.update((DynamicObject[])jjkcDatas);
    }

    @Override
    public void afterBindData(EventObject e) {
        this.setEnableRow();
        super.afterBindData(e);
    }

    private void setEnableRow() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Object skssqqStr = this.getView().getFormShowParameter().getCustomParam("skssqq");
        Date skssqq = DateUtils.stringToDate((String)((String)skssqqStr));
        boolean isOut = skssqq.compareTo(DateUtils.stringToDate((String)"2022-12-31")) > 0;
        for (int i = 0; i < entryentity.size(); ++i) {
            if (isOut) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{AMOUNT});
                continue;
            }
            if (enableItem.contains(i)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{AMOUNT});
        }
    }

    private void initData() {
        Date skssqz;
        Date skssqq;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        DynamicObject[] query = this.getJjkcSum(orgid, skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq"))), skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))), itemTypes);
        if (query == null || query.length <= 0) {
            return;
        }
        String billstatus = (String)customParams.get("billstatus");
        IDataModel model = this.getModel();
        model.setValue(DEDUCTIONTYPE, (Object)query[0].getString(DEDUCTIONTYPE));
        model.setValue(JJKCBLJJSFF, (Object)(query[0].getDynamicObject(JJKCBLJJSFF) == null ? 0L : query[0].getDynamicObject(JJKCBLJJSFF).getLong("id")));
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.length);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (DynamicObject object : query) {
            String itemType = object.getString(ITEM_TYPE);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(rowIndex + 1));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)this.formatData(object.getBigDecimal(AMOUNT), itemType, billstatus));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private DynamicObject[] getJjkcSum(Long orgid, Date skssqq, Date skssqz, List<String> itemTypes) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "id,itemtype,amount,deductiontype,jjkcbljjsff,originalamount";
        return BusinessDataServiceHelper.load((String)DEV_JJKC_SUM, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
    }

    private String formatData(BigDecimal data, String rowtype, String billstatus) {
        boolean isOut;
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        if ("jjkcbl".equals(rowtype)) {
            return link.append(DataFormat.formatRate(data.setScale(0, 4).toString())).toString();
        }
        if (KXSSL.equals(rowtype)) {
            return DataFormat.formatMicrometer(data.setScale(0, 4).toString());
        }
        boolean bl = isOut = skssqq.compareTo(DateUtils.stringToDate((String)"2022-12-31")) > 0;
        if (nolinkItem.contains(rowtype)) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        if (isOut && "bndyffyjjkcze".equals(rowtype)) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        if (!"A".equals(billstatus) && exNolinkItem.contains(rowtype)) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        Map<String, List<DynamicObject>> hasRulesMap = this.hasRulesMap(orgid);
        DynamicObject jjkc = this.getDynamicObject(customParams);
        List<String> types = skssqq.compareTo(DateUtils.stringToDate((String)"2022-12-31")) > 0 ? itemTypes2023 : itemTypes;
        for (String itemType : types) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DEV_JJKC_SUM);
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            boolean hasRules = hasRulesMap.get(itemType) != null;
            BigDecimal amount = this.calcAmount(dynamicObject, itemType, customParams, hasRules);
            dynamicObject.set(AMOUNT, (Object)amount);
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            dynamicObject.set(DEDUCTIONTYPE, (Object)(jjkc != null ? jjkc.getString(DEDUCTIONTYPE) : ""));
            dynamicObject.set(JJKCBLJJSFF, jjkc != null ? jjkc.get(JJKCBLJJSFF) : Long.valueOf(0L));
            sum.add((Object)dynamicObject);
            this.dataMap.put(this.getKey(itemType), dynamicObject);
        }
        for (String item : calcItem) {
            if (LEVEL_2.contains(item)) {
                if (hasRulesMap.get(item) != null) continue;
                DynamicObject dyo = this.dataMap.get(this.getKey(item));
                CalcAmountEnum calcAmountEnum = CalcAmountEnum.byKey(item);
                if (calcAmountEnum == null || dyo == null) continue;
                BigDecimal sumItems = this.addAllItemAmount(calcAmountEnum.items);
                BigDecimal adjustAmount = this.queryAdjustAmount(orgid, skssqq, skssqz, item);
                dyo.set(AMOUNT, (Object)sumItems.add(adjustAmount));
                continue;
            }
            this.calcAmount(item);
        }
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private Map<String, List<DynamicObject>> hasRulesMap(Long orgid) {
        List<DynamicObject> ssyhRuleList = RuleService.getSharingAndOrgRules(orgid, RuleTypeEnum.SSYH, null).get((Object)RuleTypeEnum.SSYH);
        Map<String, List<DynamicObject>> collect = ssyhRuleList.stream().flatMap(s -> s.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.groupingBy(s -> s.getString("projecttype")));
        return collect;
    }

    private void calcAmount(String item) {
        DynamicObject dyo = this.dataMap.get(this.getKey(item));
        if (dyo == null) {
            return;
        }
        CalcAmountEnum calcAmountEnum = CalcAmountEnum.byKey(item);
        if (calcAmountEnum != null && dyo != null) {
            dyo.set(AMOUNT, (Object)this.addAllItemAmount(calcAmountEnum.items));
        }
        if ("ndyffyxj".equals(item)) {
            BigDecimal zzhzjz = this.dataMap.get(this.getKey("zzhzjz")) != null ? this.dataMap.get(this.getKey("zzhzjz")).getBigDecimal(AMOUNT) : BigDecimal.ZERO;
            BigDecimal wtjnjghgryffsfy = this.dataMap.get(this.getKey("wtjnjghgryffsfy")).getBigDecimal(AMOUNT);
            BigDecimal yxjjkcdjwjgyffy = this.dataMap.get(this.getKey("yxjjkcdjwjgyffy")).getBigDecimal(AMOUNT);
            BigDecimal amount = zzhzjz.add(wtjnjghgryffsfy.multiply(new BigDecimal("0.8"))).add(yxjjkcdjwjgyffy);
            dyo.set(AMOUNT, (Object)amount);
        } else if ("bnyxjjkcdyfjf".equals(item)) {
            BigDecimal yxkcyffydjtssr = this.dataMap.get(this.getKey("yxkcyffydjtssr")).getBigDecimal(AMOUNT);
            BigDecimal dnxsyfzjxccpdclbf = this.dataMap.get(this.getKey("dnxsyfzjxccpdclbf")).getBigDecimal(AMOUNT);
            BigDecimal yqxsyfzjxccpdclbf = this.dataMap.get(this.getKey(YQXSYFZJXCCPDCLBF)).getBigDecimal(AMOUNT);
            BigDecimal amount = yxkcyffydjtssr.subtract(dnxsyfzjxccpdclbf).subtract(yqxsyfzjxccpdclbf);
            dyo.set(AMOUNT, (Object)amount);
        } else if ("bndyffyjjkcze".equals(item)) {
            BigDecimal bnyxjjkcdyfjf = this.dataMap.get(this.getKey("bnyxjjkcdyfjf")).getBigDecimal(AMOUNT);
            BigDecimal jjkcbl = this.dataMap.get(this.getKey("jjkcbl")).getBigDecimal(AMOUNT);
            BigDecimal amount = bnyxjjkcdyfjf.multiply(jjkcbl).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
            dyo.set(AMOUNT, (Object)amount);
        } else if ("xsyfhdxccpyhndkj".equals(item)) {
            BigDecimal yxkcyffydjtssr = this.dataMap.get(this.getKey("yxkcyffydjtssr")).getBigDecimal(AMOUNT);
            BigDecimal dnxsyfzjxccpdclbf = this.dataMap.get(this.getKey("dnxsyfzjxccpdclbf")).getBigDecimal(AMOUNT);
            BigDecimal yqxsyfzjxccpdclbf = this.dataMap.get(this.getKey(YQXSYFZJXCCPDCLBF)).getBigDecimal(AMOUNT);
            BigDecimal subtract = yxkcyffydjtssr.subtract(dnxsyfzjxccpdclbf).subtract(yqxsyfzjxccpdclbf);
            BigDecimal amount = BigDecimal.ZERO;
            if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                amount = subtract.abs();
            }
            dyo.set(AMOUNT, (Object)amount);
        }
    }

    private BigDecimal addAllItemAmount(String ... items) {
        return Stream.of(items).map(item -> {
            BigDecimal amount;
            if (item.startsWith("-")) {
                String key = this.getKey(item.substring(1));
                amount = this.dataMap.get(key).getBigDecimal(AMOUNT).negate();
            } else {
                String key = this.getKey((String)item);
                amount = this.dataMap.get(key).getBigDecimal(AMOUNT);
            }
            return amount;
        }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)DEV_JJKC_SUM, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(DynamicObject dynamicObject, String rowType, Map<String, Object> customParams, boolean hasRules) {
        Set ruleField = RuleAmountFieldEnum.byEntry(DEVELOP_JJKC).stream().map(RuleAmountFieldEnum::getAmountFieldList).flatMap(Collection::stream).collect(Collectors.toSet());
        if (ruleField.contains(rowType)) {
            return this.getAmount(customParams, rowType, hasRules);
        }
        if (KXSSL.equals(rowType)) {
            DynamicObject jjkc = this.getDynamicObject(customParams);
            BigDecimal kxssl = jjkc != null ? jjkc.getBigDecimal(KXSSL) : BigDecimal.ZERO;
            dynamicObject.set(ORIGINAL_AMOUNT, (Object)kxssl);
            BigDecimal amount = this.getAmount(customParams, KXSSL, hasRules);
            return kxssl.add(amount);
        }
        if (YQXSYFZJXCCPDCLBF.equals(rowType)) {
            QFilter sbbidFilter;
            QFilter ewblxhFilter;
            DynamicObject dyo;
            BigDecimal yqndjzje = BigDecimal.ZERO;
            String lastYearSbbid = this.getLastYearSbbid(customParams);
            if (StringUtils.isNotBlank((CharSequence)lastYearSbbid) && (dyo = BusinessDataServiceHelper.loadSingle((String)"tccit_qysds_a107012_mx", (String)"yfhdfyje", (QFilter[])new QFilter[]{ewblxhFilter = new QFilter("ewblxh", "=", (Object)"52"), sbbidFilter = new QFilter("sbbid", "=", (Object)lastYearSbbid)})) != null) {
                yqndjzje = dyo.getBigDecimal("yfhdfyje");
                dynamicObject.set(ORIGINAL_AMOUNT, (Object)yqndjzje);
            }
            BigDecimal amount = this.getAmount(customParams, YQXSYFZJXCCPDCLBF, hasRules);
            return yqndjzje.add(amount);
        }
        if ("jjkcbl".equals(rowType)) {
            return this.getRate(customParams);
        }
        if ("dsjdyxjjkcdyffyje".equals(rowType) || "qsjdyxjjkcdyffyje".equals(rowType) || "dsjdxgfyjjkc".equals(rowType) || "qsjdxgfyjjkc".equals(rowType)) {
            return this.getSeasonAmount(customParams, rowType);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getSeasonAmount(Map<String, Object> customParams, String rowType) {
        DynamicObject jjkc = this.getDynamicObject(customParams);
        if (jjkc == null) {
            return BigDecimal.ZERO;
        }
        return jjkc.getBigDecimal(rowType);
    }

    private DynamicObject getDynamicObject(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date first = DateUtils.getFirstDateOfYear((Date)skssqq);
        Date last = DateUtils.getLastDateOfYear((Date)skssqq);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter yearFilter = new QFilter("year", ">=", (Object)first).and("year", "<=", (Object)last);
        QFilter declaretypeFilter = new QFilter("declaretype", "=", (Object)"2");
        return BusinessDataServiceHelper.loadSingle((String)DEVELOP_JJKC, (String)"kxssl,deductiontype,jjkcbl,jjkcbljjsff,dsjdyxjjkcdyffyje,qsjdyxjjkcdyffyje,dsjdxgfyjjkc,qsjdxgfyjjkc,bndyffyjjkcze", (QFilter[])new QFilter[]{orgFilter, yearFilter, declaretypeFilter});
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, boolean hasRules) {
        RuleAmountFieldEnum en = RuleAmountFieldEnum.byEntryAndAmountField(DEVELOP_JJKC, entrytype);
        String itemnumber = null;
        if (en != null) {
            itemnumber = LEVEL_2.contains(entrytype) ? (hasRules ? en.getItemNumber() : en.getSumItemType()) : en.getItemNumber();
        }
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, DEV_JJKC_DETAIL);
    }

    private String getKey(String rowType) {
        return rowType + "&" + AMOUNT;
    }

    private BigDecimal getRate(Map<String, Object> customParams) {
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date date = DateUtils.stringToDate((String)"2022-12-31");
        if (skssqq != null && skssqq.compareTo(date) > 0) {
            return BigDecimal.valueOf(100L);
        }
        DynamicObject jjkc = this.getDynamicObject(customParams);
        if (jjkc == null) {
            return BigDecimal.ZERO;
        }
        return jjkc.getBigDecimal("jjkcbl");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String actionId = event.getActionId();
        if (!TCCIT_DETAIL_TZ_DIALOG.equals(actionId) || this.canReCalc(customParams).booleanValue()) {
            // empty if block
        }
    }

    private BigDecimal queryAdjustAmount(Long orgid, Date skssqq, Date skssqz, String item) {
        QFilter q1 = new QFilter("org", "=", (Object)orgid);
        QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter q3 = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter q4 = new QFilter("itemnumber", "=", (Object)(item + "_"));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_adjust_detail", (String)"adjustamount", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object != null ? object.getBigDecimal("adjustamount") : BigDecimal.ZERO;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", itemtype);
        QFilter qFilter2 = new QFilter("orgid", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
        QFilter qFilter1 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
        QFilter qFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
        BigDecimal amt = BigDecimal.ZERO;
        if (KXSSL.equals(itemtype)) {
            customParams.put("entryname", DEV_JJKC_DETAIL);
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)itemtype);
            DynamicObject query = QueryServiceHelper.queryOne((String)DEV_JJKC_SUM, (String)ORIGINAL_AMOUNT, (QFilter[])new QFilter[]{itemtypeFilter, qFilter, qFilter1, qFilter2});
            if (query != null) {
                amt = query.getBigDecimal(ORIGINAL_AMOUNT);
            }
            customParams.put(ORIGINAL_AMOUNT, amt.setScale(2, RoundingMode.HALF_UP));
            customParams.put("mustPositiveInt", Boolean.TRUE);
            customParams.put("notPositiveIntMsg", ResManager.loadKDString((String)"\u9879\u76ee\u6570\u91cf\u5e94\u4e3a\u6b63\u6574\u6570\u3002", (String)"DevJjkcTZFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            this.showForm(customParams);
        } else if (YQXSYFZJXCCPDCLBF.equals(itemtype)) {
            customParams.put("entryname", DEV_JJKC_DETAIL);
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)itemtype);
            DynamicObject query = QueryServiceHelper.queryOne((String)DEV_JJKC_SUM, (String)ORIGINAL_AMOUNT, (QFilter[])new QFilter[]{itemtypeFilter, qFilter, qFilter1, qFilter2});
            if (query != null) {
                amt = query.getBigDecimal(ORIGINAL_AMOUNT);
            }
            customParams.put(ORIGINAL_AMOUNT, amt.setScale(2, RoundingMode.HALF_UP));
            this.showForm(customParams);
        } else if (LEVEL_2.contains(itemtype)) {
            Map<String, List<DynamicObject>> hasRulesMap = this.hasRulesMap(Long.parseLong((String)customParams.get("orgid")));
            boolean existsRules = hasRulesMap.get(itemtype) != null;
            RuleAmountFieldEnum en = RuleAmountFieldEnum.byEntryAndAmountField(DEVELOP_JJKC, itemtype);
            String itemnumber = LEVEL_2.contains(itemtype) && existsRules ? en.getItemNumber() : itemtype;
            customParams.put("itemnumber", itemnumber);
            customParams.put("entryname", DEV_JJKC_DETAIL);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            BigDecimal originalamount = this.getOriginalAdjustAmount(LEVEL_2, hasRulesMap, itemtype, entity);
            customParams.put("originalamount_" + itemtype, originalamount.setScale(2, 4));
            customParams.put("existsRules", existsRules);
            this.showForm(customParams);
        } else {
            RuleAmountFieldEnum en = RuleAmountFieldEnum.byEntryAndAmountField(DEVELOP_JJKC, itemtype);
            String itemnumber = en.getItemNumber();
            customParams.put("itemnumber", itemnumber);
            customParams.put("entryname", DEV_JJKC_DETAIL);
            this.showForm(customParams);
        }
    }

    private BigDecimal getOriginalAdjustAmount(List<String> level2, Map<String, List<DynamicObject>> hasRulesMap, String itemtype, DynamicObjectCollection entity) {
        RuleAmountFieldEnum ruleAmountFieldEnum;
        if (hasRulesMap.get(itemtype) == null && level2.contains(itemtype) && (ruleAmountFieldEnum = RuleAmountFieldEnum.byEntryAndAmountField(DEVELOP_JJKC, itemtype)) != null) {
            List<String> amountFieldList = ruleAmountFieldEnum.getAmountFieldList();
            return entity.stream().filter(s -> amountFieldList.contains(s.getString(ITEM_TYPE)) && !itemtype.equals(s.getString(ITEM_TYPE))).map(s -> {
                String amount = s.getString(AMOUNT);
                return new BigDecimal(StringUtil.isEmpty((CharSequence)(amount = amount.replaceAll("<nolink>", "").replaceAll(",", ""))) ? "0" : amount);
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private void showForm(Map<String, Object> customParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TCCIT_DETAIL_TZ_DIALOG);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TCCIT_DETAIL_TZ_DIALOG);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private String getLastYearSbbid(Map<String, Object> customParams) {
        String skssqz;
        String skssqq;
        String orgid = (String)customParams.get("orgid");
        DynamicObject sbb = YbnsrService.queryYbnsr((String)orgid, (String)"qysdsnb", (String)(skssqq = (String)customParams.get("skssqq")), (String)(skssqz = (String)customParams.get("skssqz")), (int)-12, null);
        if (sbb != null) {
            String declarestatus = sbb.getString("declarestatus");
            String billstatus = sbb.getString("billstatus");
            if (!"A".equals(billstatus) && "declared".equals(declarestatus)) {
                return sbb.getString("id");
            }
        }
        return null;
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (JJKCBLJJSFF.equals(name)) {
            Object skssqq = customParams.get("skssqq");
            Object skssqz = customParams.get("skssqz");
            if (Objects.isNull(skssqq) || Objects.isNull(skssqz)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8d77\u6b62\u6240\u5c5e\u7a0e\u671f", (String)"DevJjkcTZFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter listFilter = new QFilter("number", "in", (Object)new String[]{"110", "121", "122"});
            listFilter.and(new QFilter("bizdef.number", "=", (Object)"CIT-YFJJKC"));
            listFilter.and(new QFilter("validfrom", "<=", (Object)DateUtils.stringToDate((String)((String)skssqq))).and(new QFilter("expired", ">=", (Object)DateUtils.stringToDate((String)((String)skssqz))).or(new QFilter("expired", "is null", null))));
            listShowParameter.getListFilterParameter().setFilter(listFilter);
        }
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        RuleAmountFieldEnum en = RuleAmountFieldEnum.byEntryAndAmountField(DEVELOP_JJKC, itemtype);
        String itemnumber = en != null ? en.getItemNumber() : null;
        customParams.put("entryname", DEV_JJKC_DETAIL);
        customParams.put("entrytype", itemtype);
        customParams.put("columnType", column);
        if (LEVEL_2.contains(itemtype)) {
            Map<String, List<DynamicObject>> hasRulesMap = this.hasRulesMap(Long.parseLong((String)customParams.get("orgid")));
            if (hasRulesMap.get(itemtype) != null) {
                customParams.put("itemnumber", itemnumber);
            } else {
                customParams.put("itemnumber", itemtype + "_");
            }
        } else {
            customParams.put("itemnumber", itemnumber);
        }
        return customParams;
    }

    private static enum CalcAmountEnum {
        zzhzjz("zzhzjz", "ryrgfy", "zjtrfy", "zjfy", "wxzctxfy", "xcpsjfy", "xetzhqtxgfy"),
        ryrgfy("ryrgfy", "zjcsyfhdrygzxj", "zjcsyfhdrywxyj", "wpyfrydlwfy"),
        zjtrfy("zjtrfy", "yfhdzjxhclfy", "yfhdzjxhrlfy", "yfhdzjxhdlfy", "mjgyzbkfzzf", "bgczcypyjybcssdgzf", "yyszcpdjyf", "yqsbwhtzjywxdfy", "zrdyfhdyqsbzlf"),
        zjfy("zjfy", "dyqdzjf", "dsbdzjf"),
        wxzctxfy("wxzctxfy", "rjdtxfy", "zlqdtxfy", "fzljsdtxfy"),
        xcpsjfy("xcpsjfy", "xcpsjf", "xgygczdf", "xyyzdlcsyf", "ktkfjsdxcsyf"),
        qtxgfy("qtxgfy", "zlffyfzxfbxf", "yfcgfy", "zscqsqzcdlf", "zgflbcylbcyl", "clfhyf"),
        wtyfhjje("wtyfhjje", "wtjnjghgryffsfy", "wtjwjgyffsdfy", "wtjwgryffsdfy"),
        yxkcdyffy("yxkcdyffy", "bnfyhje", "bnxcwxzctxe", "yqndxcwxzcbntxe"),
        yxkcyffydjtssr("yxkcyffydjtssr", "yxkcdyffy", "-xkcdtssr");

        private String key;
        private String[] items;

        private CalcAmountEnum(String key, String ... items) {
            this.key = key;
            this.items = items;
        }

        static CalcAmountEnum byKey(String key) {
            return Stream.of(CalcAmountEnum.values()).filter(e -> e.key.equals(key)).findAny().orElse(null);
        }
    }
}

