/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class DksszbjTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String TCCIT_DKSSZBJ_SUM = "tccit_dksszbj_sum";
    private static final String TCCIT_SPEC_DKSSZBJ_DETAIL = "tccit_spec_dksszbj_detail";
    private static final String TCCIT_ADJUST_DETAIL = "tccit_adjust_detail";
    private static final String ENTRYENTITY = "entryentity";
    public static final String JRQY = "1";
    public static final String DKSSBBJ = "2";
    public static final String SNDKSSZBJ = "3";
    public static final String GZLDK = "4";
    public static final String CJLDK = "5";
    public static final String KYLDK = "6";
    public static final String SSLDK = "7";
    public static final String XGDKGS = "8";
    public static final String QT = "9";
    public static final String HJ = "10";
    public static final List<String> rows = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
    public static final String ITEM_NO = "itemno";
    public static final String ITEMTYPE = "itemtype";
    public static final String SNMDKYE = "snmdkye";
    public static final String BNMDKYE = "bnmdkye";
    public static final String SNMSSZBJYE = "snmsszbjye";
    public static final String BNMSSZBJYE = "bnmsszbjye";
    public static final String SNMDKZCYE = "snmdkzcye";
    public static final String BNMDKZCYE = "bnmdkzcye";
    public static final String JTBL = "jtbl";
    public static final String JSZBJE = "jszbje";
    public static final String DKSSZBJYE = "dksszbjye";
    public static final String DKSSZBJ = "dksszbj";
    public static final String NSTZJE = "nstzje";
    public static final ArrayList<String> columns = Lists.newArrayList((Object[])new String[]{"snmdkye", "bnmdkye", "snmsszbjye", "bnmsszbjye", "snmdkzcye", "bnmdkzcye", "jtbl", "jszbje", "dksszbjye", "dksszbj", "nstzje"});
    private static final String ITEMNUMBER = "itemnumber";
    private static final String ENTRYTYPE = "entrytype";
    private static final String ROWTYPE = "rowtype";
    private static final String ID = "id";
    private static final String TOTALAMOUNT = "totalamount";
    private static final String ADJUSTAMOUNT = "adjustamount";
    private static final String XEDK_NUMBER = "6635";
    protected static final Map<String, String> projects = new HashMap<String, String>();
    private static final String STRING1 = "&";
    private static final String ZEROSTR = "0";
    protected static final Map<String, String> itemTypes;
    protected static final Map<String, String> ruleEntryTypes;
    public static final String JTBL_NORULE = "dksszbj_jtbl";
    public static final String DKSSZBJYE_NORULE = "dksszbj_dksszbjye";
    public static final String DKSSZBJ_NORULE = "dksszbj_dksszbj";
    public static final String NSTZJE_NORULE = "dksszbj_nstzje";
    protected static final List<String> noLinkCells;
    protected static final List<String> noDecimalCells;
    protected static final List<String> tableCalcCells;
    protected static final List<String> lastPeriodCalcCells;
    private static final Set<String> NORULELIST;
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        String columnDescKey;
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        String rowKey = d.getString(ITEMTYPE);
        String key = DksszbjTZFormPlugin.getKey(rowKey, columnDescKey = columnDesc.getKey());
        if (noDecimalCells.contains(key)) {
            e.setFormatValue((Object)"<nolink>*");
        } else if (noLinkCells.contains(key)) {
            Object formatValue1 = e.getFormatValue();
            BigDecimal formatValue = BigDecimal.ZERO;
            if (formatValue1 instanceof BigDecimal) {
                formatValue = (BigDecimal)formatValue1;
            } else if (formatValue1 instanceof String) {
                formatValue = new BigDecimal(String.valueOf(formatValue1));
            }
            if (columnDescKey.equals(JTBL)) {
                BigDecimal divide = formatValue.multiply(new BigDecimal(100)).setScale(2, 4);
                e.setFormatValue((Object)("<nolink>" + divide + "%"));
            } else {
                String s = DataFormatUtils.formatMicrometer((String)formatValue.toString());
                e.setFormatValue((Object)("<nolink>" + s));
            }
        } else if (QT.equals(rowKey) && ITEMTYPE.equals(columnDescKey)) {
            if (StringUtil.equals((CharSequence)this.getPageCache().get("xedk"), (CharSequence)ZEROSTR)) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u4e8c\u3001\u5176\u4ed6", (String)"DksszbjTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        } else if (HJ.equals(rowKey) && ITEMTYPE.equals(columnDescKey) && StringUtil.equals((CharSequence)this.getPageCache().get("xedk"), (CharSequence)ZEROSTR)) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1\uff081+8\uff09", (String)"DksszbjTZFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.showForm(true);
    }

    private void showForm(boolean isnew) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
        List query = this.getSummarys();
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        boolean xedk = false;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            xedk = StringUtil.equals((CharSequence)((DynamicObject)result.getData()).getString("codeandname.number"), (CharSequence)XEDK_NUMBER);
        }
        this.getPageCache().put("xedk", xedk ? JRQY : ZEROSTR);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        int rowIndex = 0;
        ArrayList showColumns = Lists.newArrayList((Object[])new String[]{SNMDKYE, BNMDKYE, SNMSSZBJYE, BNMSSZBJYE, SNMDKZCYE, BNMDKZCYE, JTBL, JSZBJE, DKSSZBJYE, DKSSZBJ, NSTZJE});
        for (DynamicObject dynamicObject : query) {
            String itemType = dynamicObject.getString(ITEMTYPE);
            DynamicObject dynamicObject1 = isnew ? entryEntity.addNew() : (DynamicObject)entryEntity.get(rowIndex);
            dynamicObject1.set(ITEM_NO, (Object)(rowIndex + 1));
            dynamicObject1.set(ITEMTYPE, (Object)itemType);
            for (String column : showColumns) {
                Object value = dynamicObject.get(column);
                if (value instanceof BigDecimal) {
                    BigDecimal valueBig = (BigDecimal)value;
                    value = valueBig.setScale(2, 4);
                }
                dynamicObject1.set(column, value);
            }
            ++rowIndex;
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private List getSummarys() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = (String)customParams.get("orgid");
        String startData = (String)customParams.get("skssqq");
        String endData = (String)customParams.get("skssqz");
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startData)).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endData)));
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DKSSZBJ_SUM, (String)ID, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"itemno asc");
        List collect = query.stream().map(a -> a.getLong(ID)).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCCIT_DKSSZBJ_SUM));
        return Arrays.stream(load).sorted(Comparator.comparing(a -> a.getInt(ITEM_NO))).collect(Collectors.toList());
    }

    private String getLastSbbid(Long orgId, Date startData, Date endData) {
        Date date = DateUtils.addYear((Date)startData, (int)-1);
        Date date1 = DateUtils.addYear((Date)endData, (int)-1);
        DynamicObject queryYbnsr = YbnsrService.queryYbnsr((String)String.valueOf(orgId), (String)"qysdsnb", (String)DateUtils.format((Date)date), (String)DateUtils.format((Date)date1), null);
        if (queryYbnsr == null) {
            return ZEROSTR;
        }
        if (Objects.equals(queryYbnsr.getString("declarestatus"), "declared")) {
            return queryYbnsr.getString(ID);
        }
        return ZEROSTR;
    }

    private Map<String, BigDecimal> getPolicyRateMap(String orgId, String startDate, String endDate) {
        Map map = AssistService.queryAssistParams((List)Lists.newArrayList((Object[])new String[]{"DKSSZBJ", "SNZXQY-CJL", "SNZXQY-GZL", "SNZXQY-KYL", "SNZXQY-SSL", "XEDK"}), (String)orgId, (String)startDate, (String)endDate);
        HashMap<String, BigDecimal> stringBigDecimalHashMap = new HashMap<String, BigDecimal>(map.size());
        map.entrySet().forEach(a -> {
            if (StringUtil.isNotEmpty((CharSequence)((CharSequence)a.getValue()))) {
                stringBigDecimalHashMap.put((String)a.getKey(), new BigDecimal((String)a.getValue()));
            }
        });
        return stringBigDecimalHashMap;
    }

    private List<QFilter> getTzQFilters(Map<String, Object> customParams) {
        List<QFilter> qFilters = this.getQFilters(customParams);
        String itemnumber = (String)customParams.get(ITEMNUMBER);
        qFilters.add(new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_"))));
        qFilters.add(new QFilter(ENTRYTYPE, "=", customParams.get(ENTRYTYPE)));
        return qFilters;
    }

    private List<QFilter> getQFilters(Map<String, Object> customParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        qFilters.add(new QFilter("org", "=", (Object)Long.parseLong((String)orgid)));
        qFilters.add(new QFilter("skssqq", "=", (Object)skssqq));
        qFilters.add(new QFilter("skssqz", "=", (Object)skssqz));
        return qFilters;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String columnKey = evt.getFieldName();
        String itemtype = (String)this.getModel().getValue(ITEMTYPE, rowIndex);
        String entryType = itemTypes.get(columnKey);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("rowIndex", rowIndex);
        customParams.put(ROWTYPE, itemtype);
        customParams.put(ENTRYTYPE, entryType);
        customParams.put(ITEMNUMBER, projects.get(itemtype));
        customParams.put("entryname", TCCIT_SPEC_DKSSZBJ_DETAIL);
        if (QT.equals(itemtype) && columnKey.equals(JTBL)) {
            customParams.put("righttype", JRQY);
        }
        if (NORULELIST.contains(entryType)) {
            BigDecimal originalamount = BigDecimal.ZERO;
            switch (entryType) {
                case "dksszbj_jtbl": 
                case "dksszbj_dksszbjye": 
                case "dksszbj_dksszbj": 
                case "dksszbj_nstzje": {
                    List<QFilter> qFilters = this.getTzQFilters(customParams);
                    DynamicObjectCollection results = QueryServiceHelper.query((String)TCCIT_ADJUST_DETAIL, (String)"id,amount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
                    originalamount = results.size() == 0 ? (BigDecimal)this.getModel().getValue(columnKey, rowIndex) : results.stream().map(a -> a.getBigDecimal("amount")).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                }
            }
            customParams.put("originalamount", originalamount.setScale(2));
        }
        customParams.put("closecallback", "closecallback");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TCCIT_DETAIL_TZ_DIALOG);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TCCIT_DKSSZBJ_SUM);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (TCCIT_DKSSZBJ_SUM.equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private static String getKey(String rowType, String columnType) {
        return rowType + STRING1 + columnType;
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("dksszbjtz")) {
            return;
        }
        List<QFilter> qFilters = this.getQFilters(customParams);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SPEC_DKSSZBJ_DETAIL, (String)"amount,fetchamount,entrytype,itemnumber", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        Map<String, List<DynamicObject>> ruleDetails = query.stream().collect(Collectors.groupingBy(a -> a.getString(ITEMNUMBER) + a.getString(ENTRYTYPE)));
        String lastSbbid = this.getLastSbbid(orgid, skssqq, skssqz);
        HashMap<String, DynamicObject> lastSbbdataMap = new HashMap<String, DynamicObject>(16);
        if (!Objects.equals(lastSbbid, ZEROSTR)) {
            QFilter and = new QFilter("sbbid", "=", (Object)lastSbbid);
            DynamicObjectCollection lastSbb = QueryServiceHelper.query((String)"tccit_qysds_a105120_dk", (String)" * ", (QFilter[])and.toArray());
            Map optionalMap = lastSbb.stream().collect(Collectors.groupingBy(a -> a.getString("ewblxh"), Collectors.reducing((m, n) -> m)));
            optionalMap.entrySet().forEach(a -> {
                if (((Optional)a.getValue()).isPresent()) {
                    lastSbbdataMap.put((String)a.getKey(), (DynamicObject)((Optional)a.getValue()).get());
                }
            });
        }
        Map<String, BigDecimal> policyTateMap = this.getPolicyRateMap((String)customParams.get("orgid"), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"));
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(128);
        for (String row : rows) {
            for (String column : columns) {
                String key = DksszbjTZFormPlugin.getKey(row, column);
                if (tableCalcCells.contains(key)) continue;
                result.put(key, this.calcAmount(row, column, ruleDetails, policyTateMap, lastSbbdataMap, customParams));
            }
        }
        tableCalcCells.forEach(a -> {
            String[] split = a.split(STRING1);
            String row = split[0];
            String column = split[1];
            result.put((String)a, this.getTableAmount(row, column));
        });
        this.saveCurrentPeriod(result, orgid, skssqq, skssqz);
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, List<DynamicObject>> detailsMap, Map<String, BigDecimal> policyTateMap, Map<String, DynamicObject> lastSbbdataMap, Map<String, Object> customParams) {
        BigDecimal amount = BigDecimal.ZERO;
        String key = DksszbjTZFormPlugin.getKey(rowType, columnType);
        if (noDecimalCells.contains(key)) {
            return amount;
        }
        if (JTBL.equals(columnType)) {
            amount = this.getPolicyRate(rowType, columnType, policyTateMap);
        } else if (StringUtil.isNotEmpty((CharSequence)projects.get(rowType)) && StringUtil.isNotEmpty((CharSequence)ruleEntryTypes.get(columnType))) {
            amount = this.getRuleAmount(projects.get(rowType), ruleEntryTypes.get(columnType), detailsMap);
        } else if (tableCalcCells.contains(key)) {
            amount = this.getTableAmount(rowType, columnType);
        } else if (lastPeriodCalcCells.contains(key)) {
            amount = this.getLastPeriodAmount(rowType, columnType, lastSbbdataMap);
        }
        amount = this.calAdjust(rowType, columnType, amount, customParams);
        this.dataMap.put(key, amount);
        return amount;
    }

    private BigDecimal calAdjust(String rowType, String columnType, BigDecimal amount, Map<String, Object> customParams) {
        String key = DksszbjTZFormPlugin.getKey(rowType, columnType);
        if (noLinkCells.contains(key)) {
            return amount;
        }
        String itemnumber = projects.get(rowType);
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter(ITEMNUMBER, "=", (Object)itemnumber).or(new QFilter(ITEMNUMBER, "=", (Object)(itemnumber + "_")));
        QFilter entrytypeFilter = new QFilter(ENTRYTYPE, "=", (Object)itemTypes.get(columnType));
        DynamicObjectCollection results = QueryServiceHelper.query((String)TCCIT_ADJUST_DETAIL, (String)ADJUSTAMOUNT, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, itemnumberFilter, entrytypeFilter});
        return results.stream().map(a -> a.getBigDecimal(ADJUSTAMOUNT)).reduce(amount, BigDecimal::add);
    }

    private BigDecimal getRuleAmount(String itemnumber, String ruleProjectType, Map<String, List<DynamicObject>> detailsMap) {
        List orDefault = detailsMap.getOrDefault(itemnumber + ruleProjectType, new ArrayList(0));
        BigDecimal amount = orDefault.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return amount.setScale(2, 4);
    }

    private BigDecimal getLastPeriodAmount(String rowType, String columnType, Map<String, DynamicObject> lastSbbMap) {
        BigDecimal zero = BigDecimal.ZERO;
        DynamicObject object2 = lastSbbMap.get(rowType);
        if (object2 != null) {
            zero = object2.getBigDecimal(DKSSZBJYE).add(object2.getBigDecimal(DKSSZBJ)).setScale(2, 4);
        }
        return zero;
    }

    private BigDecimal getPolicyRate(String rowType, String columnType, Map<String, BigDecimal> policyTateMap) {
        BigDecimal zero = BigDecimal.ZERO;
        switch (rowType) {
            case "2": {
                zero = policyTateMap.getOrDefault("DKSSZBJ", BigDecimal.ZERO);
                break;
            }
            case "4": {
                zero = policyTateMap.getOrDefault("SNZXQY-CJL", BigDecimal.ZERO);
                break;
            }
            case "5": {
                zero = policyTateMap.getOrDefault("SNZXQY-GZL", BigDecimal.ZERO);
                break;
            }
            case "6": {
                zero = policyTateMap.getOrDefault("SNZXQY-KYL", BigDecimal.ZERO);
                break;
            }
            case "7": {
                zero = policyTateMap.getOrDefault("SNZXQY-SSL", BigDecimal.ZERO);
                break;
            }
            case "8": {
                zero = policyTateMap.getOrDefault("DKSSZBJ", BigDecimal.ZERO);
            }
        }
        return zero;
    }

    private BigDecimal getTableAmount(String rowType, String columnType) {
        BigDecimal zero = BigDecimal.ZERO;
        ArrayList strings1 = Lists.newArrayList((Object[])new String[]{SNMDKYE, BNMDKYE, SNMDKZCYE, BNMDKZCYE, JSZBJE});
        ArrayList strings8 = Lists.newArrayList((Object[])new String[]{DKSSBBJ, GZLDK, CJLDK, KYLDK, SSLDK, XGDKGS, QT});
        ArrayList strings11 = Lists.newArrayList((Object[])new String[]{JRQY, XGDKGS, QT});
        if (SNDKSSZBJ.equals(rowType)) {
            BigDecimal orDefault4 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(GZLDK, columnType), BigDecimal.ZERO);
            BigDecimal orDefault5 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(CJLDK, columnType), BigDecimal.ZERO);
            BigDecimal orDefault6 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(KYLDK, columnType), BigDecimal.ZERO);
            BigDecimal orDefault7 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(SSLDK, columnType), BigDecimal.ZERO);
            zero = orDefault4.add(orDefault5).add(orDefault6).add(orDefault7);
        } else if (JSZBJE.equals(columnType) && strings8.contains(rowType)) {
            BigDecimal orDefault6 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, BNMDKZCYE), BigDecimal.ZERO);
            BigDecimal orDefault7 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, JTBL), BigDecimal.ZERO);
            zero = orDefault6.multiply(orDefault7).setScale(2, 4);
        } else if (JRQY.equals(rowType) && strings1.contains(columnType)) {
            BigDecimal orDefault2 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(DKSSBBJ, columnType), BigDecimal.ZERO);
            BigDecimal orDefault3 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, columnType), BigDecimal.ZERO);
            zero = orDefault2.add(orDefault3);
        } else if (DKSSZBJ.equals(columnType) && strings11.contains(rowType)) {
            BigDecimal orDefault4 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, BNMSSZBJYE), BigDecimal.ZERO);
            BigDecimal orDefault8 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, JSZBJE), BigDecimal.ZERO);
            BigDecimal orDefault9 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, DKSSZBJYE), BigDecimal.ZERO);
            zero = orDefault4.compareTo(orDefault8) < 0 ? orDefault4.subtract(orDefault9) : orDefault8.subtract(orDefault9);
        } else if (NSTZJE.equals(columnType) && strings11.contains(rowType)) {
            BigDecimal orDefault4 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, BNMSSZBJYE), BigDecimal.ZERO);
            BigDecimal orDefault3 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, SNMSSZBJYE), BigDecimal.ZERO);
            BigDecimal orDefault10 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(rowType, DKSSZBJ), BigDecimal.ZERO);
            zero = orDefault4.subtract(orDefault3).subtract(orDefault10);
        } else if (HJ.equals(rowType) && !JTBL.equals(columnType)) {
            BigDecimal orDefault1 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(JRQY, columnType), BigDecimal.ZERO);
            BigDecimal orDefault8 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(XGDKGS, columnType), BigDecimal.ZERO);
            BigDecimal orDefault9 = this.dataMap.getOrDefault(DksszbjTZFormPlugin.getKey(QT, columnType), BigDecimal.ZERO);
            zero = orDefault1.add(orDefault8).add(orDefault9);
        }
        this.dataMap.put(DksszbjTZFormPlugin.getKey(rowType, columnType), zero);
        return zero;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DKSSZBJ_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private void saveCurrentPeriod(Map<String, BigDecimal> result, Long orgid, Date skssqq, Date skssqz) {
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String row : rows) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DKSSZBJ_SUM);
            for (String column : columns) {
                dynamicObject.set(column, (Object)result.get(DksszbjTZFormPlugin.getKey(row, column)));
            }
            dynamicObject.set(ITEMTYPE, (Object)row);
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{SNMDKYE, BNMDKYE, SNMSSZBJYE, BNMSSZBJYE, SNMDKZCYE, BNMDKZCYE, JTBL, JSZBJE, DKSSZBJYE, DKSSZBJ});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEMTYPE);
        customParams.put("entryname", TCCIT_SPEC_DKSSZBJ_DETAIL);
        customParams.put(ENTRYTYPE, itemTypes.get(column));
        customParams.put("columnType", column);
        customParams.put(ITEMNUMBER, projects.get(itemtype));
        return customParams;
    }

    static {
        projects.put(JRQY, "801020101");
        projects.put(DKSSBBJ, "80102010101");
        projects.put(GZLDK, "8010201010201");
        projects.put(CJLDK, "8010201010202");
        projects.put(KYLDK, "8010201010203");
        projects.put(SSLDK, "8010201010204");
        projects.put(XGDKGS, "801020102");
        projects.put(QT, "801020103");
        itemTypes = new HashMap<String, String>();
        ruleEntryTypes = new HashMap<String, String>();
        itemTypes.put(SNMDKYE, SNMDKZCYE);
        itemTypes.put(BNMDKYE, BNMDKZCYE);
        itemTypes.put(SNMSSZBJYE, "snmdksszbjye");
        itemTypes.put(BNMSSZBJYE, "bnmdksszbjye");
        itemTypes.put(SNMDKZCYE, "snmzytqdksszbjddkzcye");
        itemTypes.put(BNMDKZCYE, "bnmzytqdksszbjddkzcye");
        ruleEntryTypes.putAll(itemTypes);
        itemTypes.put(JTBL, JTBL_NORULE);
        itemTypes.put(DKSSZBJYE, DKSSZBJYE_NORULE);
        itemTypes.put(DKSSZBJ, DKSSZBJ_NORULE);
        itemTypes.put(NSTZJE, NSTZJE_NORULE);
        noLinkCells = new ArrayList<String>(32);
        noDecimalCells = new ArrayList<String>(32);
        tableCalcCells = new ArrayList<String>(32);
        lastPeriodCalcCells = new ArrayList<String>(32);
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, SNMDKYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, BNMDKYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, SNMDKZCYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, BNMDKZCYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, DKSSZBJ));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(JRQY, NSTZJE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, SNMDKYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, BNMDKYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, SNMDKZCYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, BNMDKZCYE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(GZLDK, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(CJLDK, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(KYLDK, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(SSLDK, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, JTBL));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, DKSSZBJ));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, NSTZJE));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(QT, DKSSZBJ));
        noLinkCells.add(DksszbjTZFormPlugin.getKey(QT, NSTZJE));
        for (String column : columns) {
            if (JTBL.equals(column) || JSZBJE.equals(column)) continue;
            noLinkCells.add(DksszbjTZFormPlugin.getKey(HJ, column));
        }
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(JRQY, JTBL));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, JTBL));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(HJ, JTBL));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, NSTZJE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, NSTZJE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(GZLDK, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(GZLDK, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(GZLDK, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(GZLDK, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(GZLDK, NSTZJE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(CJLDK, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(CJLDK, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(CJLDK, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(CJLDK, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(CJLDK, NSTZJE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(KYLDK, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(KYLDK, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(KYLDK, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(KYLDK, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(KYLDK, NSTZJE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SSLDK, SNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SSLDK, BNMSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SSLDK, DKSSZBJYE));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SSLDK, DKSSZBJ));
        noDecimalCells.add(DksszbjTZFormPlugin.getKey(SSLDK, NSTZJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(GZLDK, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(CJLDK, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(KYLDK, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SSLDK, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(QT, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, SNMDKYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, BNMDKYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, SNMDKZCYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, BNMDKZCYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(SNDKSSZBJ, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(DKSSBBJ, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, SNMDKYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, BNMDKYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, SNMDKZCYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, BNMDKZCYE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, JSZBJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, DKSSZBJ));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, NSTZJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, DKSSZBJ));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, NSTZJE));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(QT, DKSSZBJ));
        tableCalcCells.add(DksszbjTZFormPlugin.getKey(QT, NSTZJE));
        for (String col : columns) {
            tableCalcCells.add(DksszbjTZFormPlugin.getKey(HJ, col));
        }
        lastPeriodCalcCells.add(DksszbjTZFormPlugin.getKey(JRQY, DKSSZBJYE));
        lastPeriodCalcCells.add(DksszbjTZFormPlugin.getKey(XGDKGS, DKSSZBJYE));
        lastPeriodCalcCells.add(DksszbjTZFormPlugin.getKey(QT, DKSSZBJYE));
        NORULELIST = Sets.newHashSet((Object[])new String[]{JTBL_NORULE, DKSSZBJYE_NORULE, DKSSZBJ_NORULE, NSTZJE_NORULE});
    }
}

