/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.MbyqndksjsdgFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class DkynssdeTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"0", DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin("one"), "1", "2", "3", "4", "5", "6", "7", "8", DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin("two"), "9", "10", "11", "12", "13", "14", "15", "16", DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin(""), "17"});
    public static final Set<String> titles = Sets.newHashSet((Object[])new String[]{DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin("one"), DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin("two"), DkynssdeTZFormPlugin.getMsgCancleEditNewAdmin("")});
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String WSS_CURRENT = "wsscurrent";
    public static final String ZZQ_CURRENT = "zzqcurrent";
    public static final String HJJE_CURRENT = "hjjecurrent";
    public static final String TCCIT_DG_A100000_7_SUM = "tccit_dg_a100000_7_sum";
    public static final Set<String> needLink = Sets.newHashSet((Object[])new String[]{"1", "2", "7", "9", "15"});
    public static final Set<String> hjNeedLink = Sets.newHashSet((Object[])new String[]{"5", "12"});
    public static final Set<String> needReturnNull = Sets.newHashSet((Object[])new String[]{"5", "6", "8", "12", "13", "14", "16"});
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();

    private static String getMsgCancleEditNewAdmin(String number) {
        if ("one".equals(number)) {
            return ResManager.loadKDString((String)"\u4e00", (String)"DkynssdeTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        if ("two".equals(number)) {
            return ResManager.loadKDString((String)"\u4e8c", (String)"DkynssdeTZFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e09", (String)"DkynssdeTZFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        this.dataMap.clear();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,hjjecurrent,wsscurrent,zzqcurrent";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DG_A100000_7_SUM, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)"id");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject titleObject = (DynamicObject)query.get(0);
        model.setValue("mbyqndksh", (Object)titleObject.getBigDecimal(HJJE_CURRENT));
        model.setValue("dkynssde", (Object)titleObject.getBigDecimal(WSS_CURRENT));
        model.setValue("dkhynssde", (Object)titleObject.getBigDecimal(ZZQ_CURRENT));
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() - 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 1; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String itemType = dynamicObject.getString(ITEM_TYPE);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(HJJE_CURRENT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, HJJE_CURRENT));
            dot.getProperty(WSS_CURRENT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, WSS_CURRENT));
            dot.getProperty(ZZQ_CURRENT).setValueFast((Object)data, (Object)this.formatData(itemType, dynamicObject, ZZQ_CURRENT));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(String itemType, DynamicObject dynamicObject, String columnType) {
        if (titles.contains(itemType)) {
            return "";
        }
        if (needReturnNull.contains(itemType) && !HJJE_CURRENT.equals(columnType)) {
            return "<nolink>*";
        }
        StringBuilder link = new StringBuilder("<nolink>");
        String text = itemType.equals("3") || itemType.equals("10") ? DataFormat.formatRate(dynamicObject.getBigDecimal(columnType).setScale(0, 4).toString()) : DataFormat.formatMicrometer(dynamicObject.getBigDecimal(columnType).setScale(2, 4).toString());
        if (!(!HJJE_CURRENT.equals(columnType) && needLink.contains(itemType) || HJJE_CURRENT.equals(columnType) && hjNeedLink.contains(itemType))) {
            text = link.append(text).toString();
        }
        return text;
    }

    protected void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_A100000_7_SUM, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_A100000_7_SUM);
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(WSS_CURRENT, (Object)this.calcAmount(itemType, WSS_CURRENT, customParams, dynamicObject));
            dynamicObject.set(ZZQ_CURRENT, (Object)this.calcAmount(itemType, ZZQ_CURRENT, customParams, dynamicObject));
            dynamicObject.set(HJJE_CURRENT, (Object)this.calcAmount(itemType, HJJE_CURRENT, customParams, dynamicObject));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        DynamicObject dynamicObject0 = (DynamicObject)sum.get(0);
        dynamicObject0.set(WSS_CURRENT, (Object)this.dataMap.get(this.getKey("17", HJJE_CURRENT)));
        dynamicObject0.set(ZZQ_CURRENT, (Object)dynamicObject0.getBigDecimal(HJJE_CURRENT).subtract(dynamicObject0.getBigDecimal(WSS_CURRENT)));
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams, DynamicObject dynamicObject) {
        BigDecimal result;
        BigDecimal amount;
        BigDecimal adjustAmount;
        if ("0".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal mbyqndks = this.getMbyqndks(customParams);
            this.dataMap.put(this.getKey(rowType, columnType), mbyqndks);
            return mbyqndks;
        }
        if ("1".equals(rowType) && WSS_CURRENT.equals(columnType)) {
            BigDecimal amount2 = this.getAmount(customParams, "bncyxhhctqy", "80201");
            this.dataMap.put(this.getKey(rowType, columnType), amount2);
            return amount2;
        }
        if ("1".equals(rowType) && ZZQ_CURRENT.equals(columnType)) {
            BigDecimal amount3 = this.getAmount(customParams, "bncyxhhctqy", "80202");
            this.dataMap.put(this.getKey(rowType, columnType), amount3);
            return amount3;
        }
        if ("1".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal sum = this.dataMap.get(this.getKey(rowType, WSS_CURRENT)).add(this.dataMap.get(this.getKey(rowType, ZZQ_CURRENT)));
            this.dataMap.put(this.getKey(rowType, columnType), sum);
            return sum;
        }
        if ("2".equals(rowType) && WSS_CURRENT.equals(columnType)) {
            BigDecimal amount4 = this.getAmount(customParams, "bnxzdkdktze", "80201");
            this.dataMap.put(this.getKey(rowType, columnType), amount4);
            return amount4;
        }
        if ("2".equals(rowType) && ZZQ_CURRENT.equals(columnType)) {
            BigDecimal amount5 = this.getAmount(customParams, "bnxzdkdktze", "80202");
            this.dataMap.put(this.getKey(rowType, columnType), amount5);
            return amount5;
        }
        if ("2".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal sum = this.dataMap.get(this.getKey(rowType, WSS_CURRENT)).add(this.dataMap.get(this.getKey(rowType, ZZQ_CURRENT)));
            this.dataMap.put(this.getKey(rowType, columnType), sum);
            return sum;
        }
        if ("3".equals(rowType) || "10".equals(rowType)) {
            if (ZZQ_CURRENT.equals(columnType) || HJJE_CURRENT.equals(columnType)) {
                BigDecimal result2 = this.dataMap.get(this.getKey(rowType, WSS_CURRENT));
                this.dataMap.put(this.getKey(rowType, columnType), result2);
                return result2;
            }
            List strings = AssistService.queryAssistParams((String)"CTQYDJ", (String)String.valueOf(customParams.get("orgid")), (String)String.valueOf(customParams.get("skssqq")), (String)String.valueOf(customParams.get("skssqz")));
            BigDecimal amount6 = (CollectionUtils.isEmpty((Collection)strings) ? BigDecimal.valueOf(70L) : new BigDecimal((String)strings.get(0))).setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), amount6);
            return amount6;
        }
        if ("4".equals(rowType)) {
            BigDecimal result3 = this.dataMap.get(this.getKey("2", columnType)).multiply(this.dataMap.get(this.getKey("3", columnType))).divide(BigDecimal.valueOf(100L), 2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), result3);
            return result3;
        }
        if ("5".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            DynamicObject adjust = this.getAdjust(customParams, rowType, columnType);
            BigDecimal ljjzyhndkce = adjust != null ? adjust.getBigDecimal("totalamount") : this.getLjjzyhndkce(customParams, "14").setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), ljjzyhndkce);
            return ljjzyhndkce;
        }
        if ("6".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal account = this.dataMap.get(this.getKey("4", columnType)).add(this.dataMap.get(this.getKey("5", columnType)));
            this.dataMap.put(this.getKey(rowType, columnType), account);
            BigDecimal tem1 = this.dataMap.get(this.getKey("1", columnType)).compareTo(this.dataMap.get(this.getKey("0", columnType))) > 0 ? this.dataMap.get(this.getKey("0", columnType)) : this.dataMap.get(this.getKey("1", columnType));
            BigDecimal tem2 = tem1.compareTo(account) > 0 ? account : tem1;
            BigDecimal result4 = tem2.compareTo(BigDecimal.ZERO) > 0 ? tem2 : BigDecimal.ZERO;
            this.dataMap.put(this.getKey("7", columnType), result4);
            return account;
        }
        if ("7".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            return this.dataMap.get(this.getKey(rowType, columnType));
        }
        if ("7".equals(rowType) && WSS_CURRENT.equals(columnType) && (adjustAmount = this.getAdjustAmount(customParams, rowType, columnType)) != null) {
            this.dataMap.put(this.getKey(rowType, columnType), adjustAmount);
            return adjustAmount;
        }
        if ("7".equals(rowType) && ZZQ_CURRENT.equals(columnType) && (adjustAmount = this.getAdjustAmount(customParams, rowType, columnType)) != null) {
            this.dataMap.put(this.getKey(rowType, columnType), adjustAmount);
            return adjustAmount;
        }
        if ("8".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            amount = this.dataMap.get(this.getKey("6", HJJE_CURRENT)).subtract(this.dataMap.get(this.getKey("7", HJJE_CURRENT)));
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("9".equals(rowType) && WSS_CURRENT.equals(columnType)) {
            amount = this.getAmount(customParams, "bnxzdkdktze", "80101");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("9".equals(rowType) && ZZQ_CURRENT.equals(columnType)) {
            amount = this.getAmount(customParams, "bnxzdkdktze", "80102");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("9".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal sum = this.dataMap.get(this.getKey(rowType, WSS_CURRENT)).add(this.dataMap.get(this.getKey(rowType, ZZQ_CURRENT)));
            this.dataMap.put(this.getKey(rowType, columnType), sum);
            return sum;
        }
        if ("11".equals(rowType)) {
            result = this.dataMap.get(this.getKey("9", columnType)).multiply(this.dataMap.get(this.getKey("10", columnType))).divide(BigDecimal.valueOf(100L), 2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), result);
            return result;
        }
        if ("12".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            DynamicObject adjust = this.getAdjust(customParams, rowType, columnType);
            BigDecimal ljjzyhndkce = adjust != null ? adjust.getBigDecimal("totalamount") : this.getLjjzyhndkce(customParams, "8").setScale(2, 4);
            this.dataMap.put(this.getKey(rowType, columnType), ljjzyhndkce);
            return ljjzyhndkce;
        }
        if ("13".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            amount = this.dataMap.get(this.getKey("11", HJJE_CURRENT)).add(this.dataMap.get(this.getKey("12", HJJE_CURRENT)));
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("14".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            BigDecimal tem = this.dataMap.get(this.getKey("0", HJJE_CURRENT)).subtract(this.dataMap.get(this.getKey("7", HJJE_CURRENT)));
            BigDecimal amount7 = tem.compareTo(BigDecimal.ZERO) > 0 ? tem : BigDecimal.ZERO;
            this.dataMap.put(this.getKey(rowType, columnType), amount7);
            BigDecimal result5 = this.dataMap.get(this.getKey("13", columnType)).compareTo(amount7) > 0 ? amount7 : this.dataMap.get(this.getKey("13", columnType));
            this.dataMap.put(this.getKey("15", columnType), result5);
            return amount7;
        }
        if ("15".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            return this.dataMap.get(this.getKey(rowType, columnType));
        }
        if ("15".equals(rowType) && WSS_CURRENT.equals(columnType) && (adjustAmount = this.getAdjustAmount(customParams, rowType, columnType)) != null) {
            this.dataMap.put(this.getKey(rowType, columnType), adjustAmount);
            return adjustAmount;
        }
        if ("15".equals(rowType) && ZZQ_CURRENT.equals(columnType) && (adjustAmount = this.getAdjustAmount(customParams, rowType, columnType)) != null) {
            this.dataMap.put(this.getKey(rowType, columnType), adjustAmount);
            return adjustAmount;
        }
        if ("16".equals(rowType) && HJJE_CURRENT.equals(columnType)) {
            amount = BigDecimalUtil.subtractObject((Object)this.dataMap.get(this.getKey("13", columnType)), (Object)this.dataMap.get(this.getKey("15", columnType)));
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("17".equals(rowType)) {
            result = BigDecimalUtil.addObject((Object)this.dataMap.get(this.getKey("7", columnType)), (Object)this.dataMap.get(this.getKey("15", columnType)));
            this.dataMap.put(this.getKey(rowType, columnType), result);
            return result;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String itemnumber) {
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, "tccit_dg_a100000_7_det");
    }

    private BigDecimal getAdjustAmount(Map<String, Object> customParams, String rowType, String columnType) {
        DynamicObject dynamicObject = this.getAdjust(customParams, rowType, columnType);
        if (dynamicObject != null) {
            return dynamicObject.getBigDecimal("totalamount");
        }
        return null;
    }

    private BigDecimal getAdjustOriginalAmount(Map<String, Object> customParams, String rowType, String columnType) {
        DynamicObject dynamicObject = this.getAdjust(customParams, rowType, columnType);
        if (dynamicObject != null) {
            BigDecimal totalamount = dynamicObject.getBigDecimal("totalamount");
            BigDecimal adjustamount = dynamicObject.getBigDecimal("adjustamount");
            return totalamount.subtract(adjustamount);
        }
        return null;
    }

    private DynamicObject getAdjust(Map<String, Object> customParams, String rowType, String columnType) {
        String itemnumber = this.getKey(rowType, columnType);
        Object entrytype = this.geEntryType(rowType);
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_")));
        QFilter entrytypeFilter = new QFilter("entrytype", "=", entrytype);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
        String selectPrope = "taxorg,ruleid,entrytype,adjustamount,totalamount,titlename,adjustexplain";
        return QueryServiceHelper.queryOne((String)"tccit_adjust_detail", (String)selectPrope, (QFilter[])filters);
    }

    private BigDecimal getOriginalAmount(Map<String, Object> customParams, String row, String clomun) {
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter ajustnum = new QFilter(ITEM_TYPE, "=", (Object)row);
        String selectField = HJJE_CURRENT.equals(clomun) ? clomun : "o" + clomun;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCCIT_DG_A100000_7_SUM, (String)selectField, (QFilter[])new QFilter[]{orgFilter, dateFilter, ajustnum});
        return dynamicObject.getBigDecimal(selectField);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String rowType = (String)itemsEntity.getModel().getValue(ITEM_TYPE);
        String columnType = evt.getFieldName();
        String itemNumber = projects.get(this.getKey(rowType, columnType));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (StringUtils.isNotEmpty((CharSequence)itemNumber) && itemNumber.startsWith("8")) {
            customParams.put("columnType", columnType);
            customParams.put("entrytype", this.geEntryType(rowType));
            customParams.put("itemnumber", itemNumber);
            customParams.put("entryname", "tccit_dg_a100000_7_det");
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        } else {
            BigDecimal adjustOriginalAmount = this.getAdjustOriginalAmount(customParams, rowType, columnType);
            customParams.put("columnType", columnType);
            customParams.put("entrytype", this.geEntryType(rowType));
            customParams.put("itemnumber", itemNumber);
            customParams.put("originalamount", adjustOriginalAmount == null ? this.getOriginalAmount(customParams, rowType, columnType) : adjustOriginalAmount);
            customParams.put("existsRules", Boolean.FALSE);
            customParams.put("savecheck", Boolean.TRUE);
            this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
        }
    }

    private Object geEntryType(String rowType) {
        String result = "bnxzdkdktze";
        if ("1".equals(rowType)) {
            result = "bncyxhhctqy";
        }
        return result;
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private BigDecimal getMbyqndks(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObject query = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_4_sum", (String)"lmhjnsd", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        BigDecimal lmhjnsd = query == null ? BigDecimal.ZERO : query.getBigDecimal("lmhjnsd");
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"tccit_dg_b105060_sum", (String)"sum(syjnsdmb) as syjnsdmb", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        BigDecimal bnsyjnsd = query == null ? BigDecimal.ZERO : ((DynamicObject)query2.get(0)).getBigDecimal("syjnsdmb");
        return BigDecimal.ZERO.compareTo(lmhjnsd.subtract(bnsyjnsd)) < 0 ? lmhjnsd.subtract(bnsyjnsd) : BigDecimal.ZERO;
    }

    private BigDecimal getLjjzyhndkce(Map<String, Object> customParams, String ewblxh) {
        String orgId = String.valueOf(customParams.get("orgid"));
        String skssqq = String.valueOf(customParams.get("skssqq"));
        int year = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)skssqq));
        BigDecimal ljjzyhndkce = BigDecimal.ZERO;
        DynamicObject dynamicObject = YbnsrService.queryYbnsr((String)orgId, (String)"qysdsnb", (String)(year - 1 + "-01-01"), (String)(year - 1 + "-12-31"), (int)0, null);
        if (null != dynamicObject) {
            String sbbid = dynamicObject.getString("id");
            QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter qFilter2 = new QFilter("ewblxh", "=", (Object)ewblxh);
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tccit_qysds_a107030", (String)"hjje", (QFilter[])new QFilter[]{qFilter, qFilter2});
            if (dynamicObject1 != null) {
                ljjzyhndkce = dynamicObject1.getBigDecimal("hjje");
            }
        }
        return ljjzyhndkce;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        DeleteServiceHelper.delete((String)TCCIT_DG_A100000_7_SUM, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{WSS_CURRENT, ZZQ_CURRENT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_dg_a100000_7_det");
        customParams.put("entrytype", this.geEntryType(itemtype));
        customParams.put("columnType", column);
        customParams.put("itemnumber", projects.get(this.getKey(itemtype, column)));
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(DkynssdeTZFormPlugin.class.getSimpleName(), Collections.singletonList(MbyqndksjsdgFormPlugin.class.getSimpleName()));
            }
        };
    }

    static {
        projects.put("1&wsscurrent", "80201");
        projects.put("1&zzqcurrent", "80202");
        projects.put("2&wsscurrent", "80201");
        projects.put("2&zzqcurrent", "80202");
        projects.put("5&hjjecurrent", "5&hjjecurrent");
        projects.put("9&wsscurrent", "80101");
        projects.put("9&zzqcurrent", "80102");
        projects.put("7&wsscurrent", "7&wsscurrent");
        projects.put("7&zzqcurrent", "7&zzqcurrent");
        projects.put("12&hjjecurrent", "12&hjjecurrent");
        projects.put("15&wsscurrent", "15&wsscurrent");
        projects.put("15&zzqcurrent", "15&zzqcurrent");
    }
}

