/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.common.enums.DraftSummaryEnum;
import kd.taxc.tccit.formplugin.account.AssetAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.DeductAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.IncomeAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.MsjjHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.QttzHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.account.ThinkOfSellFormPlugin;
import kd.taxc.tccit.formplugin.account.TssxHzdgSummaryPlugin;
import kd.taxc.tccit.formplugin.draft.AbstractSummaryPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A100000_1_DGFormPlugin;

public class DomesticAdjustFormPlugin
extends AbstractSummaryPlugin {
    private static final ArrayList<String> ARRAY_LIST = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7"});

    @Override
    public Object calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        BigDecimal result;
        ArrayList<QFilter> baseQfilters = this.getBaseQfilters(customParams);
        switch (rowType) {
            case "1": {
                QFilter itemtypeFilter = new QFilter("itemtype", "=", (Object)"003");
                baseQfilters.add(itemtypeFilter);
                result = this.getOne(rowType, columnType, "tccit_dg_a100000_1_sum", "amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "2": {
                QFilter filter = new QFilter("itemtype", "in", (Object)"11");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_dg_income_adjust", "amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "3": {
                QFilter filter = new QFilter("itemtype", "=", (Object)"31");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_dg_deduct_adjust", "amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "4": {
                result = this.getOne(rowType, columnType, "tccit_thinkofsell_summary", "sum(adjustamount) as adjustamount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "adjustamount");
                break;
            }
            case "5": {
                QFilter filter = new QFilter("itemtype", "=", (Object)"5");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_dg_asset_adjust", "sum(amount) as amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "6": {
                QFilter filter = new QFilter("itemtype", "=", (Object)"10");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_hzdg_tssxtz_sum", "sum(amount) as amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "7": {
                QFilter filter = new QFilter("itemtype", "=", (Object)"3");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_hzdg_qttz_sum", "sum(amount) as amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "8": {
                QFilter filter = new QFilter("itemtype", "=", (Object)"5");
                baseQfilters.add(filter);
                result = this.getOne(rowType, columnType, "tccit_hzdg_msjj_sum", "sum(amount) as amount", baseQfilters.toArray(new QFilter[baseQfilters.size()]), "amount");
                break;
            }
            case "9": {
                String key = DomesticAdjustFormPlugin.getKey("8", "amount");
                result = this.getSum(ARRAY_LIST, "amount").subtract(this.dataMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)this.dataMap.get(key));
                break;
            }
            default: {
                result = BigDecimal.ZERO;
            }
        }
        return result;
    }

    @Override
    public DraftSummaryEnum getDraftSummaryEnum() {
        return DraftSummaryEnum.DOMESTICADJUST;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, DraftSummaryEnum.DOMESTICADJUST.getBill());
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(DomesticAdjustFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{A100000_1_DGFormPlugin.class.getSimpleName(), IncomeAdjustFormPlugin.class.getSimpleName(), DeductAdjustFormPlugin.class.getSimpleName(), ThinkOfSellFormPlugin.class.getSimpleName(), AssetAdjustFormPlugin.class.getSimpleName(), TssxHzdgSummaryPlugin.class.getSimpleName(), QttzHzdgSummaryPlugin.class.getSimpleName(), MsjjHzdgSummaryPlugin.class.getSimpleName()}));
            }
        };
    }
}

