/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.SalaryTZFormPlugin;

public class EduLimitTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"zzje", "kcjsjsbt", "sjfsje", "yqndjz", "kcjs", "kcxejsbt", "gzxj", "kcbl", "kcxe", "nstzejsbt", "ssje", "tze", "jzyhndkce"});
    private static final Set<String> titles = Sets.newHashSet((Object[])new String[]{"kcjsjsbt", "kcxejsbt", "nstzejsbt"});
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String AMOUNT = "amount";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private static Map<String, String> projects = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemtype,amount";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_b105014_3_summary", (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (DynamicObject object : query) {
            String itemType = object.getString(ITEM_TYPE);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(rowIndex + 1));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)itemType);
            dot.getProperty(AMOUNT).setValueFast((Object)data, (Object)this.formatData(object.getBigDecimal(AMOUNT), itemType, AMOUNT));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private String formatData(BigDecimal data, String rowtype, String columnType) {
        if (titles.contains(rowtype)) {
            return "";
        }
        StringBuilder link = new StringBuilder("<nolink>");
        String text = data.setScale(2, 4).toString();
        if ("kcbl".equals(rowtype)) {
            return link.append(DataFormat.formatRate(data.setScale(0, 4).toString())).toString();
        }
        if (!"zzje".equals(rowtype) && !"sjfsje".equals(rowtype)) {
            return link.append(DataFormat.formatMicrometer(text)).toString();
        }
        return DataFormat.formatMicrometer(text);
    }

    private void calc(Map<String, Object> customParams) {
        this.dataMap.clear();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct3")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int itemNo = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_b105014_3_summary");
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(AMOUNT, (Object)this.calcAmount(itemType, AMOUNT, customParams));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_b105014_3_summary", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
    }

    private BigDecimal calcAmount(String rowType, String columnType, Map<String, Object> customParams) {
        if ("zzje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "zzje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("sjfsje".equals(rowType)) {
            BigDecimal amount = this.getAmount(customParams, columnType, "sjfsje");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("yqndjz".equals(rowType)) {
            String preYearSbbid = this.getPreYearSbbid(customParams);
            DynamicObject dynObj = QueryServiceHelper.queryOne((String)"tccit_qysds_a105050", (String)"zgjyjfzc", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)preYearSbbid), new QFilter("ewblxh", "=", (Object)"7")});
            BigDecimal amount = dynObj != null ? dynObj.getBigDecimal("zgjyjfzc") : BigDecimal.ZERO;
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("kcjs".equals(rowType)) {
            BigDecimal amount3 = this.dataMap.getOrDefault(this.getKey("sjfsje", columnType), BigDecimal.ZERO);
            BigDecimal amount4 = this.dataMap.getOrDefault(this.getKey("yqndjz", columnType), BigDecimal.ZERO);
            BigDecimal subtract = amount3.add(amount4);
            this.dataMap.put(this.getKey(rowType, columnType), subtract);
            return subtract;
        }
        if ("gzxj".equals(rowType)) {
            Long orgid = Long.parseLong((String)customParams.get("orgid"));
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"salarystock");
            QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
            DynamicObject dynObj = QueryServiceHelper.queryOne((String)"tccit_salary_summary", (String)"taxamount", (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
            BigDecimal amount = dynObj != null ? dynObj.getBigDecimal("taxamount") : BigDecimal.ZERO;
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("kcbl".equals(rowType)) {
            BigDecimal rate = this.getRate(customParams);
            this.dataMap.put(this.getKey(rowType, columnType), rate);
            return rate;
        }
        if ("kcxe".equals(rowType)) {
            BigDecimal gzxj = this.dataMap.getOrDefault(this.getKey("gzxj", columnType), BigDecimal.ZERO);
            BigDecimal kcbl = this.dataMap.getOrDefault(this.getKey("kcbl", columnType), BigDecimal.ZERO);
            BigDecimal amount = gzxj.multiply(kcbl).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("ssje".equals(rowType)) {
            BigDecimal kcxe;
            BigDecimal kcjs = this.dataMap.getOrDefault(this.getKey("kcjs", columnType), BigDecimal.ZERO);
            BigDecimal addAmount = kcjs.compareTo(kcxe = this.dataMap.getOrDefault(this.getKey("kcxe", columnType), BigDecimal.ZERO)) > 0 ? kcxe : kcjs;
            this.dataMap.put(this.getKey(rowType, columnType), addAmount);
            return addAmount;
        }
        if ("tze".equals(rowType)) {
            BigDecimal zzje = this.dataMap.getOrDefault(this.getKey("zzje", columnType), BigDecimal.ZERO);
            BigDecimal ssje = this.dataMap.getOrDefault(this.getKey("ssje", columnType), BigDecimal.ZERO);
            BigDecimal tze = zzje.subtract(ssje);
            this.dataMap.put(this.getKey(rowType, columnType), tze);
            return tze;
        }
        if ("jzyhndkce".equals(rowType)) {
            BigDecimal kcjs = this.dataMap.getOrDefault(this.getKey("kcjs", columnType), BigDecimal.ZERO);
            BigDecimal ssje = this.dataMap.getOrDefault(this.getKey("ssje", columnType), BigDecimal.ZERO);
            BigDecimal jzyhndkce = kcjs.subtract(ssje);
            this.dataMap.put(this.getKey(rowType, columnType), jzyhndkce);
            return jzyhndkce;
        }
        this.dataMap.put(this.getKey(rowType, columnType), BigDecimal.ZERO);
        return BigDecimal.ZERO;
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String columnType, String entrytype) {
        String itemnumber = projects.get(columnType);
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, null, "tccit_edu_limit_tz_detail");
    }

    private BigDecimal getRate(Map<String, Object> customParams) {
        String skssqz;
        String skssqq;
        String orgId = String.valueOf(customParams.get("orgid"));
        List deductionRateList = AssistService.queryAssistParams((String)"ZGJYJFXEKC", (String)orgId, (String)(skssqq = String.valueOf(customParams.get("skssqq"))), (String)(skssqz = String.valueOf(customParams.get("skssqz"))));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    private String getPreYearSbbid(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        return YbnsrService.queryYbnsrPre((String)orgid, (String)"qysdsnb", (String)skssqq, (String)skssqz, (int)-12);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue(ITEM_TYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", itemtype);
        customParams.put("itemnumber", projects.get(evt.getFieldName()));
        customParams.put("entryname", "tccit_edu_limit_tz_detail");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{AMOUNT});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString(ITEM_TYPE);
        customParams.put("entryname", "tccit_edu_limit_tz_detail");
        customParams.put("entrytype", itemtype);
        customParams.put("columnType", column);
        customParams.put("itemnumber", projects.get(column));
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(EduLimitTZFormPlugin.class.getSimpleName(), Collections.singletonList(SalaryTZFormPlugin.class.getSimpleName()));
            }
        };
    }

    static {
        projects.put(AMOUNT, "3010106");
    }
}

