/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public class FgyxjzzcFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String NAME = "name";
    public static final String ZZJE = "zzje";
    public static final String SSJE = "ssje";
    public static final String NSTZ = "nstz";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String RULEID = "ruleid";
    public static final String TCCIT_B105019_SUM = "tccit_dg_b105019_sum";
    private Set<String> itemtypes = Sets.newHashSet((Object[])new String[]{"3010403"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = "itemno,name,ruleid,zzje,ssje,nstz";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_B105019_SUM, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(RULEID).setValueFast((Object)data, (Object)dynamicObject.getLong(RULEID));
            dot.getProperty(NAME).setValueFast((Object)data, (Object)dynamicObject.getString(NAME));
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(ZZJE)));
            dot.getProperty(SSJE).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(SSJE)));
            dot.getProperty(NSTZ).setValueFast((Object)data, (Object)this.formatData(dynamicObject.getBigDecimal(NSTZ)));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue(RULEID, (Object)0L, rowIndex);
        model.setValue(NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FgyxjzzcFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(ZZJE, (Object)("<nolink>" + this.formatData(this.getSum(query, ZZJE))), rowIndex);
        model.setValue(SSJE, (Object)this.formatData(this.getSum(query, SSJE)), rowIndex);
        model.setValue(NSTZ, (Object)this.formatData(this.getSum(query, NSTZ)), rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    private DynamicObjectCollection calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("deduct11")) {
            return null;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.REMAJUST);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && this.itemtypes.contains(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        int index = 0;
        for (DynamicObject dynamicObject : sellRuleList) {
            DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_B105019_SUM);
            dynamicObject2.set(ITEM_NO, (Object)(++index));
            dynamicObject2.set(NAME, (Object)dynamicObject.getString(NAME));
            dynamicObject2.set(RULEID, (Object)dynamicObject.getLong("id"));
            BigDecimal zzje = this.getAmount(customParams, ZZJE, dynamicObject.getString("id"));
            dynamicObject2.set(ZZJE, (Object)zzje);
            dynamicObject2.set(SSJE, (Object)BigDecimal.valueOf(0.0));
            dynamicObject2.set(NSTZ, (Object)zzje);
            dynamicObject2.set(ORGID, (Object)orgid);
            dynamicObject2.set(SKSSQQ, (Object)skssqq);
            dynamicObject2.set(SKSSQZ, (Object)skssqz);
            sum.add((Object)dynamicObject2);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return sum;
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_B105019_SUM, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), "tccit_dg_b105019_det");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entrytype", ZZJE);
        customParams.put("columnType", evt.getFieldName());
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", "tccit_dg_b105019_det");
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", "tccit_dg_b105019_det");
        customParams.put("entrytype", ZZJE);
        customParams.put("columnType", column);
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

