/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public class FhmstjdtzsyFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DG_B105037_SUM = "tccit_dg_b105037_sum";
    public static final String TCCIT_INVEST_DISPOSE = "tccit_invest_cysy";
    public static final String TCCIT_NEW_INVEST_ASSET = "tccit_new_invest_asset";
    public static final String ITEM_NO = "itemno";
    private static Map<String, String> projects = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void calc(Map<String, Object> customParams) {
        QFilter swqrsrFilter;
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter deleteOrgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105037_SUM, (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter});
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("yhsx3")) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter sfsjmsFilter = new QFilter("entryentity.sfsjms", "in", (Object)"1");
        String selectFiles = " * ,name,investtype,entryentity.mssrje,entryentity.bizdate,entryentity.cysytype";
        QFilter skssqqFilter = new QFilter("entryentity.bizdate", ">=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("entryentity.bizdate", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        DynamicObjectCollection investDisposes = QueryServiceHelper.query((String)TCCIT_INVEST_DISPOSE, (String)selectFiles, (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, sfsjmsFilter, swqrsrFilter = new QFilter("entryentity.swkjqrsr", "in", (Object)"2")});
        if (CollectionUtils.isEmpty((Collection)investDisposes)) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        int j = 1;
        for (int i = 0; i < investDisposes.size(); ++i) {
            DynamicObject sourceObject = (DynamicObject)investDisposes.get(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_DG_B105037_SUM);
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set("billno", sourceObject.get("billno"));
            dynamicObject.set("tzbdname", BusinessDataServiceHelper.loadSingle((Object)sourceObject.get("name"), (String)"tccit_new_invest_asset_bs", (String)"name").get("name"));
            Object investtype = sourceObject.get("investtype");
            dynamicObject.set("investtype", BusinessDataServiceHelper.loadSingle((Object)investtype, (String)"tpo_tccit_bizdef_entry", (String)"projectname").get("projectname"));
            QFilter billnoFilter = new QFilter("billno", "=", sourceObject.get("billno"));
            dynamicObject.set("mssrje", sourceObject.get("entryentity.mssrje"));
            dynamicObject.set("cysytype", (Object)projects.get(sourceObject.get("entryentity.cysytype")));
            dynamicObject.set("qddbtzzc", dynamicObject.get("mssrje"));
            DynamicObjectCollection investAssets = QueryServiceHelper.query((String)TCCIT_NEW_INVEST_ASSET, (String)"taxpayerid,tccit_new_invest_detail.taxbase,tccit_new_invest_detail.tzbl", (QFilter[])new QFilter[]{orgFilter, billnoFilter});
            dynamicObject.set("taxpayerid", ((DynamicObject)investAssets.get(0)).get("taxpayerid"));
            BigDecimal incost = this.getSum(investAssets, "tccit_new_invest_detail.taxbase");
            dynamicObject.set("incost", (Object)incost);
            BigDecimal numorrate = this.getSum(investAssets, "tccit_new_invest_detail.tzbl");
            dynamicObject.set("numorrate", (Object)numorrate);
            dynamicObject.set("bizdate", sourceObject.get("entryentity.bizdate"));
            if (!(investtype.equals(1057197557899680777L) || investtype.equals(1057197557899680778L) || investtype.equals(1057197557899680779L))) {
                dynamicObject.set("label", (Object)j);
                ++j;
            }
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = " * ";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_DG_B105037_SUM, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_NO);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, dynamicObject.get(ITEM_NO));
            dot.getProperty("billno").setValueFast((Object)data, dynamicObject.get("billno"));
            dot.getProperty("tzbdname").setValueFast((Object)data, dynamicObject.get("tzbdname"));
            dot.getProperty("investtype").setValueFast((Object)data, dynamicObject.get("investtype"));
            dot.getProperty("cysytype").setValueFast((Object)data, dynamicObject.get("cysytype"));
            dot.getProperty("mssrje").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("mssrje")));
            dot.getProperty("tzssyhje").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("tzssyhje")));
            dot.getProperty("qddbtzzc").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("qddbtzzc")));
            dot.getProperty("taxpayerid").setValueFast((Object)data, dynamicObject.get("taxpayerid"));
            dot.getProperty("incost").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("incost")));
            dot.getProperty("numorrate").setValueFast((Object)data, (Object)this.getFormatData(dynamicObject.getBigDecimal("numorrate")));
            dot.getProperty("bizdate").setValueFast((Object)data, (Object)DateUtils.format((Date)dynamicObject.getDate("bizdate")));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue("billno", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FhmstjdtzsyFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("tzbdname", (Object)"*", rowIndex);
        model.setValue("investtype", (Object)"*", rowIndex);
        model.setValue("cysytype", (Object)"*", rowIndex);
        model.setValue("mssrje", (Object)this.getFormatData(this.getSum(query, "mssrje")), rowIndex);
        model.setValue("tzssyhje", (Object)this.getFormatData(this.getSum(query, "tzssyhje")), rowIndex);
        model.setValue("qddbtzzc", (Object)this.getFormatData(this.getSum(query, "qddbtzzc")), rowIndex);
        model.setValue("taxpayerid", (Object)"*", rowIndex);
        model.setValue("incost", (Object)this.getFormatData(this.getSum(query, "incost")), rowIndex);
        model.setValue("numorrate", (Object)this.getFormatData(this.getSum(query, "numorrate")), rowIndex);
        model.setValue("bizdate", (Object)"*", rowIndex);
    }

    private String getFormatData(BigDecimal data) {
        return DataFormat.formatMicrometer(data.setScale(2, 4).toString());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter deleteOrgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_DG_B105037_SUM, (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter});
    }

    static {
        projects.put("1", ResManager.loadKDString((String)"\u80a1\u606f\u7ea2\u5229", (String)"FhmstjdtzsyFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        projects.put("2", ResManager.loadKDString((String)"\u5408\u4f19\u4f01\u4e1a\u5206\u914d\u6536\u5165", (String)"FhmstjdtzsyFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        projects.put("3", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FhmstjdtzsyFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
    }
}

