/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.HznsqySeftSummaryPlugin;

public class FzjgSeftSummaryPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ITEMNO = "itemno";
    private static final String AMOUNT = "amount";
    private static final String ORGID = "orgid";
    private static final String TCCIT_SEFT_FZJG_SUMMARY = "tccit_seft_fzjg_summary";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TCCIT_QYSDS_FZJGXX = "tccit_qysds_fzjgxx_dyn";
    private static final String TCCIT_SEFT_HZNSQY_SUMMARY = "tccit_seft_hznsqy_summary";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.buildForm();
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private void buildForm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DynamicObject summary = QueryServiceHelper.queryOne((String)TCCIT_SEFT_FZJG_SUMMARY, (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (summary == null) {
            return;
        }
        DynamicObjectCollection query = (summary = BusinessDataServiceHelper.loadSingle((Object)summary.get("id"), (String)TCCIT_SEFT_FZJG_SUMMARY)).getDynamicObjectCollection(ENTRYENTITY);
        if (query.size() > 0) {
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            model.batchCreateNewEntryRow(ENTRYENTITY, query.size());
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
            DynamicObjectType dot = entryEntity.getDynamicObjectType();
            model.setValue("fzjgdydynssdse", summary.get("fzjgdydynssdse"));
            model.setValue("ynssdse", summary.get("ynssdse"));
            int rowIndex = 0;
            for (DynamicObject object : query) {
                DynamicObject data = (DynamicObject)entryEntity.get(rowIndex);
                dot.getProperty(ITEMNO).setValueFast((Object)data, (Object)(rowIndex + 1 + ""));
                dot.getProperty("yysr").setValueFast((Object)data, object.get("yysr"));
                dot.getProperty("zgxc").setValueFast((Object)data, object.get("zgxc"));
                dot.getProperty("zcze").setValueFast((Object)data, object.get("zcze"));
                dot.getProperty("fpbl").setValueFast((Object)data, object.get("fpbl"));
                dot.getProperty("fpsdse").setValueFast((Object)data, object.get("fpsdse"));
                dot.getProperty("tyshxydm").setValueFast((Object)data, object.get("tyshxydm"));
                dot.getProperty("fzjgmc").setValueFast((Object)data, object.get("fzjgmc"));
                ++rowIndex;
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        Object yjLastSbbid = this.getYjLastSbbid((String)customParams.get(ORGID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ));
        DraftService.clearCurrentPeriod(TCCIT_SEFT_FZJG_SUMMARY, orgid, skssqq, skssqz);
        if (yjLastSbbid != null) {
            QFilter qFilter = new QFilter("fzjgmc", "!=", (Object)"0").and("fzjgmc", "!=", (Object)" ").and("sbbid", "=", (Object)String.valueOf(yjLastSbbid));
            DynamicObjectCollection fzobjs = QueryServiceHelper.query((String)TCCIT_QYSDS_FZJGXX, (String)"id,ewblxh,ewblname,sbbid,fzjgnsrsbh,fzjgmc,fzjgsrze,fzjggzze,fzjgzcze,fpbl,fpse,rownumber,xsmzdfjmfd,xsmzdfyhje,fzjgxsqyxyhqk", (QFilter[])qFilter.toArray());
            QFilter filter = QFilter.of((String)"org.id = ? and period >= ? and period <= ? and declaration = ?", (Object[])new Object[]{orgid, skssqq, skssqz, "2"});
            DynamicObject rate = QueryServiceHelper.queryOne((String)"tccit_branch_share_bill", (String)"sharerate,participation", (QFilter[])new QFilter[]{filter});
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_SEFT_FZJG_SUMMARY);
            summary.set(ORGID, (Object)orgid);
            summary.set(SKSSQQ, (Object)skssqq);
            summary.set(SKSSQZ, (Object)skssqz);
            BigDecimal fzjgdydYnsdse = this.getFzjgdydYnsdse(orgid, skssqq, skssqz);
            summary.set("fzjgdydynssdse", (Object)fzjgdydYnsdse);
            BigDecimal ynssdse = this.getFzjgdydYnsdse(orgid, skssqq, skssqz, new BigDecimal("1"));
            summary.set("ynssdse", (Object)ynssdse);
            DynamicObjectCollection sum = summary.getDynamicObjectCollection(ENTRYENTITY);
            int index = 0;
            String fzjgmc = ResManager.loadKDString((String)"\uff08\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8\uff09", (String)"FzjgSeftSummaryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            int size = fzobjs.size();
            BigDecimal ftseSum = BigDecimal.ZERO;
            for (DynamicObject item : fzobjs) {
                DynamicObject dynamicObject = sum.addNew();
                dynamicObject.set("fzjgmc", item.get("fzjgmc"));
                dynamicObject.set("tyshxydm", item.get("fzjgnsrsbh"));
                dynamicObject.set("yysr", item.get("fzjgsrze"));
                dynamicObject.set("zgxc", item.get("fzjggzze"));
                dynamicObject.set("zcze", item.get("fzjgzcze"));
                dynamicObject.set("fpbl", item.get("fpbl"));
                BigDecimal multiply = Objects.nonNull(rate) && rate.getBoolean("participation") ? ynssdse.multiply(item.get("fpbl") == null ? BigDecimal.ZERO : item.getBigDecimal("fpbl")).setScale(2, 4) : fzjgdydYnsdse.multiply(item.get("fpbl") == null ? BigDecimal.ZERO : item.getBigDecimal("fpbl")).setScale(2, 4);
                dynamicObject.set("fpsdse", (Object)multiply);
                if (item.getString("fzjgmc") != null && item.getString("fzjgmc").contains(fzjgmc)) {
                    this.updateZjgRow3d(dynamicObject.getBigDecimal("fpsdse"), customParams);
                }
                dynamicObject.set(ITEMNO, (Object)(index + 1 + ""));
                if (size - 1 == index) {
                    dynamicObject.set("fpsdse", (Object)fzjgdydYnsdse.subtract(ftseSum));
                } else {
                    ftseSum = multiply.add(ftseSum);
                }
                ++index;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{summary});
        }
    }

    private BigDecimal getFzjgdydYnsdse(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter qFilter = new QFilter("itemtype", "=", (Object)"3c");
        DynamicObject hznsqy_summary = QueryServiceHelper.queryOne((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)"itemtype,id,amount", (QFilter[])new QFilter[]{orgFilter, dateFilter, qFilter});
        return Objects.isNull(hznsqy_summary) ? BigDecimal.ZERO : hznsqy_summary.getBigDecimal(AMOUNT);
    }

    private BigDecimal getFzjgdydYnsdse(Long orgid, Date skssqq, Date skssqz, BigDecimal rate) {
        BigDecimal amount = BigDecimal.ZERO;
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter qFilter = new QFilter("itemtype", "=", (Object)"3");
        DynamicObject hznsqy_summary = QueryServiceHelper.queryOne((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)"itemtype,id,amount", (QFilter[])new QFilter[]{orgFilter, dateFilter, qFilter});
        if (hznsqy_summary != null) {
            amount = hznsqy_summary.getBigDecimal(AMOUNT).multiply(rate).setScale(2, 4);
        }
        return amount;
    }

    private void updateZjgRow3d(BigDecimal fpsdse, Map<String, Object> customParams) {
        ArrayList<QFilter> qfilters = DraftService.getQfilters(customParams);
        Object[] ids = QueryServiceHelper.query((String)TCCIT_SEFT_HZNSQY_SUMMARY, (String)"id", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()])).stream().map(s -> s.getLong("id")).toArray();
        DynamicObject[] zjgSummarys = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCCIT_SEFT_HZNSQY_SUMMARY));
        if (zjgSummarys != null && zjgSummarys.length > 0) {
            Map<String, DynamicObject> collect = Arrays.stream(zjgSummarys).collect(Collectors.toMap(a -> a.getString("itemtype"), b -> b, (m, n) -> n));
            DynamicObject object = collect.get("3d");
            if (object != null) {
                object.set(AMOUNT, (Object)fpsdse);
            }
            BigDecimal amount3a = collect.get("3a") == null ? BigDecimal.ZERO : collect.get("3a").getBigDecimal(AMOUNT);
            BigDecimal amount3b = collect.get("3b") == null ? BigDecimal.ZERO : collect.get("3b").getBigDecimal(AMOUNT);
            BigDecimal amount3d = collect.get("3d") == null ? BigDecimal.ZERO : collect.get("3d").getBigDecimal(AMOUNT);
            BigDecimal amount4 = collect.get("4") == null ? BigDecimal.ZERO : collect.get("4").getBigDecimal(AMOUNT);
            collect.get("5").set(AMOUNT, (Object)amount3a.add(amount3d).add(amount3b).add(amount4));
            SaveServiceHelper.save((DynamicObject[])zjgSummarys);
        }
    }

    private Object getYjLastSbbid(String orgid, String skssqq, String skssqz) {
        String taxLimit = TaxBaseDataUtils.getTaxLimit((String)"qysds", (Long)Long.valueOf(orgid));
        Date start = DateUtils.stringToDate((String)skssqq);
        Date end = DateUtils.stringToDate((String)skssqz);
        if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"ajsb")) {
            start = DateUtils.getFirstDateOfSeason((Date)end);
        } else if (StringUtil.equals((CharSequence)taxLimit, (CharSequence)"aysb")) {
            start = DateUtils.getFirstDateOfMonth((Date)end);
        }
        DynamicObject dynamicObject = YbnsrService.queryYbnsr((String)orgid, (String)"qysdsjb", (String)DateUtils.format((Date)start), (String)skssqz, null);
        return dynamicObject == null ? null : dynamicObject.get("id");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        DraftService.clearCurrentPeriod(TCCIT_SEFT_FZJG_SUMMARY, orgid, skssqq, skssqz);
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(FzjgSeftSummaryPlugin.class.getSimpleName(), Collections.singletonList(HznsqySeftSummaryPlugin.class.getSimpleName()));
            }
        };
    }
}

