/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DomesticAdjustFormPlugin;
import kd.taxc.tccit.formplugin.account.SonGetReduceFormPlugin;

public class GetReduceFormPlugin
extends AbstractEngine
implements Observer {
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_NAME = "itemname";
    public static final String ITEM_TYPE = "itemtype";
    public static final String MONEY = "money";
    public static final String ORGID = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private String formatData(BigDecimal data) {
        String text = data.setScale(2, 4).toString();
        return DataFormat.formatMicrometer(text);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        QFilter deleteOrgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_dg_a100000_4_sum", (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter});
        BigDecimal xmsde = BigDecimal.ZERO;
        if (policy.getBoolean("yhsx1")) {
            DynamicObjectCollection teckCalc = this.getSonGetReduceSum(orgid, skssqq, skssqz, "B105050");
            xmsde = teckCalc.stream().map(a -> a.getBigDecimal("xmsde")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal teckXmsde = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(xmsde) < 0) {
            BigDecimal subtract = xmsde.subtract(BigDecimal.valueOf(5000000L));
            teckXmsde = subtract.compareTo(BigDecimal.ZERO) <= 0 ? xmsde : subtract.multiply(BigDecimal.valueOf(0.5)).add(BigDecimal.valueOf(5000000L));
        }
        BigDecimal totalPrice = BigDecimal.ZERO;
        if (policy.getBoolean("yhsx2")) {
            DynamicObjectCollection teckCalc = this.getSonGetReduceSum(orgid, skssqq, skssqz, "B105051");
            totalPrice = teckCalc.stream().map(a -> a.getBigDecimal("jmsde")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tccit_dg_a100000_4_sum");
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"9");
        DynamicObject domesticAdjust = QueryServiceHelper.queryOne((String)"tccit_domestic_adjust", (String)"amount", (QFilter[])new QFilter[]{deleteOrgFilter, dateFilter, itemtypeFilter});
        BigDecimal amount = null == domesticAdjust ? BigDecimal.ZERO : domesticAdjust.getBigDecimal("amount");
        dynamicObject.set("nstzhsd", (Object)amount);
        BigDecimal sum = teckXmsde.add(totalPrice);
        BigDecimal jsdjm = amount.compareTo(sum) > 0 ? sum : amount;
        dynamicObject.set("jsdjm", (Object)(jsdjm.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : jsdjm));
        dynamicObject.set("jszrxmsdjm", (Object)teckXmsde);
        dynamicObject.set("qtxmsdjm", (Object)totalPrice);
        dynamicObject.set("lmhjnsd", (Object)amount.subtract(dynamicObject.getBigDecimal("jsdjm")));
        dynamicObject.set(ORGID, (Object)orgid);
        dynamicObject.set(SKSSQQ, (Object)skssqq);
        dynamicObject.set(SKSSQZ, (Object)skssqz);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get(ORGID));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        String selectFields = " * ";
        DynamicObject query = QueryServiceHelper.queryOne((String)"tccit_dg_a100000_4_sum", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", 5);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        String name = "";
        String money = "";
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                name = ResManager.loadKDString((String)"\u7eb3\u7a0e\u8c03\u6574\u540e\u6240\u5f97", (String)"GetReduceFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
                money = this.formatData(query.getBigDecimal("nstzhsd"));
            }
            if (i == 1) {
                name = ResManager.loadKDString((String)"\u51cf\uff1a\u6240\u5f97\u51cf\u514d", (String)"GetReduceFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
                money = this.formatData(query.getBigDecimal("jsdjm"));
            }
            if (i == 2) {
                name = ResManager.loadKDString((String)"\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u6240\u5f97\u51cf\u514d", (String)"GetReduceFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
                money = this.formatData(query.getBigDecimal("jszrxmsdjm"));
            }
            if (i == 3) {
                name = ResManager.loadKDString((String)"\u5176\u4ed6\u9879\u76ee\u6240\u5f97\u51cf\u514d", (String)"GetReduceFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]);
                money = this.formatData(query.getBigDecimal("qtxmsdjm"));
            }
            if (i == 4) {
                name = ResManager.loadKDString((String)"\u51cf\u514d\u540e\u5883\u5185\u6240\u5f97", (String)"GetReduceFormPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]);
                money = this.formatData(query.getBigDecimal("lmhjnsd"));
            }
            DynamicObject data = (DynamicObject)entryentity.get(i);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)(i + 1));
            dot.getProperty(ITEM_NAME).setValueFast((Object)data, (Object)name);
            dot.getProperty(MONEY).setValueFast((Object)data, (Object)money);
        }
        this.getView().updateView("entryentity");
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_dg_a100000_4_sum", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    private DynamicObjectCollection getSonGetReduceSum(Long orgid, Date skssqq, Date skssqz, String sheetname) {
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter sheetFilter = new QFilter("sheetname", "=", (Object)sheetname);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_getredu_sum", (String)"xmsde,jmsde", (QFilter[])new QFilter[]{orgFilter, dateFilter, sheetFilter});
        return query;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(GetReduceFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{DomesticAdjustFormPlugin.class.getSimpleName(), SonGetReduceFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

