/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.draft.OpenDraftService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class HhqyhhrTZFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String TCCIT_HHQYHHR_SUMMARY = "tccit_hhqyhhr_summary";
    public static final String TCCIT_HHQYHHR_DETAIL = "tccit_hhqyhhr_tz_detail";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_NAME = "itemname";
    public static final String ZZJE = "zzje";
    public static final String SSJE = "ssje";
    public static final String NSTZJE = "nstzje";
    public static final String ITEMNUMBER = "80101";
    public static final String RULEID = "ruleid";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemname,zzje,ssje,nstzje,ruleid";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_HHQYHHR_SUMMARY, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"itemno asc");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            String itemName = dynamicObject.getString(ITEM_NAME);
            dot.getProperty(ITEM_NAME).setValueFast((Object)data, (Object)itemName);
            dot.getProperty(ZZJE).setValueFast((Object)data, (Object)DataFormat.formatMicrometer(dynamicObject.getBigDecimal(ZZJE).setScale(2, 4).toString()));
            dot.getProperty(SSJE).setValueFast((Object)data, (Object)DataFormat.formatMicrometer(dynamicObject.getBigDecimal(SSJE).setScale(2, 4).toString()));
            dot.getProperty(NSTZJE).setValueFast((Object)data, (Object)dynamicObject.getBigDecimal(NSTZJE));
            dot.getProperty(RULEID).setValueFast((Object)data, (Object)dynamicObject.getLong(RULEID));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
        this.appendCountRow(query, model, rowIndex);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)(query.size() + 1), rowIndex);
        model.setValue(ITEM_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"HhqyhhrTZFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(ZZJE, (Object)("<nolink>" + DataFormat.formatMicrometer(this.getSum(query, ZZJE).setScale(2, 4).toString())), rowIndex);
        model.setValue(SSJE, (Object)("<nolink>" + DataFormat.formatMicrometer(this.getSum(query, SSJE).setScale(2, 4).toString())), rowIndex);
        model.setValue(NSTZJE, (Object)this.getSum(query, NSTZJE), rowIndex);
        model.setValue(RULEID, (Object)0L, rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("tssx1")) {
            return;
        }
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.TSSX);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && ITEMNUMBER.equals(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (int i = 0; i < sellRuleList.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_HHQYHHR_SUMMARY);
            dynamicObject.set(ITEM_NO, (Object)(i + 1));
            dynamicObject.set(RULEID, (Object)((DynamicObject)sellRuleList.get(i)).getLong("id"));
            dynamicObject.set(ITEM_NAME, (Object)((DynamicObject)sellRuleList.get(i)).getString("name"));
            BigDecimal zzje = this.getAmount(customParams, ZZJE, ((DynamicObject)sellRuleList.get(i)).getString("id"));
            dynamicObject.set(ZZJE, (Object)zzje);
            BigDecimal ssje = this.getAmount(customParams, SSJE, ((DynamicObject)sellRuleList.get(i)).getString("id"));
            dynamicObject.set(SSJE, (Object)ssje);
            dynamicObject.set(NSTZJE, (Object)ssje.subtract(zzje).setScale(2, 4));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        OpenDraftService.getPolicyCustomer(customParams);
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private BigDecimal getAmount(Map<String, Object> customParams, String entrytype, String ruleid) {
        return this.getCellAmount(customParams, null, entrytype, null, null, Long.valueOf(ruleid), TCCIT_HHQYHHR_DETAIL);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = String.valueOf(itemsEntity.getModel().getValue(RULEID));
        customParams.put("columnType", evt.getFieldName());
        customParams.put("entrytype", evt.getFieldName());
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        customParams.put("entryname", TCCIT_HHQYHHR_DETAIL);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)TCCIT_HHQYHHR_SUMMARY, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{ZZJE, SSJE});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruleid = row.getString(RULEID);
        customParams.put("entryname", TCCIT_HHQYHHR_DETAIL);
        customParams.put("entrytype", column);
        customParams.put("columnType", column);
        customParams.put(RULEID, ruleid);
        customParams.put("itemnumber", ruleid);
        return customParams;
    }
}

