/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.account;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import kd.taxc.tccit.formplugin.account.DkynssdeTZFormPlugin;

public class HighTechFormPlugin
extends AbstractEngine
implements HyperLinkClickListener,
Observer {
    private static final String ENTITY_NAME = "entryentity";
    private static final String DG_NAME = "tccit_dg_a301010200_sum";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String SDE = "sde";
    private static final String RATE = "rate";
    private static final String JMSE = "jmse";
    public static final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"1", "2"});

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTITY_NAME);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        Boolean isshanghai = "true".equals(customParams.get("isshanghai"));
        if (isshanghai.booleanValue()) {
            String declarediff = (String)customParams.get("declarediff");
            Integer diff = StringUtil.isBlank((CharSequence)declarediff) ? 0 : Integer.parseInt(declarediff);
            if (diff > 4 || diff < 0) {
                if (d.getInt("seq") == 1 && RATE.equals(columnDesc.getKey())) {
                    BigDecimal multiply = d.getBigDecimal(RATE).multiply(new BigDecimal("100")).setScale(2, 4);
                    e.setFormatValue((Object)(multiply.toString() + "%"));
                }
                if (d.getInt("seq") == 2 && Lists.newArrayList((Object[])new String[]{SDE, RATE, JMSE}).contains(columnDesc.getKey())) {
                    e.setFormatValue((Object)"\u2014\u2014");
                }
            } else if (diff >= 0 && diff <= 1) {
                if (RATE.equals(columnDesc.getKey())) {
                    BigDecimal multiply = d.getBigDecimal(RATE).multiply(new BigDecimal("100")).setScale(2, 4);
                    e.setFormatValue((Object)(multiply.toString() + "%"));
                }
            } else if (diff > 1 && diff <= 4 && RATE.equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal(RATE).multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)(multiply.toString() + "%"));
            }
        } else {
            if (d.getInt("seq") == 1 && RATE.equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal(RATE).multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)(multiply.toString() + "%"));
            }
            if (d.getInt("seq") == 2 && Lists.newArrayList((Object[])new String[]{SDE, RATE, JMSE}).contains(columnDesc.getKey())) {
                e.setFormatValue((Object)"\u2014\u2014");
            }
        }
        if (d.getInt("seq") == 3 && RATE.equals(columnDesc.getKey())) {
            e.setFormatValue((Object)"\u2014\u2014");
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    private void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)DG_NAME, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        DynamicObjectCollection sum = new DynamicObjectCollection();
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(orgid);
        List<DynamicObject> list = ApitudeService.findSuitOneCard(apitudeEntryEntity, skssqq, skssqz);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int itemNo = 0;
        for (String itemType : itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DG_NAME);
            dynamicObject.set(ITEM_NO, (Object)(++itemNo));
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            BigDecimal sde = this.getAmount(customParams, list, itemType, SDE);
            dynamicObject.set(SDE, (Object)sde);
            BigDecimal rate = this.getAmount(customParams, list, itemType, RATE);
            dynamicObject.set(RATE, (Object)rate);
            dynamicObject.set(JMSE, (Object)sde.multiply(rate));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            sum.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private BigDecimal getAmount(Map<String, Object> customParams, List<DynamicObject> list, String row, String column) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        int declareYear = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)skssqq));
        Boolean isshanghai = Boolean.FALSE;
        if (list != null && list.size() > 0) {
            isshanghai = list.stream().anyMatch(s -> "HT002".equals(s.getDynamicObject("companytype").getString("number")));
        }
        customParams.put("isshanghai", isshanghai.toString());
        if (isshanghai.booleanValue()) {
            DynamicObject suitOne = list.stream().filter(s -> s.getDynamicObject("companytype").getString("number").equals("HT002")).min(Comparator.comparing(s -> s.getInt("profitmyear"))).get();
            Integer profitmYear = Integer.valueOf(suitOne.getString("profitmyear"));
            Integer diff = declareYear - profitmYear;
            customParams.put("declarediff", String.valueOf(diff));
            if (diff < 0 || diff > 4) {
                if ("1".equals(row)) {
                    if (SDE.equals(column)) {
                        return this.getdkynssde(customParams);
                    }
                    if (RATE.equals(column)) {
                        BigDecimal gxjsqysl = this.getRate(orgid, "GXJSQYSL", skssqq, skssqz);
                        BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                        return sysl.subtract(gxjsqysl).divide(new BigDecimal("100"), 4, 4);
                    }
                }
                if ("2".equals(row)) {
                    return BigDecimal.ZERO;
                }
            } else if (diff == 0 || diff == 1) {
                if ("1".equals(row)) {
                    if (SDE.equals(column)) {
                        return this.getdkynssde(customParams);
                    }
                    if (RATE.equals(column)) {
                        BigDecimal gxjsqysl = this.getRate(orgid, "GXJSQYSL", skssqq, skssqz);
                        BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                        return sysl.subtract(gxjsqysl).divide(new BigDecimal("100"), 4, 4);
                    }
                }
                if ("2".equals(row)) {
                    if (SDE.equals(column)) {
                        return this.getdkynssde(customParams);
                    }
                    if (RATE.equals(column)) {
                        BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                        return sysl.divide(new BigDecimal("100"), 4, 4);
                    }
                }
            } else if (diff > 1 && diff <= 4) {
                if ("1".equals(row)) {
                    if (SDE.equals(column)) {
                        return BigDecimal.ZERO;
                    }
                    if (RATE.equals(column)) {
                        BigDecimal gxjsqysl = this.getRate(orgid, "GXJSQYSL", skssqq, skssqz);
                        BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                        return sysl.subtract(gxjsqysl).divide(new BigDecimal("100"), 4, 4);
                    }
                }
                if ("2".equals(row)) {
                    if (SDE.equals(column)) {
                        return this.getdkynssde(customParams);
                    }
                    if (RATE.equals(column)) {
                        BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                        return sysl.divide(new BigDecimal("200"), 4, 4);
                    }
                }
            }
        } else {
            if ("1".equals(row)) {
                if (SDE.equals(column)) {
                    return this.getdkynssde(customParams);
                }
                if (RATE.equals(column)) {
                    BigDecimal gxjsqysl = this.getRate(orgid, "GXJSQYSL", skssqq, skssqz);
                    BigDecimal sysl = this.getRate(orgid, "SYSL", skssqq, skssqz);
                    return sysl.subtract(gxjsqysl).divide(new BigDecimal("100"), 4, 4);
                }
            }
            if ("2".equals(row)) {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getdkynssde(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"0");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_a100000_7_sum", (String)"zzqcurrent", (QFilter[])new QFilter[]{orgFilter, dateFilter, itemtypeFilter}, (String)"id");
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("zzqcurrent");
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "in", itemTypes);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        String selectFields = "itemno,itemtype,sde,rate,jmse";
        DynamicObjectCollection query = QueryServiceHelper.query((String)DG_NAME, (String)selectFields, (QFilter[])new QFilter[]{itemtypeFilter, orgFilter, dateFilter});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTITY_NAME);
        model.batchCreateNewEntryRow(ENTITY_NAME, query.size() + 1);
        DynamicObjectCollection entryentity = model.getEntryEntity(ENTITY_NAME);
        DynamicObjectType dot = entryentity.getDynamicObjectType();
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            DynamicObject data = (DynamicObject)entryentity.get(rowIndex);
            dot.getProperty(ITEM_NO).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_NO));
            dot.getProperty(ITEM_TYPE).setValueFast((Object)data, (Object)dynamicObject.getString(ITEM_TYPE));
            dot.getProperty(SDE).setValueFast((Object)data, (Object)dynamicObject.getString(SDE));
            dot.getProperty(RATE).setValueFast((Object)data, (Object)dynamicObject.getString(RATE));
            dot.getProperty(JMSE).setValueFast((Object)data, (Object)dynamicObject.getString(JMSE));
            ++rowIndex;
        }
        this.getView().updateView(ENTITY_NAME);
        this.appendCountRow(query, model, rowIndex);
    }

    private BigDecimal getSum(DynamicObjectCollection query, String name) {
        return query.stream().map(s -> s.getBigDecimal(name)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void appendCountRow(DynamicObjectCollection query, IDataModel model, int rowIndex) {
        model.setValue(ITEM_NO, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"HighTechFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue(ITEM_TYPE, (Object)"", rowIndex);
        model.setValue(SDE, (Object)this.getSum(query, SDE), rowIndex);
        model.setValue(JMSE, (Object)this.getSum(query, JMSE), rowIndex);
        model.setValue(JMSE, (Object)this.getSum(query, JMSE), rowIndex);
    }

    private BigDecimal getRate(String orgId, String code, String startdate, String enddate) {
        List deductionRateList = AssistService.queryAssistParams((String)code, (String)orgId, (String)startdate, (String)enddate);
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate2((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate2((String)model.getEndDate());
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)DG_NAME, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(HighTechFormPlugin.class.getSimpleName(), Collections.singletonList(DkynssdeTZFormPlugin.class.getSimpleName()));
            }
        };
    }
}

